/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.internal.colors;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.draw2d.ui.figures.FigureUtilities;
import org.eclipse.gmf.runtime.emf.core.util.PackageUtil;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.diagram.ui.provider.DiagramUIPlugin;
import org.eclipse.sirius.diagram.ui.tools.api.color.ColorCategoryManager;
import org.eclipse.sirius.diagram.ui.tools.api.color.ColorManager;
import org.eclipse.sirius.diagram.ui.tools.internal.colors.ColorsAnnotationHelper;
import org.eclipse.sirius.ui.tools.api.color.VisualBindingManager;
import org.eclipse.sirius.viewpoint.description.SystemColors;
import org.eclipse.swt.graphics.RGB;

public abstract class AbstractColorCategoryManager
implements ColorCategoryManager {
    public static final String FILL_CUSTOM_COLORS_ANNOTATION_SOURCE_NAME = "FillCustomColors";
    public static final String FILL_SUGGESTED_COLORS_ANNOTATION_SOURCE_NAME = "FillSuggestedColors";
    public static final String FONT_CUSTOM_COLORS_ANNOTATION_SOURCE_NAME = "FontCustomColors";
    public static final String FONT_SUGGESTED_COLORS_ANNOTATION_SOURCE_NAME = "FontSuggestedColors";
    public static final String LINE_CUSTOM_COLORS_ANNOTATION_SOURCE_NAME = "LineCustomColors";
    public static final String LINE_SUGGESTED_COLORS_ANNOTATION_SOURCE_NAME = "LineSuggestedColors";
    private static final List<RGB> BASIC_COLORS = AbstractColorCategoryManager.initBasicColors();
    private static final int NB_MAX_LAST_USED_COLORS = 10;
    private static final int NB_MAX_SUGGESTED_COLORS = 10;
    private static final String RGB_VALUES_SEPARATOR = ",";
    protected ColorsAnnotationHelper colorsAnnotationHelper;
    private List<IGraphicalEditPart> editParts;

    public AbstractColorCategoryManager(Session session, List<IGraphicalEditPart> editParts) {
        this.editParts = editParts;
        this.colorsAnnotationHelper = new ColorsAnnotationHelper(session);
    }

    private static List<RGB> initBasicColors() {
        LinkedList<RGB> basicColors = new LinkedList<RGB>();
        Map systemColors = VisualBindingManager.getDefault().getSystemPalette();
        basicColors.add((RGB)systemColors.get(SystemColors.BLACK_LITERAL.getName()));
        basicColors.add((RGB)systemColors.get(SystemColors.LIGHT_GRAY_LITERAL.getName()));
        basicColors.add((RGB)systemColors.get(SystemColors.WHITE_LITERAL.getName()));
        basicColors.add((RGB)systemColors.get(SystemColors.RED_LITERAL.getName()));
        basicColors.add((RGB)systemColors.get(SystemColors.ORANGE_LITERAL.getName()));
        basicColors.add((RGB)systemColors.get(SystemColors.YELLOW_LITERAL.getName()));
        basicColors.add((RGB)systemColors.get(SystemColors.GREEN_LITERAL.getName()));
        basicColors.add(new RGB(102, 204, 255));
        basicColors.add(new RGB(0, 51, 128));
        basicColors.add(new RGB(128, 0, 128));
        return basicColors;
    }

    @Override
    public List<RGB> getBasicColors() {
        return BASIC_COLORS;
    }

    protected List<RGB> getLastUsedColors(String lastUsedColorsPreference) {
        String lastUsedColorsString = DiagramUIPlugin.getPlugin().getPreferenceStore().getString(lastUsedColorsPreference);
        LinkedList<RGB> lastUsedColors = new LinkedList<RGB>();
        if (!lastUsedColorsString.isEmpty()) {
            String[] stringArray = lastUsedColorsString.split("},");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                RGB color = ColorManager.getDefault().stringToRGB(s + "}");
                lastUsedColors.add(color);
                ++n2;
            }
        }
        return lastUsedColors;
    }

    protected void addLastUsedColor(RGB lastUsedColor, String lastUsedColorsPreference) {
        List<RGB> lastUsedColors = this.getLastUsedColors(lastUsedColorsPreference);
        if (lastUsedColor != null) {
            if (!lastUsedColors.contains(lastUsedColor)) {
                lastUsedColors.add(0, lastUsedColor);
            } else {
                lastUsedColors.remove(lastUsedColor);
                lastUsedColors.add(0, lastUsedColor);
            }
            Object lastUsedColorsString = new String();
            int i = 0;
            while (i < lastUsedColors.size() && i < 10) {
                RGB rgb = lastUsedColors.get(i);
                lastUsedColorsString = (String)lastUsedColorsString + ColorManager.getDefault().rgbToString(rgb) + RGB_VALUES_SEPARATOR;
                ++i;
            }
            IPreferenceStore preferenceStore = DiagramUIPlugin.getPlugin().getPreferenceStore();
            preferenceStore.putValue(lastUsedColorsPreference, (String)lastUsedColorsString);
        }
    }

    protected List<RGB> getColors(String colorsAnnotationSourceName) {
        return this.colorsAnnotationHelper.getColorsDetails(colorsAnnotationSourceName);
    }

    protected void setColors(String colorsAnnotationSourceName, List<RGB> colorsList) {
        if (colorsList != null) {
            this.colorsAnnotationHelper.setColorsDetails(colorsAnnotationSourceName, colorsList);
        }
    }

    protected void setSuggestedColors(String colorsAnnotationSourceName, List<RGB> colorsList) {
        if (colorsList != null) {
            ArrayList<RGB> newColorsList = colorsList.size() > 10 ? new ArrayList<RGB>(colorsList.subList(0, 10)) : new ArrayList<RGB>(colorsList);
            this.setColors(colorsAnnotationSourceName, newColorsList);
        }
    }

    protected List<RGB> getSelectedColorsByPropertyId(String propertyId) {
        List<RGB> selectedColorsByPropertyId = Collections.EMPTY_LIST;
        if (this.editParts != null) {
            EStructuralFeature feature = (EStructuralFeature)PackageUtil.getElement((String)propertyId);
            selectedColorsByPropertyId = this.editParts.stream().map(ep -> ep.getStructuralFeatureValue(feature)).filter(Integer.class::isInstance).map(Integer.class::cast).map(colorInteger -> FigureUtilities.integerToRGB((Integer)colorInteger)).distinct().toList();
        }
        return selectedColorsByPropertyId;
    }
}

