/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.viewpoint.description.validation.impl;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.impl.EFactoryImpl;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.sirius.model.business.internal.description.validation.ValidationSetSpec;
import org.eclipse.sirius.viewpoint.description.validation.ERROR_LEVEL;
import org.eclipse.sirius.viewpoint.description.validation.RuleAudit;
import org.eclipse.sirius.viewpoint.description.validation.SemanticValidationRule;
import org.eclipse.sirius.viewpoint.description.validation.ValidationFactory;
import org.eclipse.sirius.viewpoint.description.validation.ValidationFix;
import org.eclipse.sirius.viewpoint.description.validation.ValidationPackage;
import org.eclipse.sirius.viewpoint.description.validation.ValidationSet;
import org.eclipse.sirius.viewpoint.description.validation.ViewValidationRule;
import org.eclipse.sirius.viewpoint.description.validation.impl.RuleAuditImpl;
import org.eclipse.sirius.viewpoint.description.validation.impl.SemanticValidationRuleImpl;
import org.eclipse.sirius.viewpoint.description.validation.impl.ValidationFixImpl;
import org.eclipse.sirius.viewpoint.description.validation.impl.ViewValidationRuleImpl;

public class ValidationFactoryImpl
extends EFactoryImpl
implements ValidationFactory {
    public static ValidationFactory init() {
        try {
            ValidationFactory theValidationFactory = (ValidationFactory)EPackage.Registry.INSTANCE.getEFactory("http://www.eclipse.org/sirius/description/validation/1.1.0");
            if (theValidationFactory != null) {
                return theValidationFactory;
            }
        }
        catch (Exception exception) {
            EcorePlugin.INSTANCE.log((Object)exception);
        }
        return new ValidationFactoryImpl();
    }

    public EObject create(EClass eClass) {
        switch (eClass.getClassifierID()) {
            case 0: {
                return this.createValidationSet();
            }
            case 2: {
                return this.createSemanticValidationRule();
            }
            case 3: {
                return this.createViewValidationRule();
            }
            case 4: {
                return this.createRuleAudit();
            }
            case 5: {
                return this.createValidationFix();
            }
        }
        throw new IllegalArgumentException("The class '" + eClass.getName() + "' is not a valid classifier");
    }

    public Object createFromString(EDataType eDataType, String initialValue) {
        switch (eDataType.getClassifierID()) {
            case 6: {
                return this.createERROR_LEVELFromString(eDataType, initialValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    public String convertToString(EDataType eDataType, Object instanceValue) {
        switch (eDataType.getClassifierID()) {
            case 6: {
                return this.convertERROR_LEVELToString(eDataType, instanceValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    @Override
    public ValidationSet createValidationSet() {
        ValidationSetSpec validationSet = new ValidationSetSpec();
        return validationSet;
    }

    @Override
    public SemanticValidationRule createSemanticValidationRule() {
        SemanticValidationRuleImpl semanticValidationRule = new SemanticValidationRuleImpl();
        return semanticValidationRule;
    }

    @Override
    public ViewValidationRule createViewValidationRule() {
        ViewValidationRuleImpl viewValidationRule = new ViewValidationRuleImpl();
        return viewValidationRule;
    }

    @Override
    public RuleAudit createRuleAudit() {
        RuleAuditImpl ruleAudit = new RuleAuditImpl();
        return ruleAudit;
    }

    @Override
    public ValidationFix createValidationFix() {
        ValidationFixImpl validationFix = new ValidationFixImpl();
        return validationFix;
    }

    public ERROR_LEVEL createERROR_LEVELFromString(EDataType eDataType, String initialValue) {
        ERROR_LEVEL result = ERROR_LEVEL.get(initialValue);
        if (result == null) {
            throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
        }
        return result;
    }

    public String convertERROR_LEVELToString(EDataType eDataType, Object instanceValue) {
        return instanceValue == null ? null : instanceValue.toString();
    }

    @Override
    public ValidationPackage getValidationPackage() {
        return (ValidationPackage)this.getEPackage();
    }

    @Deprecated
    public static ValidationPackage getPackage() {
        return ValidationPackage.eINSTANCE;
    }
}

