/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.properties.core.api;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.eef.core.api.InputDescriptor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.properties.core.internal.SiriusContext;

public class SiriusInputDescriptor
implements InputDescriptor {
    private final SiriusContext context;
    private List<SiriusContext> contextSelections = new ArrayList<SiriusContext>();

    public SiriusInputDescriptor(Object input, List<Object> rawSelection) {
        if (!rawSelection.contains(input)) {
            rawSelection.add(0, input);
        }
        for (Object selection : rawSelection) {
            this.contextSelections.add(SiriusContext.from(selection));
        }
        this.context = SiriusContext.from(input);
    }

    public SiriusInputDescriptor(Object input) {
        this(input, new ArrayList<Object>());
    }

    public Object getOriginalSelection() {
        return this.context.getInput();
    }

    public List<Object> getOriginalSelections() {
        ArrayList<Object> result = new ArrayList<Object>();
        for (SiriusContext siriusContext : this.contextSelections) {
            result.add(siriusContext.getInput());
        }
        return result;
    }

    public EObject getSemanticElement() {
        Option<EObject> obj = this.context.getMainSemanticElement();
        if (obj.some()) {
            return (EObject)obj.get();
        }
        return null;
    }

    public List<EObject> getSemanticElements() {
        ArrayList<EObject> result = new ArrayList<EObject>();
        for (SiriusContext siriusContext : this.contextSelections) {
            Option<EObject> obj = siriusContext.getMainSemanticElement();
            if (!obj.some()) continue;
            result.add((EObject)obj.get());
        }
        return result;
    }

    public Set<EObject> getAllSemanticElements() {
        LinkedHashSet<EObject> result = new LinkedHashSet<EObject>();
        result.add(this.getSemanticElement());
        Option<List<EObject>> additional = this.context.getAdditionalSemanticElements();
        if (additional.some()) {
            result.addAll((Collection)additional.get());
        }
        return result;
    }

    public SiriusContext getFullContext() {
        return this.context;
    }

    public List<SiriusContext> getContextSelections() {
        return this.contextSelections;
    }
}

