/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.tests.swtbot.support.api.condition;

import java.text.MessageFormat;
import org.eclipse.emf.transaction.RunnableWithResult;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swtbot.swt.finder.waits.DefaultCondition;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotTreeItem;

public class TreeItemExpanded
extends DefaultCondition {
    private final TreeItem widget;
    private final String name;
    private boolean expandedCheck = true;

    public TreeItemExpanded(SWTBotTreeItem treeItem, String name) {
        this.widget = (TreeItem)treeItem.widget;
        this.name = name;
    }

    public TreeItemExpanded(SWTBotTreeItem treeItem, String name, boolean expandedCheck) {
        this.widget = (TreeItem)treeItem.widget;
        this.name = name;
        this.expandedCheck = expandedCheck;
    }

    public static String getFailureMessage(boolean expandedCheck, String name) {
        String failureMessage = "Tree item with text {0} is not {1}";
        if (expandedCheck) {
            return MessageFormat.format(failureMessage, name, "expanded");
        }
        return MessageFormat.format(failureMessage, name, "collapsed");
    }

    public String getFailureMessage() {
        return TreeItemExpanded.getFailureMessage(this.expandedCheck, this.name);
    }

    public boolean test() throws Exception {
        RunnableWithResult.Impl<Boolean> runnable = new RunnableWithResult.Impl<Boolean>(){

            public void run() {
                TreeItemExpanded.this.widget.getDisplay().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        this.setResult((this).TreeItemExpanded.this.widget.getExpanded());
                    }
                });
            }
        };
        this.widget.getDisplay().syncExec((Runnable)runnable);
        if (this.expandedCheck) {
            return (Boolean)runnable.getResult();
        }
        return (Boolean)runnable.getResult() == false;
    }
}

