/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.transform.actions;

import org.eclipse.smarthome.core.transform.TransformationException;
import org.eclipse.smarthome.core.transform.TransformationHelper;
import org.eclipse.smarthome.core.transform.TransformationService;
import org.eclipse.smarthome.core.transform.internal.TransformationActivator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Transformation {
    public static String transform(String type, String function, String value) {
        String result;
        TransformationService service = TransformationHelper.getTransformationService(TransformationActivator.getContext(), type);
        Logger logger = LoggerFactory.getLogger(Transformation.class);
        if (service != null) {
            try {
                result = service.transform(function, value);
            }
            catch (TransformationException e) {
                logger.error("Error executing the transformation '{}': {}", (Object)type, (Object)e.getMessage());
                result = value;
            }
        } else {
            logger.warn("No transformation service '{}' could be found.", (Object)type);
            result = value;
        }
        return result;
    }
}

