/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.voice.text;

import java.util.ResourceBundle;
import org.eclipse.smarthome.core.voice.text.ASTNode;
import org.eclipse.smarthome.core.voice.text.Expression;
import org.eclipse.smarthome.core.voice.text.InterpretationResult;
import org.eclipse.smarthome.core.voice.text.TokenList;

public abstract class Rule {
    private Expression expression;

    public Rule(Expression expression) {
        this.expression = expression;
    }

    public abstract InterpretationResult interpretAST(ResourceBundle var1, ASTNode var2);

    InterpretationResult execute(ResourceBundle language, TokenList list) {
        ASTNode node = this.expression.parse(language, list);
        if (node.isSuccess() && node.getRemainingTokens().eof()) {
            return this.interpretAST(language, node);
        }
        return InterpretationResult.SYNTAX_ERROR;
    }

    public Expression getExpression() {
        return this.expression;
    }
}

