/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.yahooweather.internal.connection;

import java.io.IOException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import org.eclipse.smarthome.io.net.http.HttpUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class YahooWeatherConnection {
    private final Logger logger = LoggerFactory.getLogger(YahooWeatherConnection.class);
    private static final String WEBSERVICE_URL = "https://query.yahooapis.com/v1/public/yql?format=json";
    private static final String METHOD = "GET";
    private static final int TIMEOUT = 10000;

    public String getResponseFromQuery(String query) {
        try {
            return HttpUtil.executeUrl((String)METHOD, (String)("https://query.yahooapis.com/v1/public/yql?format=json&q=" + URLEncoder.encode(query, StandardCharsets.UTF_8.toString())), (int)10000);
        }
        catch (IOException e) {
            this.logger.warn("Communication error occurred while getting Yahoo weather information: {}", (Object)e.getMessage());
            return null;
        }
    }
}

