/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.weatherunderground.internal.discovery;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.eclipse.smarthome.binding.weatherunderground.WeatherUndergroundBindingConstants;
import org.eclipse.smarthome.config.discovery.AbstractDiscoveryService;
import org.eclipse.smarthome.config.discovery.DiscoveryResultBuilder;
import org.eclipse.smarthome.config.discovery.DiscoveryService;
import org.eclipse.smarthome.core.i18n.LocaleProvider;
import org.eclipse.smarthome.core.i18n.LocationProvider;
import org.eclipse.smarthome.core.i18n.TranslationProvider;
import org.eclipse.smarthome.core.library.types.PointType;
import org.eclipse.smarthome.core.thing.ThingTypeUID;
import org.eclipse.smarthome.core.thing.ThingUID;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={DiscoveryService.class}, immediate=true, configurationPid="discovery.weatherunderground")
public class WeatherUndergroundDiscoveryService
extends AbstractDiscoveryService {
    private final Logger logger = LoggerFactory.getLogger(WeatherUndergroundDiscoveryService.class);
    private static final Set<ThingTypeUID> SUPPORTED_THING_TYPES = Collections.singleton(WeatherUndergroundBindingConstants.THING_TYPE_WEATHER);
    private static final int DISCOVER_TIMEOUT_SECONDS = 10;
    private static final int LOCATION_CHANGED_CHECK_INTERVAL = 60;
    private LocationProvider locationProvider;
    private ScheduledFuture<?> discoveryJob;
    private PointType previousLocation;

    public WeatherUndergroundDiscoveryService() {
        super(SUPPORTED_THING_TYPES, 10, true);
    }

    protected void activate(Map<String, Object> configProperties) {
        super.activate(configProperties);
    }

    @Modified
    protected void modified(Map<String, Object> configProperties) {
        super.modified(configProperties);
    }

    protected void startScan() {
        this.logger.debug("Starting Weather Underground discovery scan");
        PointType location = this.locationProvider.getLocation();
        if (location == null) {
            this.logger.debug("LocationProvider.getLocation() is not set -> Will not provide any discovery results");
            return;
        }
        this.createResults(location);
    }

    protected void startBackgroundDiscovery() {
        if (this.discoveryJob == null) {
            this.discoveryJob = scheduler.scheduleWithFixedDelay(() -> {
                PointType currentLocation = this.locationProvider.getLocation();
                if (!Objects.equals(currentLocation, this.previousLocation)) {
                    this.logger.debug("Location has been changed from {} to {}: Creating new discovery results", (Object)this.previousLocation, (Object)currentLocation);
                    this.createResults(currentLocation);
                    this.previousLocation = currentLocation;
                }
            }, 0L, 60L, TimeUnit.SECONDS);
            this.logger.debug("Scheduled Weather Underground location-changed job every {} seconds", (Object)60);
        }
    }

    protected void stopBackgroundDiscovery() {
        this.logger.debug("Stopping Weather Underground device background discovery");
        if (this.discoveryJob != null && !this.discoveryJob.isCancelled() && this.discoveryJob.cancel(true)) {
            this.discoveryJob = null;
            this.logger.debug("Stopped Weather Underground device background discovery");
        }
    }

    public void createResults(PointType location) {
        ThingUID localWeatherThing = new ThingUID(WeatherUndergroundBindingConstants.THING_TYPE_WEATHER, "local");
        HashMap<String, String> properties = new HashMap<String, String>(3);
        properties.put("location", String.format("%s,%s", location.getLatitude(), location.getLongitude()));
        this.thingDiscovered(DiscoveryResultBuilder.create((ThingUID)localWeatherThing).withLabel("Local Weather").withProperties(properties).build());
    }

    @Reference
    protected void setLocationProvider(LocationProvider locationProvider) {
        this.locationProvider = locationProvider;
    }

    protected void unsetLocationProvider(LocationProvider locationProvider) {
        this.locationProvider = null;
    }

    @Reference
    protected void setLocaleProvider(LocaleProvider localeProvider) {
        this.localeProvider = localeProvider;
    }

    protected void unsetLocaleProvider(LocaleProvider localeProvider) {
        this.localeProvider = null;
    }

    @Reference
    protected void setTranslationProvider(TranslationProvider i18nProvider) {
        this.i18nProvider = i18nProvider;
    }

    protected void unsetTranslationProvider(TranslationProvider i18nProvider) {
        this.i18nProvider = null;
    }
}

