/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.automation.core.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.eclipse.smarthome.automation.Action;
import org.eclipse.smarthome.automation.Condition;
import org.eclipse.smarthome.automation.Rule;
import org.eclipse.smarthome.automation.Trigger;
import org.eclipse.smarthome.config.core.Configuration;

public class RuleUtils {
    public static List<Condition> getConditionsCopy(List<Condition> conditions) {
        ArrayList<Condition> res = new ArrayList<Condition>();
        if (conditions != null) {
            for (Condition c : conditions) {
                Condition condition = new Condition(c.getId(), c.getTypeUID(), new Configuration(c.getConfiguration().getProperties()), new HashMap(c.getInputs()));
                condition.setLabel(c.getLabel());
                condition.setDescription(c.getDescription());
                res.add(condition);
            }
        }
        return res;
    }

    public static List<Action> getActionsCopy(List<Action> actions) {
        ArrayList<Action> res = new ArrayList<Action>();
        if (actions != null) {
            for (Action a : actions) {
                Action action = new Action(a.getId(), a.getTypeUID(), new Configuration(a.getConfiguration().getProperties()), new HashMap(a.getInputs()));
                action.setLabel(a.getLabel());
                action.setDescription(a.getDescription());
                res.add(action);
            }
        }
        return res;
    }

    public static List<Trigger> getTriggersCopy(List<Trigger> triggers) {
        ArrayList<Trigger> res = new ArrayList<Trigger>();
        if (triggers != null) {
            for (Trigger t : triggers) {
                Trigger trigger = new Trigger(t.getId(), t.getTypeUID(), new Configuration(t.getConfiguration().getProperties()));
                trigger.setLabel(t.getLabel());
                trigger.setDescription(t.getDescription());
                res.add(trigger);
            }
        }
        return res;
    }

    public static Rule getRuleCopy(Rule r) {
        Rule rule = new Rule(r.getUID(), RuleUtils.getTriggersCopy(r.getTriggers()), RuleUtils.getConditionsCopy(r.getConditions()), RuleUtils.getActionsCopy(r.getActions()), new ArrayList(r.getConfigurationDescriptions()), new Configuration(r.getConfiguration().getProperties()), r.getTemplateUID(), r.getVisibility());
        String name = r.getName();
        if (name != null) {
            rule.setName(name);
        }
        rule.setTags(new HashSet(r.getTags()));
        String description = r.getDescription();
        if (description != null) {
            rule.setDescription(description);
        }
        return rule;
    }
}

