/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.thing.internal;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.smarthome.core.thing.Bridge;
import org.eclipse.smarthome.core.thing.Thing;
import org.eclipse.smarthome.core.thing.ThingTypeUID;
import org.eclipse.smarthome.core.thing.ThingUID;
import org.eclipse.smarthome.core.thing.binding.BridgeHandler;
import org.eclipse.smarthome.core.thing.binding.ThingHandler;
import org.eclipse.smarthome.core.thing.internal.ThingImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BridgeImpl
extends ThingImpl
implements Bridge {
    private transient List<Thing> things = new CopyOnWriteArrayList<Thing>();
    private transient Logger logger = LoggerFactory.getLogger(BridgeImpl.class);

    BridgeImpl() {
    }

    public BridgeImpl(ThingTypeUID thingTypeUID, String bridgeId) {
        super(thingTypeUID, bridgeId);
    }

    @Deprecated
    public BridgeImpl(ThingUID thingUID) throws IllegalArgumentException {
        super(thingUID);
    }

    public BridgeImpl(ThingTypeUID thingTypeUID, ThingUID thingUID) throws IllegalArgumentException {
        super(thingTypeUID, thingUID);
    }

    public void addThing(Thing thing) {
        this.things.add(thing);
    }

    public void removeThing(Thing thing) {
        this.things.remove(thing);
    }

    @Override
    public List<Thing> getThings() {
        return ImmutableList.copyOf(this.things);
    }

    @Override
    public BridgeHandler getHandler() {
        BridgeHandler bridgeHandler = null;
        ThingHandler thingHandler = super.getHandler();
        if (thingHandler instanceof BridgeHandler) {
            bridgeHandler = (BridgeHandler)thingHandler;
        } else if (thingHandler != null) {
            this.logger.warn("Handler of bridge '{}' must implement BridgeHandler interface.", (Object)this.getUID());
        }
        return bridgeHandler;
    }
}

