/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.thing.internal.link;

import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import org.eclipse.smarthome.config.core.ConfigDescription;
import org.eclipse.smarthome.config.core.ConfigDescriptionParameter;
import org.eclipse.smarthome.config.core.ConfigDescriptionParameterBuilder;
import org.eclipse.smarthome.config.core.ConfigDescriptionProvider;
import org.eclipse.smarthome.config.core.ParameterOption;
import org.eclipse.smarthome.core.items.Item;
import org.eclipse.smarthome.core.items.ItemRegistry;
import org.eclipse.smarthome.core.thing.Channel;
import org.eclipse.smarthome.core.thing.Thing;
import org.eclipse.smarthome.core.thing.ThingRegistry;
import org.eclipse.smarthome.core.thing.link.ItemChannelLink;
import org.eclipse.smarthome.core.thing.link.ItemChannelLinkRegistry;
import org.eclipse.smarthome.core.thing.profiles.ProfileType;
import org.eclipse.smarthome.core.thing.profiles.ProfileTypeRegistry;
import org.eclipse.smarthome.core.thing.profiles.ProfileTypeUID;
import org.eclipse.smarthome.core.thing.profiles.StateProfileType;
import org.eclipse.smarthome.core.thing.profiles.TriggerProfileType;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component
public class ItemChannelLinkConfigDescriptionProvider
implements ConfigDescriptionProvider {
    private static final String SCHEME = "link";
    public static final String PARAM_PROFILE = "profile";
    private ProfileTypeRegistry profileTypeRegistry;
    private ItemChannelLinkRegistry itemChannelLinkRegistry;
    private ItemRegistry itemRegistry;
    private ThingRegistry thingRegistry;

    public Collection<ConfigDescription> getConfigDescriptions(Locale locale) {
        return Collections.emptySet();
    }

    public ConfigDescription getConfigDescription(URI uri, Locale locale) {
        if (SCHEME.equals(uri.getScheme())) {
            ItemChannelLink link = (ItemChannelLink)this.itemChannelLinkRegistry.get(uri.getSchemeSpecificPart());
            if (link == null) {
                return null;
            }
            Item item = (Item)this.itemRegistry.get((Object)link.getItemName());
            if (item == null) {
                return null;
            }
            Thing thing = this.thingRegistry.get(link.getLinkedUID().getThingUID());
            if (thing == null) {
                return null;
            }
            Channel channel = thing.getChannel(link.getLinkedUID().getId());
            if (channel == null) {
                return null;
            }
            ConfigDescriptionParameter paramProfile = ConfigDescriptionParameterBuilder.create((String)PARAM_PROFILE, (ConfigDescriptionParameter.Type)ConfigDescriptionParameter.Type.TEXT).withLabel("Profile").withDescription("the profile to use").withRequired(Boolean.valueOf(false)).withLimitToOptions(Boolean.valueOf(true)).withOptions(this.getOptions(link, item, channel, locale)).build();
            return new ConfigDescription(uri, Collections.singletonList(paramProfile));
        }
        return null;
    }

    private List<ParameterOption> getOptions(ItemChannelLink link, Item item, Channel channel, Locale locale) {
        List<ProfileType> profileTypes = this.profileTypeRegistry.getProfileTypes(locale);
        return profileTypes.stream().filter(profileType -> {
            switch (channel.getKind()) {
                case STATE: {
                    return profileType instanceof StateProfileType && this.isSupportedItemType((ProfileType)profileType, item);
                }
                case TRIGGER: {
                    return profileType instanceof TriggerProfileType && this.isSupportedItemType((ProfileType)profileType, item) && this.isSupportedChannelType((TriggerProfileType)profileType, channel);
                }
            }
            throw new IllegalArgumentException("Unknown channel kind: " + (Object)((Object)channel.getKind()));
        }).map(profileType -> new ParameterOption(((ProfileTypeUID)profileType.getUID()).toString(), profileType.getLabel())).collect(Collectors.toList());
    }

    private boolean isSupportedItemType(ProfileType profileType, Item item) {
        return profileType.getSupportedItemTypes().isEmpty() || profileType.getSupportedItemTypes().contains(item.getType());
    }

    private boolean isSupportedChannelType(TriggerProfileType profileType, Channel channel) {
        return profileType.getSupportedChannelTypeUIDs().isEmpty() || profileType.getSupportedChannelTypeUIDs().contains(channel.getChannelTypeUID());
    }

    @Reference
    public void setProfileTypeRegistry(ProfileTypeRegistry profileTypeRegistry) {
        this.profileTypeRegistry = profileTypeRegistry;
    }

    public void unsetProfileTypeRegistry(ProfileTypeRegistry profileTypeRegistry) {
        this.profileTypeRegistry = null;
    }

    @Reference
    public void setItemChannelLinkRegistry(ItemChannelLinkRegistry itemChannelLinkRegistry) {
        this.itemChannelLinkRegistry = itemChannelLinkRegistry;
    }

    public void unsetItemChannelLinkRegistry(ItemChannelLinkRegistry itemChannelLinkRegistry) {
        this.itemChannelLinkRegistry = null;
    }

    @Reference
    public void setItemRegistry(ItemRegistry itemRegistry) {
        this.itemRegistry = itemRegistry;
    }

    public void unsetItemRegistry(ItemRegistry itemRegistry) {
        this.itemRegistry = null;
    }

    @Reference
    public void setThingRegistry(ThingRegistry thingRegistry) {
        this.thingRegistry = thingRegistry;
    }

    public void unsetThingRegistry(ThingRegistry thingRegistry) {
        this.thingRegistry = thingRegistry;
    }
}

