/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.thing.type;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.smarthome.core.thing.type.ChannelGroupType;
import org.eclipse.smarthome.core.thing.type.ChannelGroupTypeUID;
import org.eclipse.smarthome.core.thing.type.ChannelType;
import org.eclipse.smarthome.core.thing.type.ChannelTypeProvider;
import org.eclipse.smarthome.core.thing.type.ChannelTypeUID;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;

@NonNullByDefault
@Component(immediate=true, service={ChannelTypeRegistry.class})
public class ChannelTypeRegistry {
    private final List<ChannelTypeProvider> channelTypeProviders = new CopyOnWriteArrayList<ChannelTypeProvider>();

    public List<ChannelType> getChannelTypes() {
        return this.getChannelTypes(null);
    }

    public List<ChannelType> getChannelTypes(@Nullable Locale locale) {
        ArrayList<ChannelType> channelTypes = new ArrayList<ChannelType>();
        for (ChannelTypeProvider channelTypeProvider : this.channelTypeProviders) {
            channelTypes.addAll(channelTypeProvider.getChannelTypes(locale));
        }
        return Collections.unmodifiableList(channelTypes);
    }

    public @Nullable ChannelType getChannelType(@Nullable ChannelTypeUID channelTypeUID) {
        return this.getChannelType(channelTypeUID, null);
    }

    public @Nullable ChannelType getChannelType(@Nullable ChannelTypeUID channelTypeUID, @Nullable Locale locale) {
        if (channelTypeUID == null) {
            return null;
        }
        for (ChannelTypeProvider channelTypeProvider : this.channelTypeProviders) {
            ChannelType channelType = channelTypeProvider.getChannelType(channelTypeUID, locale);
            if (channelType == null) continue;
            return channelType;
        }
        return null;
    }

    public List<ChannelGroupType> getChannelGroupTypes() {
        return this.getChannelGroupTypes(null);
    }

    public List<ChannelGroupType> getChannelGroupTypes(@Nullable Locale locale) {
        ArrayList<ChannelGroupType> channelGroupTypes = new ArrayList<ChannelGroupType>();
        for (ChannelTypeProvider channelTypeProvider : this.channelTypeProviders) {
            channelGroupTypes.addAll(channelTypeProvider.getChannelGroupTypes(locale));
        }
        return Collections.unmodifiableList(channelGroupTypes);
    }

    public @Nullable ChannelGroupType getChannelGroupType(@Nullable ChannelGroupTypeUID channelGroupTypeUID) {
        return this.getChannelGroupType(channelGroupTypeUID, null);
    }

    public @Nullable ChannelGroupType getChannelGroupType(@Nullable ChannelGroupTypeUID channelGroupTypeUID, @Nullable Locale locale) {
        if (channelGroupTypeUID == null) {
            return null;
        }
        for (ChannelTypeProvider channelTypeProvider : this.channelTypeProviders) {
            ChannelGroupType channelGroupType = channelTypeProvider.getChannelGroupType(channelGroupTypeUID, locale);
            if (channelGroupType == null) continue;
            return channelGroupType;
        }
        return null;
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    protected void addChannelTypeProvider(ChannelTypeProvider channelTypeProviders) {
        this.channelTypeProviders.add(channelTypeProviders);
    }

    protected void removeChannelTypeProvider(ChannelTypeProvider channelTypeProviders) {
        this.channelTypeProviders.remove(channelTypeProviders);
    }
}

