/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.io.rest.sitemap.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.smarthome.core.items.GenericItem;
import org.eclipse.smarthome.core.items.GroupItem;
import org.eclipse.smarthome.core.items.Item;
import org.eclipse.smarthome.core.items.ItemNotFoundException;
import org.eclipse.smarthome.core.items.StateChangeListener;
import org.eclipse.smarthome.core.types.State;
import org.eclipse.smarthome.io.rest.core.item.EnrichedItemDTOMapper;
import org.eclipse.smarthome.io.rest.sitemap.SitemapSubscriptionService;
import org.eclipse.smarthome.io.rest.sitemap.internal.SitemapChangedEvent;
import org.eclipse.smarthome.io.rest.sitemap.internal.SitemapEvent;
import org.eclipse.smarthome.io.rest.sitemap.internal.SitemapWidgetEvent;
import org.eclipse.smarthome.model.sitemap.Frame;
import org.eclipse.smarthome.model.sitemap.LinkableWidget;
import org.eclipse.smarthome.model.sitemap.VisibilityRule;
import org.eclipse.smarthome.model.sitemap.Widget;
import org.eclipse.smarthome.ui.items.ItemUIRegistry;

public class PageChangeListener
implements StateChangeListener {
    private final String sitemapName;
    private final String pageId;
    private final ItemUIRegistry itemUIRegistry;
    private EList<Widget> widgets;
    private Set<Item> items;
    private final List<SitemapSubscriptionService.SitemapSubscriptionCallback> callbacks = Collections.synchronizedList(new ArrayList());
    private Set<SitemapSubscriptionService.SitemapSubscriptionCallback> distinctCallbacks = Collections.emptySet();

    public PageChangeListener(String sitemapName, String pageId, ItemUIRegistry itemUIRegistry, EList<Widget> widgets) {
        this.sitemapName = sitemapName;
        this.pageId = pageId;
        this.itemUIRegistry = itemUIRegistry;
        this.updateItemsAndWidgets(widgets);
    }

    private void updateItemsAndWidgets(EList<Widget> widgets) {
        if (this.widgets != null) {
            this.items = this.getAllItems(this.widgets);
            for (Item item : this.items) {
                if (!(item instanceof GenericItem)) continue;
                ((GenericItem)item).removeStateChangeListener((StateChangeListener)this);
            }
        }
        this.widgets = widgets;
        this.items = this.getAllItems(widgets);
        for (Item item : this.items) {
            if (!(item instanceof GenericItem)) continue;
            ((GenericItem)item).addStateChangeListener((StateChangeListener)this);
        }
    }

    public String getSitemapName() {
        return this.sitemapName;
    }

    public String getPageId() {
        return this.pageId;
    }

    public void addCallback(SitemapSubscriptionService.SitemapSubscriptionCallback callback) {
        this.callbacks.add(callback);
        this.distinctCallbacks = new HashSet<SitemapSubscriptionService.SitemapSubscriptionCallback>(this.callbacks);
    }

    public void removeCallback(SitemapSubscriptionService.SitemapSubscriptionCallback callback) {
        this.callbacks.remove(callback);
        this.distinctCallbacks = new HashSet<SitemapSubscriptionService.SitemapSubscriptionCallback>(this.callbacks);
    }

    public void dispose() {
        for (Item item : this.items) {
            if (item instanceof GenericItem) {
                ((GenericItem)item).removeStateChangeListener((StateChangeListener)this);
                continue;
            }
            if (!(item instanceof GroupItem)) continue;
            ((GroupItem)item).removeStateChangeListener((StateChangeListener)this);
        }
    }

    private Set<Item> getAllItems(EList<Widget> widgets) {
        HashSet<Item> items = new HashSet<Item>();
        if (this.itemUIRegistry != null) {
            for (Widget widget : widgets) {
                this.addItemWithName(items, widget.getItem());
                if (widget instanceof Frame) {
                    items.addAll(this.getAllItems((EList<Widget>)((Frame)widget).getChildren()));
                }
                for (VisibilityRule vr : widget.getVisibility()) {
                    this.addItemWithName(items, vr.getItem());
                }
            }
        }
        return items;
    }

    private void addItemWithName(Set<Item> items, String itemName) {
        if (itemName != null) {
            try {
                Item item = this.itemUIRegistry.getItem(itemName);
                items.add(item);
            }
            catch (ItemNotFoundException itemNotFoundException) {
                // empty catch block
            }
        }
    }

    public void stateChanged(Item item, State oldState, State newState) {
        if (item instanceof GroupItem) {
            return;
        }
        Set<SitemapEvent> events = this.constructSitemapEvents(item, (List<Widget>)this.widgets);
        for (SitemapEvent event : events) {
            for (SitemapSubscriptionService.SitemapSubscriptionCallback callback : this.distinctCallbacks) {
                callback.onEvent(event);
            }
        }
    }

    public void stateUpdated(Item item, State state) {
        if (!(item instanceof GroupItem)) {
            return;
        }
        Set<SitemapEvent> events = this.constructSitemapEvents(item, (List<Widget>)this.widgets);
        for (SitemapEvent event : events) {
            for (SitemapSubscriptionService.SitemapSubscriptionCallback callback : this.distinctCallbacks) {
                callback.onEvent(event);
            }
        }
    }

    private Set<SitemapEvent> constructSitemapEvents(Item item, List<Widget> widgets) {
        HashSet<SitemapEvent> events = new HashSet<SitemapEvent>();
        for (Widget w : widgets) {
            if (w instanceof Frame) {
                events.addAll(this.constructSitemapEvents(item, (List<Widget>)this.itemUIRegistry.getChildren((LinkableWidget)((Frame)w))));
            }
            if ((w.getItem() == null || !w.getItem().equals(item.getName())) && !this.definesVisibility(w, item.getName())) continue;
            SitemapWidgetEvent event = new SitemapWidgetEvent();
            event.sitemapName = this.sitemapName;
            event.pageId = this.pageId;
            event.label = this.itemUIRegistry.getLabel(w);
            event.labelcolor = this.itemUIRegistry.getLabelColor(w);
            event.valuecolor = this.itemUIRegistry.getValueColor(w);
            event.widgetId = this.itemUIRegistry.getWidgetId(w);
            event.visibility = this.itemUIRegistry.getVisiblity(w);
            event.item = EnrichedItemDTOMapper.map((Item)item, (boolean)false, null, null);
            event.item.state = this.itemUIRegistry.getState(w).toFullString();
            events.add(event);
        }
        return events;
    }

    private boolean definesVisibility(Widget w, String name) {
        for (VisibilityRule vr : w.getVisibility()) {
            if (!name.equals(vr.getItem())) continue;
            return true;
        }
        return false;
    }

    public void sitemapContentChanged() {
        SitemapChangedEvent changeEvent = new SitemapChangedEvent();
        changeEvent.pageId = this.pageId;
        changeEvent.sitemapName = this.sitemapName;
        for (SitemapSubscriptionService.SitemapSubscriptionCallback callback : this.distinctCallbacks) {
            callback.onEvent(changeEvent);
        }
    }
}

