/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.storage.json.internal;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.smarthome.config.core.ConfigConstants;
import org.eclipse.smarthome.core.storage.Storage;
import org.eclipse.smarthome.core.storage.StorageService;
import org.eclipse.smarthome.storage.json.internal.JsonStorage;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonStorageService
implements StorageService {
    private final Logger logger = LoggerFactory.getLogger(JsonStorageService.class);
    private String dbFolderName = "jsondb";
    private final String CFG_MAX_BACKUP_FILES = "backup_files";
    private final String CFG_WRITE_DELAY = "write_delay";
    private final String CFG_MAX_DEFER_DELAY = "max_defer_delay";
    private int maxBackupFiles = 5;
    private int writeDelay = 500;
    private int maxDeferredPeriod = 60000;
    private final Map<String, JsonStorage<Object>> storageList = new HashMap<String, JsonStorage<Object>>();

    protected void activate(ComponentContext cContext, Map<String, Object> properties) {
        File backup;
        this.dbFolderName = String.valueOf(ConfigConstants.getUserDataFolder()) + File.separator + this.dbFolderName;
        File folder = new File(this.dbFolderName);
        if (!folder.exists()) {
            folder.mkdirs();
        }
        if (!(backup = new File(this.dbFolderName, "backup")).exists()) {
            backup.mkdirs();
        }
        this.logger.debug("Json Storage Service: Activated.");
        if (properties == null || properties.isEmpty()) {
            return;
        }
        try {
            if (properties.get("backup_files") != null) {
                this.maxBackupFiles = Integer.parseInt((String)properties.get("backup_files"));
            }
        }
        catch (NumberFormatException nfe) {
            this.logger.error("Value {} for {} is invalid. Using {}.", new Object[]{properties.get("backup_files"), "backup_files", this.maxBackupFiles});
        }
        try {
            if (properties.get("write_delay") != null) {
                this.writeDelay = Integer.parseInt((String)properties.get("write_delay"));
            }
        }
        catch (NumberFormatException nfe) {
            this.logger.error("Value {} for {} is invalid. Using {}.", new Object[]{properties.get("write_delay"), "write_delay", this.writeDelay});
        }
        try {
            if (properties.get("max_defer_delay") != null) {
                this.maxDeferredPeriod = Integer.parseInt((String)properties.get("max_defer_delay"));
            }
        }
        catch (NumberFormatException nfe) {
            this.logger.error("Value {} for {} is invalid. Using {}.", new Object[]{properties.get("max_defer_delay"), "max_defer_delay", this.maxDeferredPeriod});
        }
    }

    protected void deactivate() {
        for (JsonStorage<Object> storage : this.storageList.values()) {
            storage.commitDatabase();
        }
        this.logger.debug("Json Storage Service: Deactivated.");
    }

    public <T> Storage<T> getStorage(String name, ClassLoader classLoader) {
        File file = new File(this.dbFolderName, String.valueOf(name) + ".json");
        if (!this.storageList.containsKey(name)) {
            this.storageList.put(name, new JsonStorage(file, classLoader, this.maxBackupFiles, this.writeDelay, this.maxDeferredPeriod));
        }
        return this.storageList.get(name);
    }

    public <T> Storage<T> getStorage(String name) {
        return this.getStorage(name, null);
    }
}

