/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.automation.dto;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.smarthome.automation.dto.ActionDTOMapper;
import org.eclipse.smarthome.automation.dto.ActionTypeDTO;
import org.eclipse.smarthome.automation.dto.CompositeActionTypeDTO;
import org.eclipse.smarthome.automation.dto.ModuleTypeDTOMapper;
import org.eclipse.smarthome.automation.type.ActionType;
import org.eclipse.smarthome.automation.type.CompositeActionType;

public class ActionTypeDTOMapper
extends ModuleTypeDTOMapper {
    public static ActionTypeDTO map(ActionType actionType) {
        return ActionTypeDTOMapper.map(actionType, new ActionTypeDTO());
    }

    public static CompositeActionTypeDTO map(CompositeActionType actionType) {
        CompositeActionTypeDTO actionTypeDto = ActionTypeDTOMapper.map(actionType, new CompositeActionTypeDTO());
        actionTypeDto.children = ActionDTOMapper.map(actionType.getChildren());
        return actionTypeDto;
    }

    public static List<ActionTypeDTO> map(Collection<ActionType> types) {
        if (types == null) {
            return null;
        }
        ArrayList<ActionTypeDTO> dtos = new ArrayList<ActionTypeDTO>(types.size());
        for (ActionType type : types) {
            if (type instanceof CompositeActionType) {
                dtos.add(ActionTypeDTOMapper.map((CompositeActionType)type));
                continue;
            }
            dtos.add(ActionTypeDTOMapper.map(type));
        }
        return dtos;
    }

    private static <T extends ActionTypeDTO> T map(ActionType actionType, T actionTypeDto) {
        ActionTypeDTOMapper.fillProperties(actionType, actionTypeDto);
        actionTypeDto.inputs = actionType.getInputs();
        actionTypeDto.outputs = actionType.getOutputs();
        return actionTypeDto;
    }
}

