/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.automation.internal.commands;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Set;
import org.eclipse.smarthome.automation.Rule;
import org.eclipse.smarthome.automation.internal.commands.AbstractCommandProvider;
import org.eclipse.smarthome.automation.internal.commands.AutomationCommandsPluggable;
import org.eclipse.smarthome.automation.parser.Parser;
import org.eclipse.smarthome.automation.parser.ParsingException;
import org.eclipse.smarthome.automation.parser.ParsingNestedException;
import org.eclipse.smarthome.core.common.registry.Identifiable;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class CommandlineRuleImporter
extends AbstractCommandProvider<Rule> {
    public CommandlineRuleImporter(BundleContext context) {
        super(context);
    }

    @Override
    public Object addingService(ServiceReference reference) {
        if (reference.getProperty("parser.type").equals("parser.rule")) {
            return super.addingService(reference);
        }
        return null;
    }

    public String exportRules(String parserType, Set<Rule> set, File file) throws Exception {
        return super.exportData(parserType, set, file);
    }

    public Set<Rule> importRules(String parserType, URL url) throws IOException, ParsingException {
        Parser parser = (Parser)this.parsers.get(parserType);
        if (parser != null) {
            try (InputStreamReader inputStreamReader = new InputStreamReader(new BufferedInputStream(url.openStream()));){
                Set<Rule> set = this.importData(url, (Parser<Rule>)parser, inputStreamReader);
                return set;
            }
        }
        throw new ParsingException(new ParsingNestedException(3, null, (Throwable)new Exception("Parser " + parserType + " not available")));
    }

    @Override
    protected Set<Rule> importData(URL url, Parser<Rule> parser, InputStreamReader inputStreamReader) throws ParsingException {
        Set providedRules = parser.parse(inputStreamReader);
        if (providedRules != null && !providedRules.isEmpty()) {
            for (Rule rule : providedRules) {
                if (rule == null) continue;
                if (AutomationCommandsPluggable.ruleRegistry.get((Object)rule.getUID()) != null) {
                    AutomationCommandsPluggable.ruleRegistry.update((Identifiable)rule);
                    continue;
                }
                AutomationCommandsPluggable.ruleRegistry.add((Identifiable)rule);
            }
        }
        return providedRules;
    }
}

