/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.internal.common;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.smarthome.core.internal.common.AbstractInvocationHandler;
import org.eclipse.smarthome.core.internal.common.Invocation;
import org.eclipse.smarthome.core.internal.common.SafeCallManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
public class InvocationHandlerSync<T>
extends AbstractInvocationHandler<T>
implements InvocationHandler {
    private static final String MSG_CONTEXT = "Already in a safe-call context, executing '{}' directly on '{}'.";
    private final Logger logger = LoggerFactory.getLogger(InvocationHandlerSync.class);

    public InvocationHandlerSync(SafeCallManager manager, T target, Object identifier, long timeout, @Nullable Consumer<Throwable> exceptionHandler, @Nullable Runnable timeoutHandler) {
        super(manager, target, identifier, timeout, exceptionHandler, timeoutHandler);
    }

    @Override
    public @Nullable Object invoke(@Nullable Object proxy, @Nullable Method method, Object @Nullable [] args) throws Throwable {
        if (method != null) {
            Invocation invocation = new Invocation(this, method, args);
            Invocation activeInvocation = this.getManager().getActiveInvocation();
            if (activeInvocation != null) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug(MSG_CONTEXT, (Object)this.toString(method), this.getTarget());
                }
                try {
                    activeInvocation.getInvocationStack().push(invocation);
                    Object object = this.invokeDirect(invocation);
                    return object;
                }
                finally {
                    activeInvocation.getInvocationStack().poll();
                }
            }
            try {
                Future<Object> future = this.getManager().getScheduler().submit(invocation);
                return future.get(this.getTimeout(), TimeUnit.MILLISECONDS);
            }
            catch (TimeoutException e) {
                this.handleTimeout(method, invocation);
            }
            catch (ExecutionException e) {
                this.handleExecutionException(method, e);
            }
        }
        return null;
    }
}

