/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.library.types;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.smarthome.core.library.types.StringType;
import org.eclipse.smarthome.core.types.Command;
import org.eclipse.smarthome.core.types.State;

public class StringListType
implements Command,
State {
    protected List<String> typeDetails;
    public static final String DELIMITER = ",";
    public static final String ESCAPED_DELIMITER = "\\,";
    public static final String REGEX_SPLITTER = "(?<!\\\\),";

    public StringListType() {
        this.typeDetails = Collections.emptyList();
    }

    public StringListType(List<String> rows) {
        this.typeDetails = new ArrayList<String>(rows);
    }

    public StringListType(StringType ... rows) {
        this.typeDetails = Arrays.stream(rows).map(StringType::toString).collect(Collectors.toList());
    }

    public StringListType(String ... rows) {
        this.typeDetails = Arrays.asList(rows);
    }

    public StringListType(String serialized) {
        this.typeDetails = Arrays.stream(serialized.split(REGEX_SPLITTER)).map(s -> s.replace(ESCAPED_DELIMITER, DELIMITER)).collect(Collectors.toList());
    }

    public String getValue(int index) {
        if (index < 0 || index >= this.typeDetails.size()) {
            throw new IllegalArgumentException("Index is out of range");
        }
        return this.typeDetails.get(index);
    }

    @Override
    public String format(String pattern) {
        return String.format(pattern, this.typeDetails.toArray());
    }

    public String toString() {
        return this.toFullString();
    }

    @Override
    public String toFullString() {
        return this.typeDetails.stream().map(s -> s.replace(DELIMITER, ESCAPED_DELIMITER)).collect(Collectors.joining(DELIMITER));
    }

    public static StringListType valueOf(String value) {
        return new StringListType(value);
    }
}

