/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.io.transport.mqtt;

import org.apache.commons.lang.StringUtils;

public class MqttWillAndTestament {
    private String topic;
    private byte[] payload;
    private int qos = 0;
    private boolean retain = false;

    public static MqttWillAndTestament fromString(String string) {
        if (string == null) {
            return null;
        }
        MqttWillAndTestament result = new MqttWillAndTestament();
        String[] components = string.split(":");
        int i = 0;
        while (i < Math.min(components.length, 4)) {
            String value = StringUtils.trimToEmpty((String)components[i]);
            switch (i) {
                case 0: {
                    result.topic = value;
                    break;
                }
                case 1: {
                    result.payload = value.getBytes();
                    break;
                }
                case 2: {
                    int qos;
                    if ("".equals(value) || (qos = Integer.valueOf(value).intValue()) < 0 || qos > 2) break;
                    result.qos = qos;
                    break;
                }
                case 3: {
                    result.retain = Boolean.valueOf(value);
                }
            }
            ++i;
        }
        return result.isValid() ? result : null;
    }

    private MqttWillAndTestament() {
    }

    public MqttWillAndTestament(String topic, byte[] payload, int qos, boolean retain) {
        if (StringUtils.isBlank((String)topic)) {
            throw new IllegalArgumentException("Topic must be set");
        }
        this.topic = topic;
        this.payload = payload;
        this.qos = qos;
        this.retain = retain;
    }

    private boolean isValid() {
        return !StringUtils.isBlank((String)this.topic);
    }

    public String getTopic() {
        return this.topic;
    }

    public byte[] getPayload() {
        return this.payload;
    }

    public int getQos() {
        return this.qos;
    }

    public boolean isRetain() {
        return this.retain;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[").append(this.getClass());
        sb.append("] Send '");
        if (this.payload != null) {
            sb.append(new String(this.payload));
        } else {
            sb.append(this.payload);
        }
        sb.append("' to topic '");
        sb.append(this.topic);
        sb.append("'");
        if (this.retain) {
            sb.append(" retained");
        }
        sb.append(" using qos mode ").append(this.qos);
        return sb.toString();
    }
}

