/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.ui.internal.chart;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Objects;
import javax.imageio.ImageIO;
import javax.imageio.stream.ImageOutputStream;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.BooleanUtils;
import org.eclipse.smarthome.core.items.ItemNotFoundException;
import org.eclipse.smarthome.ui.chart.ChartProvider;
import org.eclipse.smarthome.ui.items.ItemUIRegistry;
import org.osgi.service.http.HttpContext;
import org.osgi.service.http.HttpService;
import org.osgi.service.http.NamespaceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChartServlet
extends HttpServlet {
    private static final long serialVersionUID = 7700873790924746422L;
    private static final int CHART_HEIGHT = 240;
    private static final int CHART_WIDTH = 480;
    private static final String DATE_FORMAT = "yyyyMMddHHmm";
    private final Logger logger = LoggerFactory.getLogger(ChartServlet.class);
    private String providerName = "default";
    private int defaultHeight = 240;
    private int defaultWidth = 480;
    private double scale = 1.0;
    private int maxWidth = -1;
    public static final String SERVLET_NAME = "/chart";
    protected static final Map<String, Long> PERIODS = new HashMap<String, Long>();
    protected HttpService httpService;
    protected ItemUIRegistry itemUIRegistry;
    protected static Map<String, ChartProvider> chartProviders;

    static {
        PERIODS.put("h", 3600000L);
        PERIODS.put("4h", 14400000L);
        PERIODS.put("8h", 28800000L);
        PERIODS.put("12h", 43200000L);
        PERIODS.put("D", 86400000L);
        PERIODS.put("2D", 172800000L);
        PERIODS.put("3D", 259200000L);
        PERIODS.put("W", 604800000L);
        PERIODS.put("2W", 1209600000L);
        PERIODS.put("M", 2592000000L);
        PERIODS.put("2M", 5184000000L);
        PERIODS.put("4M", 10368000000L);
        PERIODS.put("Y", 31536000000L);
        chartProviders = new HashMap<String, ChartProvider>();
    }

    public void setHttpService(HttpService httpService) {
        this.httpService = httpService;
    }

    public void unsetHttpService(HttpService httpService) {
        this.httpService = null;
    }

    public void setItemUIRegistry(ItemUIRegistry itemUIRegistry) {
        this.itemUIRegistry = itemUIRegistry;
    }

    public void unsetItemUIRegistry(ItemUIRegistry itemUIRegistry) {
        this.itemUIRegistry = null;
    }

    public void addChartProvider(ChartProvider provider) {
        chartProviders.put(provider.getName(), provider);
    }

    public void removeChartProvider(ChartProvider provider) {
        chartProviders.remove(provider.getName());
    }

    public static Map<String, ChartProvider> getChartProviders() {
        return chartProviders;
    }

    protected void activate(Map<String, Object> config) {
        try {
            this.logger.debug("Starting up chart servlet at /chart");
            Hashtable props = new Hashtable();
            this.httpService.registerServlet(SERVLET_NAME, (Servlet)this, props, this.createHttpContext());
        }
        catch (NamespaceException e) {
            this.logger.error("Error during chart servlet startup", (Throwable)e);
        }
        catch (ServletException e) {
            this.logger.error("Error during chart servlet startup", (Throwable)e);
        }
        this.applyConfig(config);
    }

    protected void deactivate() {
        this.httpService.unregister(SERVLET_NAME);
    }

    protected void modified(Map<String, Object> config) {
        this.applyConfig(config);
    }

    private void applyConfig(Map<String, Object> config) {
        String maxWidthString;
        String scaleString;
        String defaultWidthString;
        String defaultHeightString;
        if (config == null) {
            return;
        }
        String providerNameString = Objects.toString(config.get("provider"), null);
        if (providerNameString != null) {
            this.providerName = providerNameString;
        }
        if ((defaultHeightString = Objects.toString(config.get("defaultHeight"), null)) != null) {
            this.defaultHeight = Integer.parseInt(defaultHeightString);
        }
        if ((defaultWidthString = Objects.toString(config.get("defaultWidth"), null)) != null) {
            this.defaultWidth = Integer.parseInt(defaultWidthString);
        }
        if ((scaleString = Objects.toString(config.get("scale"), null)) != null) {
            this.scale = Double.parseDouble(scaleString);
            if (this.scale < 0.1) {
                this.scale = 1.0;
            }
        }
        if ((maxWidthString = Objects.toString(config.get("maxWidth"), null)) != null) {
            this.maxWidth = Integer.parseInt(maxWidthString);
        }
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        this.logger.debug("Received incoming chart request: {}", (Object)req);
        int width = this.defaultWidth;
        try {
            width = Integer.parseInt(req.getParameter("w"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        int height = this.defaultHeight;
        try {
            String h = req.getParameter("h");
            if (h != null) {
                Double d = Double.parseDouble(h) * this.scale;
                height = d.intValue();
            }
        }
        catch (Exception h) {
            // empty catch block
        }
        if (req.getParameter("period") != null && req.getParameter("begin") != null && req.getParameter("end") != null) {
            throw new ServletException("Do not specify the three parameters period, begin and end at the same time.");
        }
        Date timeBegin = null;
        Date timeEnd = null;
        Long period = PERIODS.get(req.getParameter("period"));
        if (period == null) {
            period = PERIODS.get("D");
        }
        if (req.getParameter("begin") != null) {
            try {
                timeBegin = new SimpleDateFormat(DATE_FORMAT).parse(req.getParameter("begin"));
            }
            catch (ParseException e) {
                throw new ServletException("Begin and end must have this format: yyyyMMddHHmm.");
            }
        }
        if (req.getParameter("end") != null) {
            try {
                timeEnd = new SimpleDateFormat(DATE_FORMAT).parse(req.getParameter("end"));
            }
            catch (ParseException e) {
                throw new ServletException("Begin and end must have this format: yyyyMMddHHmm.");
            }
        }
        if (timeBegin == null && timeEnd == null) {
            timeEnd = new Date();
            timeBegin = new Date(timeEnd.getTime() - period);
            this.logger.debug("No begin or end is specified, use now as end and now-period as begin.");
        } else if (timeEnd == null) {
            timeEnd = new Date(timeBegin.getTime() + period);
            this.logger.debug("No end is specified, use begin + period as end.");
        } else if (timeBegin == null) {
            timeBegin = new Date(timeEnd.getTime() - period);
            this.logger.debug("No begin is specified, use end-period as begin");
        } else if (timeEnd.before(timeBegin)) {
            throw new ServletException("The end is before the begin.");
        }
        String serviceName = req.getParameter("service");
        ChartProvider provider = ChartServlet.getChartProviders().get(this.providerName);
        if (provider == null) {
            throw new ServletException("Could not get chart provider.");
        }
        Integer dpi = null;
        if (req.getParameter("dpi") != null) {
            try {
                dpi = Integer.valueOf(req.getParameter("dpi"));
            }
            catch (NumberFormatException e) {
                throw new ServletException("dpi parameter is invalid");
            }
            if (dpi <= 0) {
                throw new ServletException("dpi parameter is <= 0");
            }
        }
        Boolean legend = null;
        if (req.getParameter("legend") != null) {
            legend = BooleanUtils.toBoolean((String)req.getParameter("legend"));
        }
        if (this.maxWidth > 0 && width > this.maxWidth) {
            height = Math.round((float)height / (float)width * (float)this.maxWidth);
            if (dpi != null) {
                dpi = Math.round((float)dpi.intValue() / (float)width * (float)this.maxWidth);
            }
            width = this.maxWidth;
        }
        res.setContentType("image/" + (Object)((Object)provider.getChartType()));
        this.logger.debug("chart building with width {} height {} dpi {}", new Object[]{width, height, dpi});
        try {
            Throwable throwable = null;
            Object var13_22 = null;
            try (ImageOutputStream imageOutputStream = ImageIO.createImageOutputStream(res.getOutputStream());){
                BufferedImage chart = provider.createChart(serviceName, req.getParameter("theme"), timeBegin, timeEnd, height, width, req.getParameter("items"), req.getParameter("groups"), dpi, legend);
                ImageIO.write((RenderedImage)chart, provider.getChartType().toString(), imageOutputStream);
                this.logger.debug("Chart successfully generated and written to the response.");
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (ItemNotFoundException e) {
            this.logger.debug("{}", (Object)e.getMessage());
            res.sendError(400, e.getMessage());
        }
        catch (IllegalArgumentException e) {
            this.logger.warn("Illegal argument in chart: {}", (Object)e.getMessage());
            res.sendError(400, "Illegal argument in chart: " + e.getMessage());
        }
        catch (RuntimeException e) {
            if (this.logger.isDebugEnabled()) {
                this.logger.warn("Chart generation failed: {}", (Object)e.getMessage(), (Object)e);
            } else {
                this.logger.warn("Chart generation failed: {}", (Object)e.getMessage());
            }
            res.sendError(500, e.getMessage());
        }
    }

    protected HttpContext createHttpContext() {
        HttpContext defaultHttpContext = this.httpService.createDefaultHttpContext();
        return defaultHttpContext;
    }

    public void init(ServletConfig config) throws ServletException {
    }

    public ServletConfig getServletConfig() {
        return null;
    }

    public String getServletInfo() {
        return null;
    }

    public void destroy() {
    }
}

