/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.model.lsp.internal;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.eclipse.emf.common.util.URI;
import org.eclipse.xtext.ide.server.UriExtensions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MappingUriExtensions
extends UriExtensions {
    private static final Charset PATH_ENCODING = StandardCharsets.UTF_8;
    private final Logger logger = LoggerFactory.getLogger(MappingUriExtensions.class);
    private final String serverLocation;
    private String clientLocation = null;
    private final String rawConfigFolder;

    public MappingUriExtensions(String configFolder) {
        this.rawConfigFolder = configFolder;
        this.serverLocation = this.calcServerLocation(configFolder);
        this.logger.debug("The language server is using '{}' as its workspace", (Object)this.serverLocation);
    }

    protected String calcServerLocation(String configFolder) {
        Path configPath = Paths.get(configFolder, new String[0]);
        Path absoluteConfigPath = configPath.toAbsolutePath();
        java.net.URI configPathURI = absoluteConfigPath.toUri();
        return this.removeTrailingSlash(configPathURI.toString());
    }

    public String toPath(URI uri) {
        return this.toPath(java.net.URI.create(uri.toString()));
    }

    public String toPath(java.net.URI uri) {
        java.net.URI ret = uri;
        try {
            ret = Paths.get(uri).toUri();
        }
        catch (FileSystemNotFoundException fileSystemNotFoundException) {
            // empty catch block
        }
        String clientPath = this.removeTrailingSlash(ret.toASCIIString());
        if (this.clientLocation != null) {
            clientPath = clientPath.replace(this.serverLocation, this.clientLocation);
        }
        return clientPath;
    }

    public URI toUri(String pathWithScheme) {
        try {
            String decodedPathWithScheme = URLDecoder.decode(pathWithScheme, PATH_ENCODING.toString());
            if (this.clientLocation != null && decodedPathWithScheme.startsWith(this.clientLocation)) {
                return this.map(decodedPathWithScheme);
            }
            this.clientLocation = this.guessClientPath(decodedPathWithScheme);
            if (this.clientLocation != null) {
                this.logger.debug("Identified client workspace as '{}'", (Object)this.clientLocation);
                return this.map(decodedPathWithScheme);
            }
            this.clientLocation = pathWithScheme;
        }
        catch (UnsupportedEncodingException e) {
            this.logger.error("Charset {} is not supported. You're seriously in trouble.", (Object)PATH_ENCODING);
        }
        this.logger.debug("Path mapping could not be done for '{}', leaving it untouched", (Object)pathWithScheme);
        java.net.URI javaNetUri = java.net.URI.create(pathWithScheme);
        return URI.createURI((String)super.toPath(javaNetUri));
    }

    private String removeTrailingSlash(String path) {
        if (path.endsWith("/")) {
            return path.substring(0, path.length() - 1);
        }
        return path;
    }

    protected String guessClientPath(String pathWithScheme) {
        if (this.isPointingToConfigFolder(pathWithScheme)) {
            return this.removeTrailingSlash(pathWithScheme);
        }
        if (this.isFolder(pathWithScheme)) {
            return this.removeTrailingSlash(pathWithScheme);
        }
        String currentPath = pathWithScheme;
        int nextIndex = this.getLastPathSegmentIndex(currentPath);
        while (nextIndex > -1) {
            java.net.URI uri = this.toURI(pathWithScheme, currentPath = currentPath.substring(0, nextIndex));
            File realFile = new File(uri);
            if (realFile.exists()) {
                return currentPath;
            }
            nextIndex = this.getLastPathSegmentIndex(currentPath);
        }
        return null;
    }

    private boolean isFolder(String currentPath) {
        return !currentPath.substring(this.getLastPathSegmentIndex(currentPath)).contains(".");
    }

    private boolean isPointingToConfigFolder(String currentPath) {
        return currentPath.endsWith("/" + this.rawConfigFolder);
    }

    private int getLastPathSegmentIndex(String currentPath) {
        return this.removeTrailingSlash(currentPath).lastIndexOf("/");
    }

    private URI map(String pathWithScheme) {
        java.net.URI javaNetUri = this.toURI(pathWithScheme, this.clientLocation);
        this.logger.trace("Going to map path {}", (Object)javaNetUri);
        URI ret = URI.createURI((String)super.toPath(javaNetUri));
        this.logger.trace("Mapped path {} to {}", (Object)pathWithScheme, (Object)ret);
        return ret;
    }

    private java.net.URI toURI(String pathWithScheme, String currentPath) {
        return java.net.URI.create(pathWithScheme.replace(currentPath, this.serverLocation));
    }
}

