/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.model.lsp.internal;

import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.eclipse.lsp4j.jsonrpc.Launcher;
import org.eclipse.lsp4j.launch.LSPLauncher;
import org.eclipse.lsp4j.services.LanguageClient;
import org.eclipse.lsp4j.services.LanguageServer;
import org.eclipse.smarthome.model.lsp.internal.RuntimeServerModule;
import org.eclipse.smarthome.model.script.ScriptServiceUtil;
import org.eclipse.smarthome.model.script.engine.ScriptEngine;
import org.eclipse.xtext.ide.server.LanguageServerImpl;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
public class ModelServer {
    private final Logger logger = LoggerFactory.getLogger(ModelServer.class);
    private final int PORT = 5007;
    private ServerSocket socket;
    private ScriptServiceUtil scriptServiceUtil;
    private ScriptEngine scriptEngine;
    private Injector injector;

    @Activate
    public void activate() {
        this.injector = Guice.createInjector((Module[])new Module[]{new RuntimeServerModule(this.scriptServiceUtil, this.scriptEngine)});
        new Thread(() -> this.listen(), "Language Server").start();
    }

    @Deactivate
    public void deactivate() {
        try {
            if (this.socket != null && !this.socket.isClosed()) {
                this.socket.close();
            }
        }
        catch (IOException e) {
            this.logger.error("Error shutting down the Language Server", (Throwable)e);
        }
    }

    private void listen() {
        try {
            this.socket = new ServerSocket(5007);
            this.logger.info("Started Language Server Protocol (LSP) service on port {}", (Object)5007);
            while (!this.socket.isClosed()) {
                this.logger.debug("Going to wait for a client to connect");
                try {
                    Socket client = this.socket.accept();
                    new Thread(() -> this.handleConnection(client), "Client " + client.getRemoteSocketAddress()).start();
                }
                catch (IOException e) {
                    if (this.socket.isClosed()) continue;
                    this.logger.error("Error accepting client connection: {}", (Object)e.getMessage());
                }
            }
        }
        catch (IOException e) {
            this.logger.error("Error starting the Language Server", (Throwable)e);
        }
    }

    private void handleConnection(Socket client) {
        this.logger.debug("Client {} connected", (Object)client.getRemoteSocketAddress());
        try {
            LanguageServerImpl languageServer = (LanguageServerImpl)this.injector.getInstance(LanguageServerImpl.class);
            Launcher launcher = LSPLauncher.createServerLauncher((LanguageServer)languageServer, (InputStream)client.getInputStream(), (OutputStream)client.getOutputStream());
            languageServer.connect((LanguageClient)launcher.getRemoteProxy());
            Future future = launcher.startListening();
            future.get();
        }
        catch (IOException e) {
            this.logger.warn("Error communicating with LSP client {}", (Object)client.getRemoteSocketAddress());
        }
        catch (InterruptedException e) {
        }
        catch (ExecutionException e) {
            this.logger.error("Error running the Language Server", (Throwable)e);
        }
        this.logger.debug("Client {} disconnected", (Object)client.getRemoteSocketAddress());
    }

    @Reference
    public void setScriptServiceUtil(ScriptServiceUtil scriptServiceUtil) {
        this.scriptServiceUtil = scriptServiceUtil;
    }

    public void unsetScriptServiceUtil(ScriptServiceUtil scriptServiceUtil) {
        this.scriptServiceUtil = null;
    }

    @Reference
    public void setScriptEngine(ScriptEngine scriptEngine) {
        this.scriptEngine = scriptEngine;
    }

    public void unsetScriptEngine(ScriptEngine scriptEngine) {
        this.scriptEngine = null;
    }
}

