/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.extensionservice.marketplace.internal;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.eclipse.smarthome.core.events.Event;
import org.eclipse.smarthome.core.events.EventPublisher;
import org.eclipse.smarthome.core.extension.Extension;
import org.eclipse.smarthome.core.extension.ExtensionEvent;
import org.eclipse.smarthome.core.extension.ExtensionEventFactory;
import org.eclipse.smarthome.core.extension.ExtensionService;
import org.eclipse.smarthome.core.extension.ExtensionType;
import org.eclipse.smarthome.extensionservice.marketplace.MarketplaceExtension;
import org.eclipse.smarthome.extensionservice.marketplace.MarketplaceExtensionHandler;
import org.eclipse.smarthome.extensionservice.marketplace.MarketplaceHandlerException;
import org.eclipse.smarthome.extensionservice.marketplace.internal.MarketplaceProxy;
import org.eclipse.smarthome.extensionservice.marketplace.internal.model.Node;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MarketplaceExtensionService
implements ExtensionService {
    private static final String MP_PACKAGETYPE_BINDING = "binding";
    private static final String MP_PACKAGETYPE_RULE_TEMPLATE = "rule_template";
    private static final String MARKETPLACE_HOST = "marketplace.eclipse.org";
    private static final Pattern EXTENSION_ID_PATTERN = Pattern.compile(".*?mpc_install=([^&]+?)(&.*)?");
    private final Logger logger = LoggerFactory.getLogger(MarketplaceExtensionService.class);
    MarketplaceProxy proxy;
    private EventPublisher eventPublisher;
    private Pattern labelPattern = Pattern.compile("<.*>");
    private Pattern descriptionPattern = Pattern.compile("<(javascript|div|font)");
    private boolean includeBindings = true;
    private boolean includeRuleTemplates = true;
    private int maturityLevel = 1;
    private Set<MarketplaceExtensionHandler> extensionHandlers = new HashSet<MarketplaceExtensionHandler>();

    protected void activate(Map<String, Object> config) {
        this.proxy = new MarketplaceProxy();
        this.modified(config);
    }

    protected void deactivate() {
        this.proxy.dispose();
        this.proxy = null;
    }

    protected void modified(Map<String, Object> config) {
        Object cfgMaturityLevel;
        Object ruleTemplateCfg;
        Object bindingCfg = config.get("bindings");
        if (bindingCfg != null) {
            this.includeBindings = bindingCfg.toString().equals(Boolean.TRUE.toString());
        }
        if ((ruleTemplateCfg = config.get("ruletemplates")) != null) {
            this.includeRuleTemplates = ruleTemplateCfg.toString().equals(Boolean.TRUE.toString());
        }
        if ((cfgMaturityLevel = config.get("maturity")) != null) {
            try {
                this.maturityLevel = Integer.valueOf(cfgMaturityLevel.toString());
            }
            catch (NumberFormatException e) {
                this.logger.warn("Ignoring invalid value '{}' for configuration parameter '{}'", (Object)cfgMaturityLevel.toString(), (Object)"maturity");
            }
        }
    }

    protected void setEventPublisher(EventPublisher eventPublisher) {
        this.eventPublisher = eventPublisher;
    }

    protected void unsetEventPublisher(EventPublisher eventPublisher) {
        this.eventPublisher = null;
    }

    protected void addExtensionHandler(MarketplaceExtensionHandler handler) {
        this.extensionHandlers.add(handler);
    }

    protected void removeExtensionHandler(MarketplaceExtensionHandler handler) {
        this.extensionHandlers.remove(handler);
    }

    public List<Extension> getExtensions(Locale locale) {
        List<Node> nodes = this.proxy.getNodes();
        ArrayList<Extension> exts = new ArrayList<Extension>(nodes.size());
        for (Node node : nodes) {
            MarketplaceExtension ext;
            if (node.id == null || this.toMaturityLevel(node.status) < this.maturityLevel || !this.includeBindings && node.packagetypes.equals(MP_PACKAGETYPE_BINDING) || !this.includeRuleTemplates && node.packagetypes.equals(MP_PACKAGETYPE_RULE_TEMPLATE) || (ext = this.convertToExtension(node)) == null || !this.setInstalledFlag(ext)) continue;
            exts.add(ext);
        }
        return exts;
    }

    private boolean setInstalledFlag(MarketplaceExtension ext) {
        for (MarketplaceExtensionHandler handler : this.extensionHandlers) {
            if (!handler.supports(ext)) continue;
            ext.setInstalled(handler.isInstalled(ext));
            return true;
        }
        return false;
    }

    private MarketplaceExtension convertToExtension(Node node) {
        String version;
        String extId = this.getExtensionId(node);
        String name = node.name;
        String desc = node.shortdescription;
        String string = version = StringUtils.isNotEmpty((String)node.version) ? node.version : "1.0";
        if (!this.validName(name) || !this.validDescription(desc)) {
            this.logger.debug("Ignoring node {} due to invalid content.", (Object)node.id);
            return null;
        }
        if (MP_PACKAGETYPE_BINDING.equals(node.packagetypes)) {
            MarketplaceExtension ext = new MarketplaceExtension(extId, MP_PACKAGETYPE_BINDING, name, version, node.supporturl, false, desc, null, node.image, node.updateurl, node.packageformat);
            return ext;
        }
        if (MP_PACKAGETYPE_RULE_TEMPLATE.equals(node.packagetypes)) {
            MarketplaceExtension ext = new MarketplaceExtension(extId, "ruletemplate", name, version, node.supporturl, false, desc, null, node.image, node.updateurl, node.packageformat);
            return ext;
        }
        return null;
    }

    public Extension getExtension(String id, Locale locale) {
        for (Extension extension : this.getExtensions(locale)) {
            if (!extension.getId().equals(id)) continue;
            return extension;
        }
        return null;
    }

    public List<ExtensionType> getTypes(Locale locale) {
        ArrayList<ExtensionType> types = new ArrayList<ExtensionType>(2);
        List<Extension> exts = this.getExtensions(locale);
        if (this.includeBindings) {
            for (Extension ext : exts) {
                if (!ext.getType().equals(MP_PACKAGETYPE_BINDING)) continue;
                types.add(new ExtensionType(MP_PACKAGETYPE_BINDING, "Bindings"));
                break;
            }
        }
        if (this.includeRuleTemplates) {
            for (Extension ext : exts) {
                if (!ext.getType().equals("ruletemplate")) continue;
                types.add(new ExtensionType("ruletemplate", "Rule Templates"));
                break;
            }
        }
        return Collections.unmodifiableList(types);
    }

    public void install(String extensionId) {
        Extension ext = this.getExtension(extensionId, null);
        if (ext instanceof MarketplaceExtension) {
            MarketplaceExtension mpExt = (MarketplaceExtension)ext;
            for (MarketplaceExtensionHandler handler : this.extensionHandlers) {
                if (!handler.supports(mpExt)) continue;
                if (!handler.isInstalled(mpExt)) {
                    try {
                        handler.install(mpExt);
                        this.postInstalledEvent(extensionId);
                    }
                    catch (MarketplaceHandlerException e) {
                        this.postFailureEvent(extensionId, e.getMessage());
                    }
                } else {
                    this.postFailureEvent(extensionId, "Extension is already installed.");
                }
                return;
            }
        }
        this.postFailureEvent(extensionId, "Extension not known.");
    }

    public void uninstall(String extensionId) {
        Extension ext = this.getExtension(extensionId, null);
        if (ext instanceof MarketplaceExtension) {
            MarketplaceExtension mpExt = (MarketplaceExtension)ext;
            for (MarketplaceExtensionHandler handler : this.extensionHandlers) {
                if (!handler.supports(mpExt)) continue;
                if (handler.isInstalled(mpExt)) {
                    try {
                        handler.uninstall(mpExt);
                        this.postUninstalledEvent(extensionId);
                    }
                    catch (MarketplaceHandlerException e) {
                        this.postFailureEvent(extensionId, e.getMessage());
                    }
                } else {
                    this.postFailureEvent(extensionId, "Extension is not installed.");
                }
                return;
            }
        }
        this.postFailureEvent(extensionId, "Extension not known.");
    }

    public String getExtensionId(URI extensionURI) {
        if (extensionURI != null && extensionURI.getHost().equals(MARKETPLACE_HOST)) {
            return this.extractExensionId(extensionURI);
        }
        return null;
    }

    private void postInstalledEvent(String extensionId) {
        ExtensionEvent event = ExtensionEventFactory.createExtensionInstalledEvent((String)extensionId);
        this.eventPublisher.post((Event)event);
    }

    private void postUninstalledEvent(String extensionId) {
        ExtensionEvent event = ExtensionEventFactory.createExtensionUninstalledEvent((String)extensionId);
        this.eventPublisher.post((Event)event);
    }

    private void postFailureEvent(String extensionId, String msg) {
        ExtensionEvent event = ExtensionEventFactory.createExtensionFailureEvent((String)extensionId, (String)msg);
        this.eventPublisher.post((Event)event);
    }

    private String getExtensionId(Node node) {
        StringBuilder sb = new StringBuilder("market:");
        switch (node.packagetypes) {
            case "rule_template": {
                sb.append("ruletemplate").append("-");
                break;
            }
            case "binding": {
                sb.append(MP_PACKAGETYPE_BINDING).append("-");
                break;
            }
            default: {
                return null;
            }
        }
        sb.append(node.id.replaceAll("[^a-zA-Z0-9_]", ""));
        return sb.toString();
    }

    private int toMaturityLevel(String maturity) {
        switch (maturity) {
            case "Alpha": {
                return 0;
            }
            case "Beta": {
                return 1;
            }
            case "Production/Stable": {
                return 2;
            }
            case "Mature": {
                return 3;
            }
        }
        this.logger.debug("Unknown maturity level value '{}' - using 'Alpha' instead.", (Object)maturity);
        return 0;
    }

    private boolean validName(String name) {
        return !this.labelPattern.matcher(name).find();
    }

    private boolean validDescription(String desc) {
        return !this.descriptionPattern.matcher(desc).find();
    }

    private String extractExensionId(URI uri) {
        Optional<Node> extensionNode;
        Matcher idMatcher = EXTENSION_ID_PATTERN.matcher(uri.getQuery());
        String id = null;
        if (idMatcher.matches() && idMatcher.groupCount() > 1) {
            id = idMatcher.group(1);
        }
        return (extensionNode = this.getExtensionNode(id)).isPresent() ? this.getExtensionId(extensionNode.get()) : null;
    }

    private Optional<Node> getExtensionNode(String id) {
        return this.proxy.getNodes().stream().filter(node -> node != null && node.id.equals(id)).findFirst();
    }
}

