/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.io.rest.core.internal.link;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.stream.Stream;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.eclipse.smarthome.config.core.Configuration;
import org.eclipse.smarthome.core.common.registry.Identifiable;
import org.eclipse.smarthome.core.thing.ChannelUID;
import org.eclipse.smarthome.core.thing.UID;
import org.eclipse.smarthome.core.thing.link.AbstractLink;
import org.eclipse.smarthome.core.thing.link.ItemChannelLink;
import org.eclipse.smarthome.core.thing.link.ItemChannelLinkRegistry;
import org.eclipse.smarthome.core.thing.link.ThingLinkManager;
import org.eclipse.smarthome.core.thing.link.dto.ItemChannelLinkDTO;
import org.eclipse.smarthome.io.rest.JSONResponse;
import org.eclipse.smarthome.io.rest.RESTResource;
import org.eclipse.smarthome.io.rest.Stream2JSONInputStream;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;

@Path(value="links")
@RolesAllowed(value={"administrator"})
@Api(value="links")
@Component(service={RESTResource.class, ItemChannelLinkResource.class})
public class ItemChannelLinkResource
implements RESTResource {
    public static final String PATH_LINKS = "links";
    private ItemChannelLinkRegistry itemChannelLinkRegistry;
    private ThingLinkManager thingLinkManager;
    @Context
    UriInfo uriInfo;

    @GET
    @Produces(value={"application/json"})
    @ApiOperation(value="Gets all available links.", response=ItemChannelLinkDTO.class, responseContainer="Collection")
    @ApiResponses(value={@ApiResponse(code=200, message="OK", response=ItemChannelLinkDTO.class, responseContainer="Collection")})
    public Response getAll() {
        Stream<ItemChannelLinkDTO> linkStream = this.itemChannelLinkRegistry.getAll().stream().map(this::toBeans);
        return Response.ok((Object)new Stream2JSONInputStream(linkStream)).build();
    }

    @GET
    @Path(value="/auto")
    @Produces(value={"application/json"})
    @ApiOperation(value="Tells whether automatic link mode is active or not", response=Boolean.class)
    @ApiResponses(value={@ApiResponse(code=200, message="OK", response=Boolean.class)})
    public Response isAutomatic() {
        return Response.ok((Object)this.thingLinkManager.isAutoLinksEnabled()).build();
    }

    @PUT
    @Path(value="/{itemName}/{channelUID}")
    @ApiOperation(value="Links item to a channel.")
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=400, message="Content does not match the path")})
    public Response link(@PathParam(value="itemName") @ApiParam(value="itemName") String itemName, @PathParam(value="channelUID") @ApiParam(value="channelUID") String channelUid, @ApiParam(value="link data", required=false) ItemChannelLinkDTO bean) {
        ItemChannelLink link;
        if (bean == null) {
            link = new ItemChannelLink(itemName, new ChannelUID(channelUid), new Configuration());
        } else {
            if (bean.channelUID != null && !bean.channelUID.equals(channelUid)) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
            }
            if (bean.itemName != null && !bean.itemName.equals(itemName)) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
            }
            link = new ItemChannelLink(itemName, new ChannelUID(channelUid), new Configuration(bean.configuration));
        }
        if (this.itemChannelLinkRegistry.get((Object)link.getUID()) == null) {
            this.itemChannelLinkRegistry.add((Identifiable)link);
        } else {
            this.itemChannelLinkRegistry.update((Identifiable)link);
        }
        return Response.ok().build();
    }

    @DELETE
    @Path(value="/{itemName}/{channelUID}")
    @ApiOperation(value="Unlinks item from a channel.")
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=404, message="Link not found."), @ApiResponse(code=405, message="Link not editable.")})
    public Response unlink(@PathParam(value="itemName") @ApiParam(value="itemName") String itemName, @PathParam(value="channelUID") @ApiParam(value="channelUID") String channelUid) {
        String linkId = AbstractLink.getIDFor((String)itemName, (UID)new ChannelUID(channelUid));
        if (this.itemChannelLinkRegistry.get((Object)linkId) == null) {
            String message = "Link " + linkId + " does not exist!";
            return JSONResponse.createResponse((Response.Status)Response.Status.NOT_FOUND, null, (String)message);
        }
        ItemChannelLink result = (ItemChannelLink)this.itemChannelLinkRegistry.remove((Object)AbstractLink.getIDFor((String)itemName, (UID)new ChannelUID(channelUid)));
        if (result != null) {
            return Response.ok().build();
        }
        return JSONResponse.createErrorResponse((Response.Status)Response.Status.METHOD_NOT_ALLOWED, (String)"Channel is read-only.");
    }

    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC)
    protected void setThingLinkManager(ThingLinkManager thingLinkManager) {
        this.thingLinkManager = thingLinkManager;
    }

    protected void unsetThingLinkManager(ThingLinkManager thingLinkManager) {
        this.thingLinkManager = null;
    }

    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC)
    protected void setItemChannelLinkRegistry(ItemChannelLinkRegistry itemChannelLinkRegistry) {
        this.itemChannelLinkRegistry = itemChannelLinkRegistry;
    }

    protected void unsetItemChannelLinkRegistry(ItemChannelLinkRegistry itemChannelLinkRegistry) {
        this.itemChannelLinkRegistry = null;
    }

    private ItemChannelLinkDTO toBeans(ItemChannelLink link) {
        return new ItemChannelLinkDTO(link.getItemName(), link.getLinkedUID().toString(), link.getConfiguration().getProperties());
    }

    public boolean isSatisfied() {
        return this.itemChannelLinkRegistry != null && this.thingLinkManager != null;
    }
}

