/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.thing.xml.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.eclipse.smarthome.config.xml.AbstractXmlBasedProvider;
import org.eclipse.smarthome.core.i18n.TranslationProvider;
import org.eclipse.smarthome.core.thing.UID;
import org.eclipse.smarthome.core.thing.i18n.ThingTypeI18nUtil;
import org.eclipse.smarthome.core.thing.type.ChannelGroupType;
import org.eclipse.smarthome.core.thing.type.ChannelGroupTypeUID;
import org.eclipse.smarthome.core.thing.type.ChannelType;
import org.eclipse.smarthome.core.thing.type.ChannelTypeProvider;
import org.eclipse.smarthome.core.thing.type.ChannelTypeUID;
import org.eclipse.smarthome.core.types.StateDescription;
import org.eclipse.smarthome.core.types.StateOption;
import org.osgi.framework.Bundle;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"esh.scope=core.xml.channels"})
public class XmlChannelTypeProvider
extends AbstractXmlBasedProvider<UID, ChannelType>
implements ChannelTypeProvider {
    private ThingTypeI18nUtil thingTypeI18nUtil;

    public ChannelGroupType getChannelGroupType(ChannelGroupTypeUID channelGroupTypeUID, Locale locale) {
        return null;
    }

    public Collection<ChannelGroupType> getChannelGroupTypes(Locale locale) {
        return Collections.emptyList();
    }

    public ChannelType getChannelType(ChannelTypeUID channelTypeUID, Locale locale) {
        return (ChannelType)this.get(channelTypeUID, locale);
    }

    public synchronized Collection<ChannelType> getChannelTypes(Locale locale) {
        return this.getAll(locale);
    }

    @Reference
    public void setTranslationProvider(TranslationProvider i18nProvider) {
        this.thingTypeI18nUtil = new ThingTypeI18nUtil(i18nProvider);
    }

    public void unsetTranslationProvider(TranslationProvider i18nProvider) {
        this.thingTypeI18nUtil = null;
    }

    private StateDescription createLocalizedChannelState(Bundle bundle, ChannelType channelType, ChannelTypeUID channelTypeUID, Locale locale) {
        StateDescription state = channelType.getState();
        if (state != null) {
            String pattern = this.thingTypeI18nUtil.getChannelStatePattern(bundle, channelTypeUID, state.getPattern(), locale);
            ArrayList<StateOption> localizedOptions = new ArrayList<StateOption>();
            List options = state.getOptions();
            for (StateOption stateOption : options) {
                String optionLabel = this.thingTypeI18nUtil.getChannelStateOption(bundle, channelTypeUID, stateOption.getValue(), stateOption.getLabel(), locale);
                localizedOptions.add(new StateOption(stateOption.getValue(), optionLabel));
            }
            return new StateDescription(state.getMinimum(), state.getMaximum(), state.getStep(), pattern, state.isReadOnly(), localizedOptions);
        }
        return null;
    }

    protected ChannelType localize(Bundle bundle, ChannelType channelType, Locale locale) {
        if (this.thingTypeI18nUtil == null) {
            return null;
        }
        ChannelTypeUID channelTypeUID = channelType.getUID();
        String label = this.thingTypeI18nUtil.getChannelLabel(bundle, channelTypeUID, channelType.getLabel(), locale);
        String description = this.thingTypeI18nUtil.getChannelDescription(bundle, channelTypeUID, channelType.getDescription(), locale);
        StateDescription state = this.createLocalizedChannelState(bundle, channelType, channelTypeUID, locale);
        return new ChannelType(channelTypeUID, channelType.isAdvanced(), channelType.getItemType(), channelType.getKind(), label, description, channelType.getCategory(), channelType.getTags(), state, channelType.getEvent(), channelType.getConfigDescriptionURI());
    }
}

