/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.wemo.handler;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.net.URL;
import java.time.Instant;
import java.time.ZonedDateTime;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang.StringUtils;
import org.eclipse.smarthome.binding.wemo.WemoBindingConstants;
import org.eclipse.smarthome.binding.wemo.internal.http.WemoHttpCall;
import org.eclipse.smarthome.config.core.Configuration;
import org.eclipse.smarthome.config.discovery.DiscoveryListener;
import org.eclipse.smarthome.config.discovery.DiscoveryResult;
import org.eclipse.smarthome.config.discovery.DiscoveryService;
import org.eclipse.smarthome.core.library.types.DateTimeType;
import org.eclipse.smarthome.core.library.types.DecimalType;
import org.eclipse.smarthome.core.library.types.OnOffType;
import org.eclipse.smarthome.core.thing.ChannelUID;
import org.eclipse.smarthome.core.thing.Thing;
import org.eclipse.smarthome.core.thing.ThingStatus;
import org.eclipse.smarthome.core.thing.ThingStatusDetail;
import org.eclipse.smarthome.core.thing.ThingTypeUID;
import org.eclipse.smarthome.core.thing.ThingUID;
import org.eclipse.smarthome.core.thing.binding.BaseThingHandler;
import org.eclipse.smarthome.core.types.Command;
import org.eclipse.smarthome.core.types.RefreshType;
import org.eclipse.smarthome.core.types.State;
import org.eclipse.smarthome.io.transport.upnp.UpnpIOParticipant;
import org.eclipse.smarthome.io.transport.upnp.UpnpIOService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WemoHandler
extends BaseThingHandler
implements UpnpIOParticipant,
DiscoveryListener {
    private final Logger logger = LoggerFactory.getLogger(WemoHandler.class);
    public static final Set<ThingTypeUID> SUPPORTED_THING_TYPES = Stream.of(WemoBindingConstants.THING_TYPE_SOCKET, WemoBindingConstants.THING_TYPE_INSIGHT, WemoBindingConstants.THING_TYPE_LIGHTSWITCH, WemoBindingConstants.THING_TYPE_MOTION).collect(Collectors.toSet());
    private Map<String, Boolean> subscriptionState = new HashMap<String, Boolean>();
    private final Map<String, String> stateMap = Collections.synchronizedMap(new HashMap());
    protected static final int SUBSCRIPTION_DURATION = 600;
    private UpnpIOService service;
    private final int DEFAULT_REFRESH_INTERVAL = 120;
    private ScheduledFuture<?> refreshJob;
    private final Runnable refreshRunnable = new Runnable(){

        @Override
        public void run() {
            try {
                if (!WemoHandler.this.isUpnpDeviceRegistered()) {
                    WemoHandler.this.logger.debug("WeMo UPnP device {} not yet registered", (Object)WemoHandler.this.getUDN());
                }
                WemoHandler.this.updateWemoState();
                WemoHandler.this.onSubscription();
            }
            catch (Exception e) {
                WemoHandler.this.logger.debug("Exception during poll : {}", (Throwable)e);
                WemoHandler.this.updateStatus(ThingStatus.OFFLINE, ThingStatusDetail.COMMUNICATION_ERROR, e.getMessage());
            }
        }
    };

    public WemoHandler(Thing thing, UpnpIOService upnpIOService) {
        super(thing);
        this.logger.debug("Creating a WemoHandler for thing '{}'", (Object)this.getThing().getUID());
        if (upnpIOService != null) {
            this.service = upnpIOService;
        } else {
            this.logger.debug("upnpIOService not set.");
        }
    }

    public void initialize() {
        Configuration configuration = this.getConfig();
        if (configuration.get("udn") != null) {
            this.logger.debug("Initializing WemoHandler for UDN '{}'", configuration.get("udn"));
            this.onSubscription();
            this.onUpdate();
            this.updateStatus(ThingStatus.ONLINE);
        } else {
            this.logger.debug("Cannot initalize WemoHandler. UDN not set.");
        }
    }

    public void thingDiscovered(DiscoveryService source, DiscoveryResult result) {
        if (result.getThingUID().equals((Object)this.getThing().getUID()) && this.getThing().getConfiguration().get("udn").equals(result.getProperties().get("udn"))) {
            this.logger.trace("Discovered UDN '{}' for thing '{}'", result.getProperties().get("udn"), (Object)this.getThing().getUID());
            this.updateStatus(ThingStatus.ONLINE);
            this.onSubscription();
            this.onUpdate();
        }
    }

    public void thingRemoved(DiscoveryService source, ThingUID thingUID) {
        if (thingUID.equals((Object)this.getThing().getUID())) {
            this.logger.trace("Setting status for thing '{}' to OFFLINE", (Object)this.getThing().getUID());
            this.updateStatus(ThingStatus.OFFLINE);
        }
    }

    public void dispose() {
        this.logger.debug("WeMoHandler disposed.");
        this.removeSubscription();
        if (this.refreshJob != null && !this.refreshJob.isCancelled()) {
            this.refreshJob.cancel(true);
            this.refreshJob = null;
        }
    }

    public void handleCommand(ChannelUID channelUID, Command command) {
        this.logger.trace("Command '{}' received for channel '{}'", (Object)command, (Object)channelUID);
        if (command instanceof RefreshType) {
            try {
                this.updateWemoState();
            }
            catch (Exception e) {
                this.logger.debug("Exception during poll : {}", (Throwable)e);
            }
        } else if (channelUID.getId().equals("state") && command instanceof OnOffType) {
            try {
                String binaryState = null;
                if (command.equals(OnOffType.ON)) {
                    binaryState = "1";
                } else if (command.equals(OnOffType.OFF)) {
                    binaryState = "0";
                }
                String soapHeader = "\"urn:Belkin:service:basicevent:1#SetBinaryState\"";
                String content = "<?xml version=\"1.0\"?><s:Envelope xmlns:s=\"http://schemas.xmlsoap.org/soap/envelope/\" s:encodingStyle=\"http://schemas.xmlsoap.org/soap/encoding/\"><s:Body><u:SetBinaryState xmlns:u=\"urn:Belkin:service:basicevent:1\"><BinaryState>" + binaryState + "</BinaryState>" + "</u:SetBinaryState>" + "</s:Body>" + "</s:Envelope>";
                String wemoURL = this.getWemoURL("basicevent");
                if (wemoURL != null) {
                    WemoHttpCall.executeCall(wemoURL, soapHeader, content);
                }
            }
            catch (Exception e) {
                this.logger.error("Failed to send command '{}' for device '{}': {}", new Object[]{command, this.getThing().getUID(), e.getMessage()});
                this.updateStatus(ThingStatus.OFFLINE, ThingStatusDetail.COMMUNICATION_ERROR);
            }
            this.updateStatus(ThingStatus.ONLINE);
        }
    }

    public void onServiceSubscribed(String service, boolean succeeded) {
        this.logger.debug("WeMo {}: Subscription to service {} {}", new Object[]{this.getUDN(), service, succeeded ? "succeeded" : "failed"});
        this.subscriptionState.put(service, succeeded);
    }

    public void onValueReceived(String variable, String value, String service) {
        this.logger.debug("Received pair '{}':'{}' (service '{}') for thing '{}'", new Object[]{variable, value, service, this.getThing().getUID()});
        this.updateStatus(ThingStatus.ONLINE);
        this.stateMap.put(variable, value);
        if (this.getThing().getThingTypeUID().getId().equals("insight")) {
            String insightParams = this.stateMap.get("InsightParams");
            if (insightParams != null) {
                BigDecimal standByLimitMW;
                DecimalType standByLimit;
                BigDecimal energyTotalMWMin;
                DecimalType energyTotal;
                BigDecimal energyTodayMWMin;
                DecimalType energyToday;
                BigDecimal currentMW;
                DecimalType currentPower;
                DecimalType averagePower;
                DecimalType timespan;
                DecimalType onTotal;
                DecimalType onToday;
                DecimalType lastOnFor;
                String[] splitInsightParams = insightParams.split("\\|");
                if (splitInsightParams[0] != null) {
                    OnOffType binaryState = null;
                    OnOffType onOffType = binaryState = splitInsightParams[0].equals("0") ? OnOffType.OFF : OnOffType.ON;
                    if (binaryState != null) {
                        this.logger.trace("New InsightParam binaryState '{}' for device '{}' received", (Object)binaryState, (Object)this.getThing().getUID());
                        this.updateState("state", (State)binaryState);
                    }
                }
                long lastChangedAt = 0L;
                try {
                    lastChangedAt = Long.parseLong(splitInsightParams[1]) * 1000L;
                }
                catch (NumberFormatException numberFormatException) {
                    this.logger.error("Unable to parse lastChangedAt value '{}' for device '{}'; expected long", (Object)splitInsightParams[1], (Object)this.getThing().getUID());
                }
                ZonedDateTime zoned = ZonedDateTime.ofInstant(Instant.ofEpochMilli(lastChangedAt), TimeZone.getDefault().toZoneId());
                DateTimeType lastChangedAtState = new DateTimeType(zoned);
                if (lastChangedAt != 0L) {
                    this.logger.trace("New InsightParam lastChangedAt '{}' for device '{}' received", (Object)lastChangedAtState, (Object)this.getThing().getUID());
                    this.updateState("lastChangedAt", (State)lastChangedAtState);
                }
                if ((lastOnFor = DecimalType.valueOf((String)splitInsightParams[2])) != null) {
                    this.logger.trace("New InsightParam lastOnFor '{}' for device '{}' received", (Object)lastOnFor, (Object)this.getThing().getUID());
                    this.updateState("lastOnFor", (State)lastOnFor);
                }
                if ((onToday = DecimalType.valueOf((String)splitInsightParams[3])) != null) {
                    this.logger.trace("New InsightParam onToday '{}' for device '{}' received", (Object)onToday, (Object)this.getThing().getUID());
                    this.updateState("onToday", (State)onToday);
                }
                if ((onTotal = DecimalType.valueOf((String)splitInsightParams[4])) != null) {
                    this.logger.trace("New InsightParam onTotal '{}' for device '{}' received", (Object)onTotal, (Object)this.getThing().getUID());
                    this.updateState("onTotal", (State)onTotal);
                }
                if ((timespan = DecimalType.valueOf((String)splitInsightParams[5])) != null) {
                    this.logger.trace("New InsightParam timespan '{}' for device '{}' received", (Object)timespan, (Object)this.getThing().getUID());
                    this.updateState("timespan", (State)timespan);
                }
                if ((averagePower = DecimalType.valueOf((String)splitInsightParams[6])) != null) {
                    this.logger.trace("New InsightParam averagePower '{}' for device '{}' received", (Object)averagePower, (Object)this.getThing().getUID());
                    this.updateState("averagePower", (State)averagePower);
                }
                if ((currentPower = new DecimalType((currentMW = new BigDecimal(splitInsightParams[7])).divide(new BigDecimal(1000), RoundingMode.HALF_UP))) != null) {
                    this.logger.trace("New InsightParam currentPower '{}' for device '{}' received", (Object)currentPower, (Object)this.getThing().getUID());
                    this.updateState("currentPower", (State)currentPower);
                }
                if ((energyToday = new DecimalType((energyTodayMWMin = new BigDecimal(splitInsightParams[8])).divide(new BigDecimal(60000), RoundingMode.HALF_UP))) != null) {
                    this.logger.trace("New InsightParam energyToday '{}' for device '{}' received", (Object)energyToday, (Object)this.getThing().getUID());
                    this.updateState("energyToday", (State)energyToday);
                }
                if ((energyTotal = new DecimalType((energyTotalMWMin = new BigDecimal(splitInsightParams[9])).divide(new BigDecimal(60000), RoundingMode.HALF_UP))) != null) {
                    this.logger.trace("New InsightParam energyTotal '{}' for device '{}' received", (Object)energyTotal, (Object)this.getThing().getUID());
                    this.updateState("energyTotal", (State)energyTotal);
                }
                if ((standByLimit = new DecimalType((standByLimitMW = new BigDecimal(splitInsightParams[10])).divide(new BigDecimal(1000), RoundingMode.HALF_UP))) != null) {
                    this.logger.trace("New InsightParam standByLimit '{}' for device '{}' received", (Object)standByLimit, (Object)this.getThing().getUID());
                    this.updateState("standByLimit", (State)standByLimit);
                }
            }
        } else {
            OnOffType state = this.stateMap.get("BinaryState").equals("0") ? OnOffType.OFF : OnOffType.ON;
            this.logger.debug("State '{}' for device '{}' received", (Object)state, (Object)this.getThing().getUID());
            if (state != null) {
                if (this.getThing().getThingTypeUID().getId().equals("motion")) {
                    this.updateState("motionDetection", (State)state);
                    if (state.equals(OnOffType.ON)) {
                        DateTimeType lastMotionDetected = new DateTimeType();
                        this.updateState("lastMotionDetected", (State)lastMotionDetected);
                    }
                } else {
                    this.updateState("state", (State)state);
                }
            }
        }
    }

    private synchronized void onSubscription() {
        if (this.service.isRegistered((UpnpIOParticipant)this)) {
            this.logger.debug("Checking WeMo GENA subscription for '{}'", (Object)this);
            ThingTypeUID thingTypeUID = this.thing.getThingTypeUID();
            String subscription = "basicevent1";
            if (this.subscriptionState.get(subscription) == null || !this.subscriptionState.get(subscription).booleanValue()) {
                this.logger.debug("Setting up GENA subscription {}: Subscribing to service {}...", (Object)this.getUDN(), (Object)subscription);
                this.service.addSubscription((UpnpIOParticipant)this, subscription, 600);
                this.subscriptionState.put(subscription, true);
            }
            if (thingTypeUID.equals((Object)WemoBindingConstants.THING_TYPE_INSIGHT) && (this.subscriptionState.get(subscription = "insight1") == null || !this.subscriptionState.get(subscription).booleanValue())) {
                this.logger.debug("Setting up GENA subscription {}: Subscribing to service {}...", (Object)this.getUDN(), (Object)subscription);
                this.service.addSubscription((UpnpIOParticipant)this, subscription, 600);
                this.subscriptionState.put(subscription, true);
            }
        } else {
            this.logger.debug("Setting up WeMo GENA subscription for '{}' FAILED - service.isRegistered(this) is FALSE", (Object)this);
        }
    }

    private synchronized void removeSubscription() {
        this.logger.debug("Removing WeMo GENA subscription for '{}'", (Object)this);
        if (this.service.isRegistered((UpnpIOParticipant)this)) {
            ThingTypeUID thingTypeUID = this.thing.getThingTypeUID();
            String subscription = "basicevent1";
            if (this.subscriptionState.get(subscription) != null && this.subscriptionState.get(subscription).booleanValue()) {
                this.logger.debug("WeMo {}: Unsubscribing from service {}...", (Object)this.getUDN(), (Object)subscription);
                this.service.removeSubscription((UpnpIOParticipant)this, subscription);
            }
            if (thingTypeUID.equals((Object)WemoBindingConstants.THING_TYPE_INSIGHT) && this.subscriptionState.get(subscription = "insight1") != null && this.subscriptionState.get(subscription).booleanValue()) {
                this.logger.debug("WeMo {}: Unsubscribing from service {}...", (Object)this.getUDN(), (Object)subscription);
                this.service.removeSubscription((UpnpIOParticipant)this, subscription);
            }
            this.subscriptionState = new HashMap<String, Boolean>();
            this.service.unregisterParticipant((UpnpIOParticipant)this);
        }
    }

    private synchronized void onUpdate() {
        if (this.refreshJob == null || this.refreshJob.isCancelled()) {
            Configuration config = this.getThing().getConfiguration();
            int refreshInterval = 120;
            Object refreshConfig = config.get("refresh");
            if (refreshConfig != null) {
                refreshInterval = ((BigDecimal)refreshConfig).intValue();
            }
            this.refreshJob = this.scheduler.scheduleWithFixedDelay(this.refreshRunnable, 0L, refreshInterval, TimeUnit.SECONDS);
        }
    }

    private boolean isUpnpDeviceRegistered() {
        return this.service.isRegistered((UpnpIOParticipant)this);
    }

    public String getUDN() {
        return (String)this.getThing().getConfiguration().get("udn");
    }

    protected void updateWemoState() {
        String action = "GetBinaryState";
        String variable = "BinaryState";
        String actionService = "basicevent";
        String value = null;
        if (this.getThing().getThingTypeUID().getId().equals("insight")) {
            action = "GetInsightParams";
            variable = "InsightParams";
            actionService = "insight";
        }
        String soapHeader = "\"urn:Belkin:service:" + actionService + ":1#" + action + "\"";
        String content = "<?xml version=\"1.0\"?><s:Envelope xmlns:s=\"http://schemas.xmlsoap.org/soap/envelope/\" s:encodingStyle=\"http://schemas.xmlsoap.org/soap/encoding/\"><s:Body><u:" + action + " xmlns:u=\"urn:Belkin:service:" + actionService + ":1\">" + "</u:" + action + ">" + "</s:Body>" + "</s:Envelope>";
        try {
            String wemoCallResponse;
            String wemoURL = this.getWemoURL(actionService);
            if (wemoURL != null && (wemoCallResponse = WemoHttpCall.executeCall(wemoURL, soapHeader, content)) != null) {
                this.logger.trace("State response '{}' for device '{}' received", (Object)wemoCallResponse, (Object)this.getThing().getUID());
                value = variable.equals("InsightParams") ? StringUtils.substringBetween((String)wemoCallResponse, (String)"<InsightParams>", (String)"</InsightParams>") : StringUtils.substringBetween((String)wemoCallResponse, (String)"<BinaryState>", (String)"</BinaryState>");
                if (value != null) {
                    this.logger.trace("New state '{}' for device '{}' received", (Object)value, (Object)this.getThing().getUID());
                    this.onValueReceived(variable, value, String.valueOf(actionService) + "1");
                }
            }
        }
        catch (Exception e) {
            this.logger.error("Failed to get actual state for device '{}': {}", (Object)this.getThing().getUID(), (Object)e.getMessage());
        }
    }

    public String getWemoURL(String actionService) {
        URL descriptorURL = this.service.getDescriptorURL((UpnpIOParticipant)this);
        String wemoURL = null;
        if (descriptorURL != null) {
            String deviceURL = StringUtils.substringBefore((String)descriptorURL.toString(), (String)"/setup.xml");
            wemoURL = String.valueOf(deviceURL) + "/upnp/control/" + actionService + "1";
            return wemoURL;
        }
        return null;
    }

    public void onStatusChanged(boolean status) {
    }

    public Collection<ThingUID> removeOlderResults(DiscoveryService source, long timestamp, Collection<ThingTypeUID> thingTypeUIDs, ThingUID bridgeUID) {
        return Collections.emptyList();
    }
}

