/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.model.rule.runtime.internal.engine;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import com.google.inject.Injector;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.smarthome.core.items.Item;
import org.eclipse.smarthome.core.thing.ThingStatus;
import org.eclipse.smarthome.core.types.Command;
import org.eclipse.smarthome.core.types.State;
import org.eclipse.smarthome.core.types.Type;
import org.eclipse.smarthome.core.types.TypeParser;
import org.eclipse.smarthome.model.rule.rules.ChangedEventTrigger;
import org.eclipse.smarthome.model.rule.rules.CommandEventTrigger;
import org.eclipse.smarthome.model.rule.rules.EventEmittedTrigger;
import org.eclipse.smarthome.model.rule.rules.EventTrigger;
import org.eclipse.smarthome.model.rule.rules.Rule;
import org.eclipse.smarthome.model.rule.rules.RuleModel;
import org.eclipse.smarthome.model.rule.rules.SystemOnShutdownTrigger;
import org.eclipse.smarthome.model.rule.rules.SystemOnStartupTrigger;
import org.eclipse.smarthome.model.rule.rules.ThingStateChangedEventTrigger;
import org.eclipse.smarthome.model.rule.rules.ThingStateUpdateEventTrigger;
import org.eclipse.smarthome.model.rule.rules.TimerTrigger;
import org.eclipse.smarthome.model.rule.rules.UpdateEventTrigger;
import org.eclipse.smarthome.model.rule.runtime.internal.engine.ExecuteRuleJob;
import org.eclipse.smarthome.model.rule.runtime.internal.engine.GuiceAwareJobFactory;
import org.quartz.CronScheduleBuilder;
import org.quartz.JobBuilder;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.impl.StdSchedulerFactory;
import org.quartz.impl.matchers.GroupMatcher;
import org.quartz.spi.JobFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RuleTriggerManager {
    private final Logger logger = LoggerFactory.getLogger(RuleTriggerManager.class);
    private Map<String, Set<Rule>> updateEventTriggeredRules = Maps.newHashMap();
    private Map<String, Set<Rule>> changedEventTriggeredRules = Maps.newHashMap();
    private Map<String, Set<Rule>> commandEventTriggeredRules = Maps.newHashMap();
    private Map<String, Set<Rule>> thingUpdateEventTriggeredRules = Maps.newHashMap();
    private Map<String, Set<Rule>> thingChangedEventTriggeredRules = Maps.newHashMap();
    private Map<String, Set<Rule>> triggerEventTriggeredRules = Maps.newHashMap();
    private Set<Rule> systemStartupTriggeredRules = new CopyOnWriteArraySet<Rule>();
    private Set<Rule> systemShutdownTriggeredRules = new CopyOnWriteArraySet<Rule>();
    private Set<Rule> timerEventTriggeredRules = new CopyOnWriteArraySet<Rule>();
    private Scheduler scheduler;

    @Inject
    public RuleTriggerManager(Injector injector) {
        try {
            this.scheduler = StdSchedulerFactory.getDefaultScheduler();
            this.scheduler.setJobFactory((JobFactory)injector.getInstance(GuiceAwareJobFactory.class));
            this.scheduler.standby();
        }
        catch (SchedulerException e) {
            this.logger.error("initializing scheduler throws exception", (Throwable)e);
        }
    }

    public Iterable<Rule> getRules(TriggerTypes type) {
        Iterable<Object> result;
        switch (type) {
            case STARTUP: {
                result = this.systemStartupTriggeredRules;
                break;
            }
            case SHUTDOWN: {
                result = this.systemShutdownTriggeredRules;
                break;
            }
            case TIMER: {
                result = this.timerEventTriggeredRules;
                break;
            }
            case UPDATE: {
                result = Iterables.concat(this.updateEventTriggeredRules.values());
                break;
            }
            case CHANGE: {
                result = Iterables.concat(this.changedEventTriggeredRules.values());
                break;
            }
            case COMMAND: {
                result = Iterables.concat(this.commandEventTriggeredRules.values());
                break;
            }
            case TRIGGER: {
                result = Iterables.concat(this.triggerEventTriggeredRules.values());
                break;
            }
            case THINGUPDATE: {
                result = Iterables.concat(this.thingUpdateEventTriggeredRules.values());
                break;
            }
            case THINGCHANGE: {
                result = Iterables.concat(this.thingChangedEventTriggeredRules.values());
                break;
            }
            default: {
                result = Sets.newHashSet();
            }
        }
        ArrayList<Rule> filteredList = new ArrayList<Rule>();
        for (Rule rule : result) {
            if (rule.eResource() == null || rule.eIsProxy()) continue;
            filteredList.add(rule);
        }
        return filteredList;
    }

    public Iterable<Rule> getRules(TriggerTypes triggerType, Item item, State state) {
        return this.internalGetRules(triggerType, item, null, (Type)state);
    }

    public Iterable<Rule> getRules(TriggerTypes triggerType, Item item, State oldState, State newState) {
        return this.internalGetRules(triggerType, item, (Type)oldState, (Type)newState);
    }

    public Iterable<Rule> getRules(TriggerTypes triggerType, Item item, Command command) {
        return this.internalGetRules(triggerType, item, null, (Type)command);
    }

    public Iterable<Rule> getRules(TriggerTypes triggerType, String channel, String event) {
        ArrayList result = Lists.newArrayList();
        switch (triggerType) {
            case TRIGGER: {
                Set<Rule> rules = this.triggerEventTriggeredRules.get(channel);
                if (rules == null) {
                    return Collections.emptyList();
                }
                for (Rule rule : rules) {
                    for (EventTrigger t : rule.getEventtrigger()) {
                        EventEmittedTrigger et;
                        if (!(t instanceof EventEmittedTrigger) || !(et = (EventEmittedTrigger)t).getChannel().equals(channel) || et.getTrigger() != null && !et.getTrigger().equals(event)) continue;
                        result.add(rule);
                    }
                }
                break;
            }
            default: {
                return Collections.emptyList();
            }
        }
        return result;
    }

    public Iterable<Rule> getRules(TriggerTypes triggerType, String thingUid, ThingStatus state) {
        return this.internalGetThingRules(triggerType, thingUid, null, state);
    }

    public Iterable<Rule> getRules(TriggerTypes triggerType, String thingUid, ThingStatus oldState, ThingStatus newState) {
        return this.internalGetThingRules(triggerType, thingUid, oldState, newState);
    }

    private Iterable<Rule> getAllRules(TriggerTypes type, String name) {
        switch (type) {
            case STARTUP: {
                return this.systemStartupTriggeredRules;
            }
            case SHUTDOWN: {
                return this.systemShutdownTriggeredRules;
            }
            case UPDATE: {
                return this.updateEventTriggeredRules.get(name);
            }
            case CHANGE: {
                return this.changedEventTriggeredRules.get(name);
            }
            case COMMAND: {
                return this.commandEventTriggeredRules.get(name);
            }
            case THINGUPDATE: {
                return this.thingUpdateEventTriggeredRules.get(name);
            }
            case THINGCHANGE: {
                return this.thingChangedEventTriggeredRules.get(name);
            }
        }
        return Sets.newHashSet();
    }

    private Iterable<Rule> internalGetRules(TriggerTypes triggerType, Item item, Type oldType, Type newType) {
        ArrayList result = Lists.newArrayList();
        ArrayList rules = this.getAllRules(triggerType, item.getName());
        if (rules == null) {
            rules = Lists.newArrayList();
        }
        switch (triggerType) {
            case STARTUP: {
                return this.systemStartupTriggeredRules;
            }
            case SHUTDOWN: {
                return this.systemShutdownTriggeredRules;
            }
            case TIMER: {
                return this.timerEventTriggeredRules;
            }
            case UPDATE: {
                if (!(newType instanceof State)) break;
                State state = (State)newType;
                for (Rule rule : rules) {
                    for (EventTrigger t : rule.getEventtrigger()) {
                        State triggerState;
                        UpdateEventTrigger ut;
                        if (!(t instanceof UpdateEventTrigger) || !(ut = (UpdateEventTrigger)t).getItem().equals(item.getName()) || ut.getState() != null && !state.equals(triggerState = TypeParser.parseState((List)item.getAcceptedDataTypes(), (String)ut.getState()))) continue;
                        result.add(rule);
                    }
                }
                break;
            }
            case CHANGE: {
                if (!(newType instanceof State) || !(oldType instanceof State)) break;
                State newState = (State)newType;
                State oldState = (State)oldType;
                for (Rule rule : rules) {
                    for (EventTrigger t : rule.getEventtrigger()) {
                        State triggerNewState;
                        State triggerOldState;
                        ChangedEventTrigger ct;
                        if (!(t instanceof ChangedEventTrigger) || !(ct = (ChangedEventTrigger)t).getItem().equals(item.getName()) || ct.getOldState() != null && !oldState.equals(triggerOldState = TypeParser.parseState((List)item.getAcceptedDataTypes(), (String)ct.getOldState())) || ct.getNewState() != null && !newState.equals(triggerNewState = TypeParser.parseState((List)item.getAcceptedDataTypes(), (String)ct.getNewState()))) continue;
                        result.add(rule);
                    }
                }
                break;
            }
            case COMMAND: {
                if (!(newType instanceof Command)) break;
                Command command = (Command)newType;
                for (Rule rule : rules) {
                    for (EventTrigger t : rule.getEventtrigger()) {
                        Command triggerCommand;
                        CommandEventTrigger ct;
                        if (!(t instanceof CommandEventTrigger) || !(ct = (CommandEventTrigger)t).getItem().equals(item.getName()) || ct.getCommand() != null && !command.equals(triggerCommand = TypeParser.parseCommand((List)item.getAcceptedCommandTypes(), (String)ct.getCommand()))) continue;
                        result.add(rule);
                    }
                }
                break;
            }
        }
        return result;
    }

    private Iterable<Rule> internalGetThingRules(TriggerTypes triggerType, String thingUid, ThingStatus oldStatus, ThingStatus newStatus) {
        ArrayList result = Lists.newArrayList();
        ArrayList rules = this.getAllRules(triggerType, thingUid);
        if (rules == null) {
            rules = Lists.newArrayList();
        }
        switch (triggerType) {
            case THINGUPDATE: {
                for (Rule rule : rules) {
                    for (EventTrigger t : rule.getEventtrigger()) {
                        ThingStatus triggerState;
                        String stateString;
                        ThingStateUpdateEventTrigger tt;
                        if (!(t instanceof ThingStateUpdateEventTrigger) || !(tt = (ThingStateUpdateEventTrigger)t).getThing().equals(thingUid) || (stateString = tt.getState()) != null && !newStatus.equals((Object)(triggerState = ThingStatus.valueOf((String)stateString)))) continue;
                        result.add(rule);
                    }
                }
                break;
            }
            case THINGCHANGE: {
                for (Rule rule : rules) {
                    for (EventTrigger t : rule.getEventtrigger()) {
                        ThingStatus triggerNewState;
                        String newStatusString;
                        ThingStatus triggerOldState;
                        String oldStatusString;
                        ThingStateChangedEventTrigger ct;
                        if (!(t instanceof ThingStateChangedEventTrigger) || !(ct = (ThingStateChangedEventTrigger)t).getThing().equals(thingUid) || (oldStatusString = ct.getOldState()) != null && !oldStatus.equals((Object)(triggerOldState = ThingStatus.valueOf((String)oldStatusString))) || (newStatusString = ct.getNewState()) != null && !newStatus.equals((Object)(triggerNewState = ThingStatus.valueOf((String)newStatusString)))) continue;
                        result.add(rule);
                    }
                }
                break;
            }
        }
        return result;
    }

    public void clear(TriggerTypes type) {
        switch (type) {
            case STARTUP: {
                this.systemStartupTriggeredRules.clear();
                break;
            }
            case SHUTDOWN: {
                this.systemShutdownTriggeredRules.clear();
                break;
            }
            case UPDATE: {
                this.updateEventTriggeredRules.clear();
                break;
            }
            case CHANGE: {
                this.changedEventTriggeredRules.clear();
                break;
            }
            case COMMAND: {
                this.commandEventTriggeredRules.clear();
                break;
            }
            case TRIGGER: {
                this.triggerEventTriggeredRules.clear();
                break;
            }
            case TIMER: {
                for (Rule rule : this.timerEventTriggeredRules) {
                    this.removeTimerRule(rule);
                }
                this.timerEventTriggeredRules.clear();
                break;
            }
            case THINGUPDATE: {
                this.thingUpdateEventTriggeredRules.clear();
                break;
            }
            case THINGCHANGE: {
                this.thingChangedEventTriggeredRules.clear();
            }
        }
    }

    public void clearAll() {
        this.clear(TriggerTypes.STARTUP);
        this.clear(TriggerTypes.SHUTDOWN);
        this.clear(TriggerTypes.UPDATE);
        this.clear(TriggerTypes.CHANGE);
        this.clear(TriggerTypes.COMMAND);
        this.clear(TriggerTypes.TIMER);
        this.clear(TriggerTypes.TRIGGER);
        this.clear(TriggerTypes.THINGUPDATE);
        this.clear(TriggerTypes.THINGCHANGE);
    }

    public synchronized void addRule(Rule rule) {
        for (EventTrigger t : rule.getEventtrigger()) {
            Set<Rule> rules;
            CommandEventTrigger ceTrigger;
            if (t instanceof SystemOnStartupTrigger) {
                this.systemStartupTriggeredRules.add(rule);
                continue;
            }
            if (t instanceof SystemOnShutdownTrigger) {
                this.systemShutdownTriggeredRules.add(rule);
                continue;
            }
            if (t instanceof CommandEventTrigger) {
                ceTrigger = (CommandEventTrigger)t;
                rules = this.commandEventTriggeredRules.get(ceTrigger.getItem());
                if (rules == null) {
                    rules = new HashSet<Rule>();
                    this.commandEventTriggeredRules.put(ceTrigger.getItem(), rules);
                }
                rules.add(rule);
                continue;
            }
            if (t instanceof UpdateEventTrigger) {
                UpdateEventTrigger ueTrigger = (UpdateEventTrigger)t;
                rules = this.updateEventTriggeredRules.get(ueTrigger.getItem());
                if (rules == null) {
                    rules = new HashSet<Rule>();
                    this.updateEventTriggeredRules.put(ueTrigger.getItem(), rules);
                }
                rules.add(rule);
                continue;
            }
            if (t instanceof ChangedEventTrigger) {
                ceTrigger = (ChangedEventTrigger)t;
                rules = this.changedEventTriggeredRules.get(ceTrigger.getItem());
                if (rules == null) {
                    rules = new HashSet<Rule>();
                    this.changedEventTriggeredRules.put(ceTrigger.getItem(), rules);
                }
                rules.add(rule);
                continue;
            }
            if (t instanceof TimerTrigger) {
                try {
                    this.createTimer(rule, (TimerTrigger)t);
                    this.timerEventTriggeredRules.add(rule);
                }
                catch (SchedulerException e) {
                    this.logger.error("Cannot create timer for rule '{}': {}", (Object)rule.getName(), (Object)e.getMessage());
                }
                continue;
            }
            if (t instanceof EventEmittedTrigger) {
                EventEmittedTrigger eeTrigger = (EventEmittedTrigger)t;
                rules = this.triggerEventTriggeredRules.get(eeTrigger.getChannel());
                if (rules == null) {
                    rules = new HashSet<Rule>();
                    this.triggerEventTriggeredRules.put(eeTrigger.getChannel(), rules);
                }
                rules.add(rule);
                continue;
            }
            if (t instanceof ThingStateUpdateEventTrigger) {
                ThingStateUpdateEventTrigger tsuTrigger = (ThingStateUpdateEventTrigger)t;
                rules = this.thingUpdateEventTriggeredRules.get(tsuTrigger.getThing());
                if (rules == null) {
                    rules = new HashSet<Rule>();
                    this.thingUpdateEventTriggeredRules.put(tsuTrigger.getThing(), rules);
                }
                rules.add(rule);
                continue;
            }
            if (!(t instanceof ThingStateChangedEventTrigger)) continue;
            ThingStateChangedEventTrigger tscTrigger = (ThingStateChangedEventTrigger)t;
            rules = this.thingChangedEventTriggeredRules.get(tscTrigger.getThing());
            if (rules == null) {
                rules = new HashSet<Rule>();
                this.thingChangedEventTriggeredRules.put(tscTrigger.getThing(), rules);
            }
            rules.add(rule);
        }
    }

    public void removeRule(TriggerTypes type, Rule rule) {
        switch (type) {
            case STARTUP: {
                this.systemStartupTriggeredRules.remove(rule);
                break;
            }
            case SHUTDOWN: {
                this.systemShutdownTriggeredRules.remove(rule);
                break;
            }
            case UPDATE: {
                for (Set<Rule> rules : this.updateEventTriggeredRules.values()) {
                    rules.remove(rule);
                }
                break;
            }
            case CHANGE: {
                for (Set<Rule> rules : this.changedEventTriggeredRules.values()) {
                    rules.remove(rule);
                }
                break;
            }
            case COMMAND: {
                for (Set<Rule> rules : this.commandEventTriggeredRules.values()) {
                    rules.remove(rule);
                }
                break;
            }
            case TRIGGER: {
                for (Set<Rule> rules : this.triggerEventTriggeredRules.values()) {
                    rules.remove(rule);
                }
                break;
            }
            case TIMER: {
                this.timerEventTriggeredRules.remove(rule);
                this.removeTimerRule(rule);
                break;
            }
            case THINGUPDATE: {
                for (Set<Rule> rules : this.thingUpdateEventTriggeredRules.values()) {
                    rules.remove(rule);
                }
                break;
            }
            case THINGCHANGE: {
                for (Set<Rule> rules : this.thingChangedEventTriggeredRules.values()) {
                    rules.remove(rule);
                }
                break;
            }
        }
    }

    public void addRuleModel(RuleModel model) {
        for (Rule rule : model.getRules()) {
            this.addRule(rule);
        }
    }

    public void removeRuleModel(RuleModel ruleModel) {
        this.removeRules(TriggerTypes.UPDATE, this.updateEventTriggeredRules.values(), ruleModel);
        this.removeRules(TriggerTypes.CHANGE, this.changedEventTriggeredRules.values(), ruleModel);
        this.removeRules(TriggerTypes.COMMAND, this.commandEventTriggeredRules.values(), ruleModel);
        this.removeRules(TriggerTypes.TRIGGER, this.triggerEventTriggeredRules.values(), ruleModel);
        this.removeRules(TriggerTypes.STARTUP, Collections.singletonList(this.systemStartupTriggeredRules), ruleModel);
        this.removeRules(TriggerTypes.SHUTDOWN, Collections.singletonList(this.systemShutdownTriggeredRules), ruleModel);
        this.removeRules(TriggerTypes.TIMER, Collections.singletonList(this.timerEventTriggeredRules), ruleModel);
        this.removeRules(TriggerTypes.THINGUPDATE, this.thingUpdateEventTriggeredRules.values(), ruleModel);
        this.removeRules(TriggerTypes.THINGCHANGE, this.thingChangedEventTriggeredRules.values(), ruleModel);
    }

    private void removeRules(TriggerTypes type, Collection<? extends Collection<Rule>> ruleSets, RuleModel model) {
        for (Collection<Rule> collection : ruleSets) {
            HashSet<Rule> clonedSet = new HashSet<Rule>(collection);
            if (model != null) {
                for (Rule newRule : model.getRules()) {
                    for (Rule oldRule : clonedSet) {
                        if (!newRule.getName().equals(oldRule.getName())) continue;
                        collection.remove(oldRule);
                        if (type != TriggerTypes.TIMER) continue;
                        this.removeTimerRule(oldRule);
                    }
                }
            }
            clonedSet = new HashSet<Rule>(collection);
            for (Rule rule : clonedSet) {
                if (rule.eResource() != null) continue;
                collection.remove(rule);
                if (type != TriggerTypes.TIMER) continue;
                this.removeTimerRule(rule);
            }
        }
    }

    private void removeTimerRule(Rule rule) {
        try {
            this.removeTimer(rule);
        }
        catch (SchedulerException e) {
            this.logger.error("Cannot remove timer for rule '{}'", (Object)rule.getName(), (Object)e);
        }
    }

    private void createTimer(Rule rule, TimerTrigger trigger) throws SchedulerException {
        String cronExpression = trigger.getCron();
        if (trigger.getTime() != null) {
            if (trigger.getTime().equals("noon")) {
                cronExpression = "0 0 12 * * ?";
            } else if (trigger.getTime().equals("midnight")) {
                cronExpression = "0 0 0 * * ?";
            } else {
                this.logger.warn("Unrecognized time expression '{}' in rule '{}'", (Object)trigger.getTime(), (Object)rule.getName());
                return;
            }
        }
        String jobIdentity = this.getJobIdentityString(rule, trigger);
        try {
            JobDetail job = JobBuilder.newJob(ExecuteRuleJob.class).usingJobData("model", rule.eResource().getURI().path()).usingJobData("rule", rule.getName()).withIdentity(jobIdentity).build();
            Trigger quartzTrigger = TriggerBuilder.newTrigger().withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)cronExpression)).build();
            this.scheduler.scheduleJob(job, Collections.singleton(quartzTrigger), true);
            this.logger.debug("Scheduled rule '{}' with cron expression '{}'", (Object)rule.getName(), (Object)cronExpression);
        }
        catch (RuntimeException e) {
            throw new SchedulerException(e.getMessage());
        }
    }

    private void removeTimer(Rule rule) throws SchedulerException {
        Set jobKeys = this.scheduler.getJobKeys(GroupMatcher.jobGroupEquals((String)"DEFAULT"));
        for (JobKey jobKey : jobKeys) {
            String jobIdentityString = this.getJobIdentityString(rule, null);
            if (!jobKey.getName().startsWith(jobIdentityString)) continue;
            boolean success = this.scheduler.deleteJob(jobKey);
            if (!success) {
                this.logger.warn("Failed to delete cron job '{}'", (Object)jobKey.getName());
                continue;
            }
            this.logger.debug("Removed scheduled cron job '{}'", (Object)jobKey.getName());
        }
    }

    private String getJobIdentityString(Rule rule, TimerTrigger trigger) {
        String jobIdentity = EcoreUtil.getURI((EObject)rule).trimFragment().appendFragment(rule.getName()).toString();
        if (trigger != null) {
            if (trigger.getTime() != null) {
                jobIdentity = String.valueOf(jobIdentity) + "#" + trigger.getTime();
            } else if (trigger.getCron() != null) {
                jobIdentity = String.valueOf(jobIdentity) + "#" + trigger.getCron();
            }
        }
        return jobIdentity;
    }

    public void startTimerRuleExecution() {
        try {
            this.scheduler.start();
        }
        catch (SchedulerException e) {
            this.logger.error("Error while starting the scheduler service: {}", (Object)e.getMessage());
        }
    }

    public static enum TriggerTypes {
        UPDATE,
        CHANGE,
        COMMAND,
        TRIGGER,
        STARTUP,
        SHUTDOWN,
        TIMER,
        THINGUPDATE,
        THINGCHANGE;

    }
}

