/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.lifx.internal;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.smarthome.binding.lifx.handler.LifxLightHandler;
import org.eclipse.smarthome.binding.lifx.internal.LifxLightContext;
import org.eclipse.smarthome.binding.lifx.internal.LifxSelectorContext;
import org.eclipse.smarthome.binding.lifx.internal.LifxSequenceNumberSupplier;
import org.eclipse.smarthome.binding.lifx.internal.fields.MACAddress;
import org.eclipse.smarthome.binding.lifx.internal.listener.LifxResponsePacketListener;
import org.eclipse.smarthome.binding.lifx.internal.protocol.GetServiceRequest;
import org.eclipse.smarthome.binding.lifx.internal.protocol.Packet;
import org.eclipse.smarthome.binding.lifx.internal.protocol.StateServiceResponse;
import org.eclipse.smarthome.binding.lifx.internal.util.LifxMessageUtil;
import org.eclipse.smarthome.binding.lifx.internal.util.LifxNetworkUtil;
import org.eclipse.smarthome.binding.lifx.internal.util.LifxSelectorUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
public class LifxLightCommunicationHandler {
    private final Logger logger = LoggerFactory.getLogger(LifxLightCommunicationHandler.class);
    private final String logId;
    private final LifxLightHandler.CurrentLightState currentLightState;
    private final ScheduledExecutorService scheduler;
    private final ReentrantLock lock = new ReentrantLock();
    private final long sourceId = LifxMessageUtil.randomSourceId();
    private final Supplier<Integer> sequenceNumberSupplier = new LifxSequenceNumberSupplier();
    private int service;
    private int unicastPort;
    private final int broadcastPort = LifxNetworkUtil.getNewBroadcastPort();
    private @Nullable ScheduledFuture<?> networkJob;
    private @Nullable MACAddress macAddress;
    private @Nullable InetSocketAddress host;
    private boolean broadcastEnabled;
    private @Nullable Selector selector;
    private @Nullable SelectionKey broadcastKey;
    private @Nullable SelectionKey unicastKey;
    private @Nullable LifxSelectorContext selectorContext;
    private List<LifxResponsePacketListener> responsePacketListeners = new CopyOnWriteArrayList<LifxResponsePacketListener>();

    public LifxLightCommunicationHandler(LifxLightContext context) {
        this.logId = context.getLogId();
        this.macAddress = context.getConfiguration().getMACAddress();
        this.host = context.getConfiguration().getHost();
        this.currentLightState = context.getCurrentLightState();
        this.scheduler = context.getScheduler();
        this.broadcastEnabled = context.getConfiguration().getHost() == null;
    }

    public void addResponsePacketListener(LifxResponsePacketListener listener) {
        this.responsePacketListeners.add(listener);
    }

    public void removeResponsePacketListener(LifxResponsePacketListener listener) {
        this.responsePacketListeners.remove(listener);
    }

    public void start() {
        block7: {
            try {
                try {
                    Selector localSelector;
                    this.lock.lock();
                    this.logger.debug("{} : Starting communication handler", (Object)this.logId);
                    this.logger.debug("{} : Using '{}' as source identifier", (Object)this.logId, (Object)Long.toString(this.sourceId, 16));
                    ScheduledFuture<?> localNetworkJob = this.networkJob;
                    if (localNetworkJob == null || localNetworkJob.isCancelled()) {
                        this.networkJob = this.scheduler.scheduleWithFixedDelay(this::receiveAndHandlePackets, 0L, 50L, TimeUnit.MILLISECONDS);
                    }
                    this.currentLightState.setOffline();
                    this.selector = localSelector = Selector.open();
                    if (this.isBroadcastEnabled()) {
                        this.broadcastKey = LifxSelectorUtil.openBroadcastChannel(this.selector, this.logId, this.broadcastPort);
                        this.selectorContext = new LifxSelectorContext(localSelector, this.sourceId, this.sequenceNumberSupplier, this.logId, this.host, this.macAddress, this.broadcastKey, this.unicastKey);
                        this.broadcastPacket(new GetServiceRequest());
                        break block7;
                    }
                    this.unicastKey = LifxSelectorUtil.openUnicastChannel(this.selector, this.logId, this.host);
                    this.selectorContext = new LifxSelectorContext(localSelector, this.sourceId, this.sequenceNumberSupplier, this.logId, this.host, this.macAddress, this.broadcastKey, this.unicastKey);
                    this.sendPacket(new GetServiceRequest());
                }
                catch (IOException e) {
                    this.logger.error("{} while starting LIFX communication handler for light '{}' : {}", new Object[]{e.getClass().getSimpleName(), this.logId, e.getMessage(), e});
                    this.lock.unlock();
                }
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    public void stop() {
        try {
            this.lock.lock();
            ScheduledFuture<?> localNetworkJob = this.networkJob;
            if (localNetworkJob != null && !localNetworkJob.isCancelled()) {
                localNetworkJob.cancel(true);
                this.networkJob = null;
            }
            LifxSelectorUtil.closeSelector(this.selector, this.logId);
            this.selector = null;
            this.broadcastKey = null;
            this.unicastKey = null;
            this.selectorContext = null;
        }
        finally {
            this.lock.unlock();
        }
    }

    public @Nullable InetSocketAddress getIpAddress() {
        return this.host;
    }

    public @Nullable MACAddress getMACAddress() {
        return this.macAddress;
    }

    public void receiveAndHandlePackets() {
        block6: {
            try {
                try {
                    this.lock.lock();
                    Selector localSelector = this.selector;
                    if (localSelector == null || !localSelector.isOpen()) {
                        this.logger.debug("{} : Unable to receive and handle packets with null or closed selector", (Object)this.logId);
                        break block6;
                    }
                    LifxSelectorUtil.receiveAndHandlePackets(localSelector, this.logId, (packet, address) -> this.handlePacket((Packet)packet, (InetSocketAddress)address));
                }
                catch (Exception e) {
                    this.logger.error("{} while receiving a packet from the light ({}): {}", new Object[]{e.getClass().getSimpleName(), this.logId, e.getMessage()});
                    this.lock.unlock();
                }
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    private void handlePacket(Packet packet, InetSocketAddress address) {
        boolean packetSourceIsHandler;
        boolean packetFromConfiguredMAC = this.macAddress != null && packet.getTarget().equals(this.macAddress);
        boolean packetFromConfiguredHost = this.host != null && address.equals(this.host);
        boolean broadcastPacket = packet.getTarget().equals(MACAddress.BROADCAST_ADDRESS);
        boolean bl = packetSourceIsHandler = packet.getSource() == this.sourceId || packet.getSource() == 0L;
        if ((packetFromConfiguredMAC || packetFromConfiguredHost || broadcastPacket) && packetSourceIsHandler) {
            this.logger.trace("{} : Packet type '{}' received from '{}' for '{}' with sequence '{}' and source '{}'", new Object[]{this.logId, packet.getClass().getSimpleName(), address.toString(), packet.getTarget().getHex(), packet.getSequence(), Long.toString(packet.getSource(), 16)});
            if (packet instanceof StateServiceResponse) {
                StateServiceResponse response = (StateServiceResponse)packet;
                MACAddress discoveredAddress = response.getTarget();
                if (packetFromConfiguredHost && this.macAddress == null) {
                    this.macAddress = discoveredAddress;
                    this.selectorContext.setMACAddress(this.macAddress);
                    this.currentLightState.setOnline(discoveredAddress);
                    return;
                }
                if (this.macAddress != null && this.macAddress.equals(discoveredAddress)) {
                    boolean newService;
                    boolean newHost = this.host == null || !address.equals(this.host);
                    boolean newPort = this.unicastPort != (int)response.getPort();
                    boolean bl2 = newService = this.service != response.getService();
                    if (newHost || newPort || newService || this.currentLightState.isOffline()) {
                        this.unicastPort = (int)response.getPort();
                        this.service = response.getService();
                        if (this.unicastPort == 0) {
                            this.logger.warn("Light ({}) service with ID '{}' is currently not available", (Object)this.logId, (Object)this.service);
                            this.currentLightState.setOfflineByCommunicationError();
                        } else {
                            this.host = new InetSocketAddress(address.getAddress(), this.unicastPort);
                            try {
                                LifxSelectorUtil.cancelKey(this.unicastKey, this.logId);
                                this.unicastKey = LifxSelectorUtil.openUnicastChannel(this.selector, this.logId, this.host);
                                this.selectorContext.setHost(this.host);
                                this.selectorContext.setUnicastKey(this.unicastKey);
                            }
                            catch (IOException e) {
                                this.logger.warn("{} while opening the unicast channel of the light ({}): {}", new Object[]{e.getClass().getSimpleName(), this.logId, e.getMessage()});
                                this.currentLightState.setOfflineByCommunicationError();
                                return;
                            }
                            this.currentLightState.setOnline();
                        }
                    }
                }
            }
            this.scheduler.schedule(() -> this.responsePacketListeners.forEach(listener -> listener.handleResponsePacket(packet)), 0L, TimeUnit.MILLISECONDS);
        }
    }

    public boolean isBroadcastEnabled() {
        return this.broadcastEnabled;
    }

    public void broadcastPacket(Packet packet) {
        this.wrappedPacketSend((s, p) -> LifxSelectorUtil.broadcastPacket(s, p), packet);
    }

    public void sendPacket(Packet packet) {
        if (this.host != null) {
            this.wrappedPacketSend((s, p) -> LifxSelectorUtil.sendPacket(s, p), packet);
        }
    }

    public void resendPacket(Packet packet) {
        if (this.host != null) {
            this.wrappedPacketSend((s, p) -> LifxSelectorUtil.resendPacket(s, p), packet);
        }
    }

    private void wrappedPacketSend(BiFunction<LifxSelectorContext, Packet, Boolean> function, Packet packet) {
        LifxSelectorContext localSelectorContext = this.selectorContext;
        if (localSelectorContext != null) {
            boolean result = false;
            try {
                this.lock.lock();
                result = function.apply(localSelectorContext, packet);
            }
            finally {
                this.lock.unlock();
                if (!result) {
                    this.currentLightState.setOfflineByCommunicationError();
                }
            }
        }
    }
}

