/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.internal.common;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.ExecutionException;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.smarthome.core.internal.common.DuplicateExecutionException;
import org.eclipse.smarthome.core.internal.common.Invocation;
import org.eclipse.smarthome.core.internal.common.SafeCallManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
abstract class AbstractInvocationHandler<T> {
    private static final String MSG_TIMEOUT_R = "Timeout of {}ms exceeded while calling\n{}\nThread '{}' ({}) is in state '{}'\n{}";
    private static final String MSG_TIMEOUT_Q = "Timeout of {}ms exceeded while calling\n{}\nThe task was still queued.";
    private static final String MSG_DUPLICATE = "Thread occupied while calling method '{}' on '{}' because of another blocking call.\n\tThe other call was to '{}'.\n\tIt's thread '{}' ({}) is in state '{}'\n{}";
    private static final String MSG_ERROR = "An error occurred while calling method '{}' on '{}': {}";
    private final Logger logger = LoggerFactory.getLogger(AbstractInvocationHandler.class);
    private final SafeCallManager manager;
    private final T target;
    private final Object identifier;
    private final long timeout;
    private final @Nullable Consumer<Throwable> exceptionHandler;
    private final @Nullable Runnable timeoutHandler;

    AbstractInvocationHandler(SafeCallManager manager, T target, Object identifier, long timeout, @Nullable Consumer<Throwable> exceptionHandler, @Nullable Runnable timeoutHandler) {
        this.manager = manager;
        this.target = target;
        this.identifier = identifier;
        this.timeout = timeout;
        this.exceptionHandler = exceptionHandler;
        this.timeoutHandler = timeoutHandler;
    }

    SafeCallManager getManager() {
        return this.manager;
    }

    T getTarget() {
        return this.target;
    }

    Object getIdentifier() {
        return this.identifier;
    }

    long getTimeout() {
        return this.timeout;
    }

    @Nullable Consumer<Throwable> getExceptionHandler() {
        return this.exceptionHandler;
    }

    @Nullable Runnable getTimeoutHandler() {
        return this.timeoutHandler;
    }

    void handleExecutionException(Method method, ExecutionException e) {
        if (e.getCause() instanceof DuplicateExecutionException) {
            this.handleDuplicate(method, (DuplicateExecutionException)e.getCause());
        } else if (e.getCause() instanceof InvocationTargetException) {
            this.handleException(method, (InvocationTargetException)e.getCause());
        }
    }

    void handleException(Method method, InvocationTargetException e) {
        this.logger.error(MSG_ERROR, new Object[]{this.toString(method), this.target, e.getCause().getMessage(), e.getCause()});
        if (this.exceptionHandler != null) {
            this.exceptionHandler.accept(e.getCause());
        }
    }

    void handleDuplicate(Method method, DuplicateExecutionException e) {
        Thread thread = e.getCallable().getThread();
        this.logger.debug(MSG_DUPLICATE, new Object[]{this.toString(method), this.target, this.toString(e.getCallable().getMethod()), thread.getName(), thread.getId(), thread.getState().toString(), this.getStacktrace(thread)});
    }

    void handleTimeout(Method method, Invocation invocation) {
        Thread thread = invocation.getThread();
        if (thread != null) {
            this.logger.debug(MSG_TIMEOUT_R, new Object[]{this.timeout, this.toString(invocation.getInvocationStack()), thread.getName(), thread.getId(), thread.getState().toString(), this.getStacktrace(thread)});
        } else {
            this.logger.debug(MSG_TIMEOUT_Q, (Object)this.timeout, (Object)this.toString(invocation.getInvocationStack()));
        }
        if (this.timeoutHandler != null) {
            this.timeoutHandler.run();
        }
    }

    private String toString(Collection<Invocation> invocationStack) {
        return invocationStack.stream().map(invocation -> "\t'" + this.toString(invocation.getMethod()) + "' on '" + invocation.getInvocationHandler().getTarget() + "'").collect(Collectors.joining(" via\n"));
    }

    private String getStacktrace(final Thread thread) {
        StackTraceElement[] elements = AccessController.doPrivileged(new PrivilegedAction<StackTraceElement[]>(){

            @Override
            public StackTraceElement[] run() {
                return thread.getStackTrace();
            }
        });
        return Arrays.stream(elements).map(element -> "\tat " + element.toString()).collect(Collectors.joining("\n"));
    }

    String toString(Method method) {
        return String.valueOf(method.getDeclaringClass().getSimpleName()) + "." + method.getName() + "()";
    }

    @Nullable Object invokeDirect(Invocation invocation) throws IllegalAccessException, IllegalArgumentException {
        try {
            this.manager.recordCallStart(invocation);
        }
        catch (DuplicateExecutionException duplicateExecutionException) {
            return null;
        }
        try {
            Object object = invocation.getMethod().invoke(this.target, invocation.getArgs());
            return object;
        }
        catch (InvocationTargetException e) {
            this.handleException(invocation.getMethod(), e);
            return null;
        }
        finally {
            this.manager.recordCallEnd(invocation);
        }
    }
}

