/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.internal.common;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.smarthome.core.internal.common.DuplicateExecutionException;
import org.eclipse.smarthome.core.internal.common.Invocation;
import org.eclipse.smarthome.core.internal.common.InvocationHandlerAsync;
import org.eclipse.smarthome.core.internal.common.SafeCallManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
public class SafeCallManagerImpl
implements SafeCallManager {
    private final Logger logger = LoggerFactory.getLogger(SafeCallManagerImpl.class);
    private final Map<Object, @Nullable Queue<Invocation>> queues = new HashMap<Object, Queue<Invocation>>();
    private final Map<Object, @Nullable Invocation> activeIdentifiers = new HashMap<Object, Invocation>();
    private final Map<Object, @Nullable Invocation> activeAsyncInvocations = new HashMap<Object, Invocation>();
    private final ScheduledExecutorService watcher;
    private final ExecutorService scheduler;
    private boolean enforceSingleThreadPerIdentifier;

    public SafeCallManagerImpl(ScheduledExecutorService watcher, ExecutorService scheduler, boolean enforceSingleThreadPerIdentifier) {
        this.watcher = watcher;
        this.scheduler = scheduler;
        this.enforceSingleThreadPerIdentifier = enforceSingleThreadPerIdentifier;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void recordCallStart(Invocation invocation) {
        Map<Object, Invocation> map = this.activeIdentifiers;
        synchronized (map) {
            Invocation otherInvocation = this.activeIdentifiers.get(invocation.getIdentifier());
            if (this.enforceSingleThreadPerIdentifier && otherInvocation != null) {
                this.enqueue(invocation);
                throw new DuplicateExecutionException(otherInvocation);
            }
            this.activeIdentifiers.put(invocation.getIdentifier(), invocation);
        }
        if (invocation.getInvocationHandler() instanceof InvocationHandlerAsync) {
            this.watch(invocation);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void recordCallEnd(Invocation invocation) {
        Map<Object, Invocation> map = this.activeIdentifiers;
        synchronized (map) {
            this.activeIdentifiers.remove(invocation.getIdentifier());
        }
        map = this.activeAsyncInvocations;
        synchronized (map) {
            this.activeAsyncInvocations.remove(invocation.getIdentifier());
        }
        this.logger.trace("Finished {}", (Object)invocation);
        this.trigger(invocation.getIdentifier());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void enqueue(Invocation invocation) {
        Map<Object, Queue<Invocation>> map = this.queues;
        synchronized (map) {
            Queue<Invocation> queue = this.queues.get(invocation.getIdentifier());
            if (queue == null) {
                queue = new LinkedList<Invocation>();
                this.queues.put(invocation.getIdentifier(), queue);
            }
            queue.add(invocation);
        }
        this.trigger(invocation.getIdentifier());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void trigger(Object identifier) {
        this.logger.trace("Triggering submissions for '{}'", identifier);
        Map<Object, Invocation> map = this.activeIdentifiers;
        synchronized (map) {
            if (this.enforceSingleThreadPerIdentifier && this.activeIdentifiers.containsKey(identifier)) {
                this.logger.trace("Identifier '{}' is already running", identifier);
                return;
            }
        }
        map = this.activeAsyncInvocations;
        synchronized (map) {
            if (this.activeAsyncInvocations.containsKey(identifier)) {
                this.logger.trace("Identifier '{}' is already scheduled for asynchronous execution", identifier);
                return;
            }
            Invocation next = this.dequeue(identifier);
            if (next != null) {
                this.logger.trace("Scheduling {} for asynchronous execution", (Object)next);
                this.activeAsyncInvocations.put(identifier, next);
                this.getScheduler().submit(next);
                this.logger.trace("Submitted {} for asynchronous execution", (Object)next);
            }
        }
    }

    private void handlePotentialTimeout(Invocation invocation) {
        Invocation activeInvocation;
        Object identifier = invocation.getIdentifier();
        Invocation activeAsyncInvocation = this.activeAsyncInvocations.get(identifier);
        if (activeAsyncInvocation == invocation && (activeInvocation = this.activeIdentifiers.get(identifier)) != null) {
            invocation.getInvocationHandler().handleTimeout(invocation.getMethod(), activeInvocation);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public @Nullable Invocation dequeue(Object identifier) {
        Map<Object, Queue<Invocation>> map = this.queues;
        synchronized (map) {
            Queue<Invocation> queue = this.queues.get(identifier);
            if (queue != null) {
                return queue.poll();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public @Nullable Invocation getActiveInvocation() {
        Map<Object, Invocation> map = this.activeIdentifiers;
        synchronized (map) {
            for (Invocation invocation : this.activeIdentifiers.values()) {
                if (invocation.getThread() != Thread.currentThread()) continue;
                return invocation;
            }
        }
        return null;
    }

    @Override
    public ExecutorService getScheduler() {
        return this.scheduler;
    }

    private void watch(Invocation invocation) {
        this.watcher.schedule(() -> this.handlePotentialTimeout(invocation), invocation.getTimeout(), TimeUnit.MILLISECONDS);
        this.logger.trace("Scheduling timeout watcher in {}ms", (Object)invocation.getTimeout());
    }

    public void setEnforceSingleThreadPerIdentifier(boolean enforceSingleThreadPerIdentifier) {
        this.enforceSingleThreadPerIdentifier = enforceSingleThreadPerIdentifier;
    }
}

