/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.internal.items;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.smarthome.core.common.registry.AbstractManagedProvider;
import org.eclipse.smarthome.core.items.ManagedMetadataProvider;
import org.eclipse.smarthome.core.items.Metadata;
import org.eclipse.smarthome.core.items.MetadataKey;
import org.eclipse.smarthome.core.items.MetadataPredicates;
import org.eclipse.smarthome.core.items.MetadataProvider;
import org.eclipse.smarthome.core.storage.StorageService;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, service={MetadataProvider.class, ManagedMetadataProvider.class})
public class ManagedMetadataProviderImpl
extends AbstractManagedProvider<Metadata, MetadataKey, Metadata>
implements ManagedMetadataProvider {
    private final Logger logger = LoggerFactory.getLogger(ManagedMetadataProviderImpl.class);

    @Override
    protected String getStorageName() {
        return Metadata.class.getName();
    }

    @Override
    protected @NonNull String keyToString(@NonNull MetadataKey key) {
        return key.toString();
    }

    @Override
    protected Metadata toElement(@NonNull String key, @NonNull Metadata persistableElement) {
        return persistableElement;
    }

    @Override
    protected Metadata toPersistableElement(Metadata element) {
        return element;
    }

    @Override
    @Reference
    protected void setStorageService(StorageService storageService) {
        super.setStorageService(storageService);
    }

    @Override
    protected void unsetStorageService(StorageService storageService) {
        super.unsetStorageService(storageService);
    }

    @Override
    public void removeItemMetadata(@NonNull String name) {
        this.logger.debug("Removing all metadata for item {}", (Object)name);
        this.getAll().stream().filter(MetadataPredicates.ofItem(name)).map(Metadata::getUID).forEach(this::remove);
    }
}

