/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.library.items;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.smarthome.core.library.items.DimmerItem;
import org.eclipse.smarthome.core.library.types.DecimalType;
import org.eclipse.smarthome.core.library.types.HSBType;
import org.eclipse.smarthome.core.library.types.IncreaseDecreaseType;
import org.eclipse.smarthome.core.library.types.OnOffType;
import org.eclipse.smarthome.core.library.types.PercentType;
import org.eclipse.smarthome.core.types.Command;
import org.eclipse.smarthome.core.types.RefreshType;
import org.eclipse.smarthome.core.types.State;
import org.eclipse.smarthome.core.types.UnDefType;

@NonNullByDefault
public class ColorItem
extends DimmerItem {
    private static List<Class<? extends State>> acceptedDataTypes = new ArrayList<Class<? extends State>>();
    private static List<Class<? extends Command>> acceptedCommandTypes = new ArrayList<Class<? extends Command>>();

    static {
        acceptedDataTypes.add(HSBType.class);
        acceptedDataTypes.add(PercentType.class);
        acceptedDataTypes.add(OnOffType.class);
        acceptedDataTypes.add(UnDefType.class);
        acceptedCommandTypes.add(HSBType.class);
        acceptedCommandTypes.add(PercentType.class);
        acceptedCommandTypes.add(OnOffType.class);
        acceptedCommandTypes.add(IncreaseDecreaseType.class);
        acceptedCommandTypes.add(RefreshType.class);
    }

    public ColorItem(String name) {
        super("Color", name);
    }

    public void send(HSBType command) {
        this.internalSend(command);
    }

    @Override
    public List<Class<? extends State>> getAcceptedDataTypes() {
        return Collections.unmodifiableList(acceptedDataTypes);
    }

    @Override
    public List<Class<? extends Command>> getAcceptedCommandTypes() {
        return Collections.unmodifiableList(acceptedCommandTypes);
    }

    @Override
    public void setState(State state) {
        if (this.isAcceptedState(acceptedDataTypes, state)) {
            State currentState = this.state;
            if (currentState instanceof HSBType) {
                DecimalType hue = ((HSBType)currentState).getHue();
                PercentType saturation = ((HSBType)currentState).getSaturation();
                if (state == OnOffType.OFF) {
                    this.applyState(new HSBType(hue, saturation, PercentType.ZERO));
                } else if (state == OnOffType.ON) {
                    this.applyState(new HSBType(hue, saturation, PercentType.HUNDRED));
                } else if (state instanceof PercentType && !(state instanceof HSBType)) {
                    this.applyState(new HSBType(hue, saturation, (PercentType)state));
                } else if (state instanceof DecimalType && !(state instanceof HSBType)) {
                    this.applyState(new HSBType(hue, saturation, new PercentType(((DecimalType)state).toBigDecimal().multiply(BigDecimal.valueOf(100L)))));
                } else {
                    this.applyState(state);
                }
            } else {
                HSBType convertedState = state.as(HSBType.class);
                if (convertedState != null) {
                    this.applyState(convertedState);
                } else {
                    this.applyState(state);
                }
            }
        } else {
            this.logSetTypeError(state);
        }
    }
}

