/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.library.types;

import java.time.ZonedDateTime;
import java.util.Set;
import org.eclipse.smarthome.core.items.GroupFunction;
import org.eclipse.smarthome.core.items.Item;
import org.eclipse.smarthome.core.library.types.DateTimeType;
import org.eclipse.smarthome.core.types.State;
import org.eclipse.smarthome.core.types.UnDefType;

public interface DateTimeGroupFunction
extends GroupFunction {

    public static class Earliest
    implements GroupFunction {
        @Override
        public State calculate(Set<Item> items) {
            if (items != null && items.size() > 0) {
                ZonedDateTime max = null;
                for (Item item : items) {
                    DateTimeType itemState = item.getStateAs(DateTimeType.class);
                    if (itemState == null || max != null && !max.isAfter(itemState.getZonedDateTime())) continue;
                    max = itemState.getZonedDateTime();
                }
                if (max != null) {
                    return new DateTimeType(max);
                }
            }
            return UnDefType.UNDEF;
        }

        @Override
        public <T extends State> T getStateAs(Set<Item> items, Class<T> stateClass) {
            State state = this.calculate(items);
            if (stateClass.isInstance(state)) {
                return (T)((State)stateClass.cast(state));
            }
            return null;
        }

        @Override
        public State[] getParameters() {
            return new State[0];
        }
    }

    public static class Latest
    implements GroupFunction {
        @Override
        public State calculate(Set<Item> items) {
            if (items != null && items.size() > 0) {
                ZonedDateTime max = null;
                for (Item item : items) {
                    DateTimeType itemState = item.getStateAs(DateTimeType.class);
                    if (itemState == null || max != null && !max.isBefore(itemState.getZonedDateTime())) continue;
                    max = itemState.getZonedDateTime();
                }
                if (max != null) {
                    return new DateTimeType(max);
                }
            }
            return UnDefType.UNDEF;
        }

        @Override
        public <T extends State> T getStateAs(Set<Item> items, Class<T> stateClass) {
            State state = this.calculate(items);
            if (stateClass.isInstance(state)) {
                return (T)((State)stateClass.cast(state));
            }
            return null;
        }

        @Override
        public State[] getParameters() {
            return new State[0];
        }
    }
}

