/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.library.unit;

import java.math.BigInteger;
import javax.measure.Unit;
import javax.measure.UnitConverter;
import javax.measure.quantity.Acceleration;
import javax.measure.quantity.AmountOfSubstance;
import javax.measure.quantity.Angle;
import javax.measure.quantity.CatalyticActivity;
import javax.measure.quantity.Dimensionless;
import javax.measure.quantity.ElectricCapacitance;
import javax.measure.quantity.ElectricCharge;
import javax.measure.quantity.ElectricConductance;
import javax.measure.quantity.ElectricCurrent;
import javax.measure.quantity.ElectricInductance;
import javax.measure.quantity.ElectricPotential;
import javax.measure.quantity.ElectricResistance;
import javax.measure.quantity.Energy;
import javax.measure.quantity.Force;
import javax.measure.quantity.Frequency;
import javax.measure.quantity.Illuminance;
import javax.measure.quantity.LuminousFlux;
import javax.measure.quantity.LuminousIntensity;
import javax.measure.quantity.MagneticFlux;
import javax.measure.quantity.MagneticFluxDensity;
import javax.measure.quantity.Power;
import javax.measure.quantity.Pressure;
import javax.measure.quantity.RadiationDoseAbsorbed;
import javax.measure.quantity.RadiationDoseEffective;
import javax.measure.quantity.Radioactivity;
import javax.measure.quantity.SolidAngle;
import javax.measure.quantity.Speed;
import javax.measure.quantity.Temperature;
import javax.measure.quantity.Time;
import javax.measure.quantity.Volume;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.smarthome.core.library.dimension.ArealDensity;
import org.eclipse.smarthome.core.library.dimension.Density;
import org.eclipse.smarthome.core.library.dimension.Intensity;
import org.eclipse.smarthome.core.library.unit.MetricPrefix;
import tec.uom.se.AbstractConverter;
import tec.uom.se.AbstractSystemOfUnits;
import tec.uom.se.AbstractUnit;
import tec.uom.se.format.SimpleUnitFormat;
import tec.uom.se.function.LogConverter;
import tec.uom.se.function.PiMultiplierConverter;
import tec.uom.se.function.RationalConverter;
import tec.uom.se.unit.AlternateUnit;
import tec.uom.se.unit.ProductUnit;
import tec.uom.se.unit.TransformedUnit;
import tec.uom.se.unit.Units;

@NonNullByDefault
public class SmartHomeUnits
extends AbstractSystemOfUnits {
    private static final SmartHomeUnits INSTANCE = new SmartHomeUnits();
    public static final Unit<Angle> DEGREE_ANGLE = SmartHomeUnits.addUnit(new TransformedUnit(Units.RADIAN, (UnitConverter)new PiMultiplierConverter().concatenate((AbstractConverter)new RationalConverter(1L, 180L))));
    public static final Unit<Intensity> IRRADIANCE = SmartHomeUnits.addUnit(new AlternateUnit(Units.WATT.divide(Units.SQUARE_METRE), "W/m2"));
    public static final Unit<Intensity> MICROWATT_PER_SQUARE_CENTIMETRE = SmartHomeUnits.addUnit(new TransformedUnit(IRRADIANCE, (UnitConverter)new RationalConverter(BigInteger.valueOf(100L), BigInteger.valueOf(1L))));
    public static final Unit<Dimensionless> ONE = SmartHomeUnits.addUnit(AbstractUnit.ONE);
    public static final Unit<ElectricCurrent> AMPERE = SmartHomeUnits.addUnit(Units.AMPERE);
    public static final Unit<LuminousIntensity> CANDELA = SmartHomeUnits.addUnit(Units.CANDELA);
    public static final Unit<Temperature> KELVIN = SmartHomeUnits.addUnit(Units.KELVIN);
    public static final Unit<AmountOfSubstance> MOLE = SmartHomeUnits.addUnit(Units.MOLE);
    public static final Unit<Time> SECOND = SmartHomeUnits.addUnit(Units.SECOND);
    public static final Unit<Angle> RADIAN = SmartHomeUnits.addUnit(Units.RADIAN);
    public static final Unit<SolidAngle> STERADIAN = SmartHomeUnits.addUnit(Units.STERADIAN);
    public static final Unit<Frequency> HERTZ = SmartHomeUnits.addUnit(Units.HERTZ);
    public static final Unit<Force> NEWTON = SmartHomeUnits.addUnit(Units.NEWTON);
    public static final Unit<Energy> JOULE = SmartHomeUnits.addUnit(Units.JOULE);
    public static final Unit<Power> WATT = SmartHomeUnits.addUnit(Units.WATT);
    public static final Unit<ElectricCharge> COULOMB = SmartHomeUnits.addUnit(Units.COULOMB);
    public static final Unit<ElectricPotential> VOLT = SmartHomeUnits.addUnit(Units.VOLT);
    public static final Unit<ElectricCapacitance> FARAD = SmartHomeUnits.addUnit(Units.FARAD);
    public static final Unit<ElectricResistance> OHM = SmartHomeUnits.addUnit(Units.OHM);
    public static final Unit<ElectricConductance> SIEMENS = SmartHomeUnits.addUnit(Units.SIEMENS);
    public static final Unit<MagneticFlux> WEBER = SmartHomeUnits.addUnit(Units.WEBER);
    public static final Unit<MagneticFluxDensity> TESLA = SmartHomeUnits.addUnit(Units.TESLA);
    public static final Unit<ElectricInductance> HENRY = SmartHomeUnits.addUnit(Units.HENRY);
    public static final Unit<LuminousFlux> LUMEN = SmartHomeUnits.addUnit(Units.LUMEN);
    public static final Unit<Illuminance> LUX = SmartHomeUnits.addUnit(Units.LUX);
    public static final Unit<Radioactivity> BECQUEREL = SmartHomeUnits.addUnit(Units.BECQUEREL);
    public static final Unit<RadiationDoseAbsorbed> GRAY = SmartHomeUnits.addUnit(Units.GRAY);
    public static final Unit<RadiationDoseEffective> SIEVERT = SmartHomeUnits.addUnit(Units.SIEVERT);
    public static final Unit<CatalyticActivity> KATAL = SmartHomeUnits.addUnit(Units.KATAL);
    public static final Unit<Speed> METRE_PER_SECOND = SmartHomeUnits.addUnit(Units.METRE_PER_SECOND);
    public static final Unit<Speed> KNOT = SmartHomeUnits.addUnit(new TransformedUnit("kn", Units.KILOMETRE_PER_HOUR, (UnitConverter)new RationalConverter(BigInteger.valueOf(1852L), BigInteger.valueOf(1000L))));
    public static final Unit<Acceleration> METRE_PER_SQUARE_SECOND = SmartHomeUnits.addUnit(Units.METRE_PER_SQUARE_SECOND);
    public static final Unit<Dimensionless> PERCENT = SmartHomeUnits.addUnit(Units.PERCENT);
    public static final Unit<Dimensionless> PARTS_PER_MILLION = SmartHomeUnits.addUnit(new TransformedUnit(ONE, (UnitConverter)new RationalConverter(1L, 1000000L)));
    public static final Unit<Dimensionless> DECIBEL = SmartHomeUnits.addUnit(ONE.transform((UnitConverter)new LogConverter(10.0).inverse().concatenate((AbstractConverter)RationalConverter.of((double)1.0, (double)10.0))));
    public static final Unit<Time> MINUTE = SmartHomeUnits.addUnit(Units.MINUTE);
    public static final Unit<Time> HOUR = SmartHomeUnits.addUnit(Units.HOUR);
    public static final Unit<Time> DAY = SmartHomeUnits.addUnit(Units.DAY);
    public static final Unit<Time> WEEK = SmartHomeUnits.addUnit(Units.WEEK);
    public static final Unit<Time> YEAR = SmartHomeUnits.addUnit(Units.YEAR);
    public static final Unit<Volume> LITRE = SmartHomeUnits.addUnit(Units.LITRE);
    public static final Unit<Density> KILOGRAM_PER_CUBICMETRE = SmartHomeUnits.addUnit(new ProductUnit(Units.KILOGRAM.divide(Units.METRE.pow(3))));
    public static final Unit<Density> MICROGRAM_PER_CUBICMETRE = SmartHomeUnits.addUnit(new TransformedUnit(KILOGRAM_PER_CUBICMETRE, (UnitConverter)new RationalConverter(BigInteger.valueOf(1L), BigInteger.valueOf(1000000000L))));
    public static final Unit<Energy> WATT_SECOND = SmartHomeUnits.addUnit(new ProductUnit(Units.WATT.multiply(Units.SECOND)));
    public static final Unit<Energy> WATT_HOUR = SmartHomeUnits.addUnit(new ProductUnit(Units.WATT.multiply(Units.HOUR)));
    public static final Unit<Energy> KILOWATT_HOUR = SmartHomeUnits.addUnit(MetricPrefix.KILO(WATT_HOUR));
    public static final Unit<Pressure> MILLIMETRE_OF_MERCURY = SmartHomeUnits.addUnit(new TransformedUnit("mmHg", Units.PASCAL, (UnitConverter)new RationalConverter(BigInteger.valueOf(133322368L), BigInteger.valueOf(1000000L))));
    public static final Unit<Pressure> BAR = SmartHomeUnits.addUnit(new TransformedUnit("bar", Units.PASCAL, (UnitConverter)new RationalConverter(BigInteger.valueOf(100000L), BigInteger.valueOf(1L))));
    public static final Unit<Pressure> MILLIBAR = SmartHomeUnits.addUnit(MetricPrefix.MILLI(BAR));
    public static final Unit<ArealDensity> DOBSON_UNIT = SmartHomeUnits.addUnit(new ProductUnit(MetricPrefix.MILLI(Units.MOLE).multiply(0.4462).divide(Units.METRE.pow(2))));

    static {
        SimpleUnitFormat.getInstance().label(PARTS_PER_MILLION, "ppm");
        SimpleUnitFormat.getInstance().label(DECIBEL, "dB");
        SimpleUnitFormat.getInstance().label(IRRADIANCE, "W/m\u00b2");
        SimpleUnitFormat.getInstance().label(MICROWATT_PER_SQUARE_CENTIMETRE, "\u03bcW/cm\u00b2");
        SimpleUnitFormat.getInstance().label(DEGREE_ANGLE, "\u00b0");
        SimpleUnitFormat.getInstance().label(MICROGRAM_PER_CUBICMETRE, "\u03bcg/m\u00b3");
        SimpleUnitFormat.getInstance().label(WATT_SECOND, "Ws");
        SimpleUnitFormat.getInstance().label(WATT_HOUR, "Wh");
        SimpleUnitFormat.getInstance().label(KILOWATT_HOUR, "kWh");
        SimpleUnitFormat.getInstance().label(MILLIMETRE_OF_MERCURY, MILLIMETRE_OF_MERCURY.getSymbol());
        SimpleUnitFormat.getInstance().label(BAR, BAR.getSymbol());
        SimpleUnitFormat.getInstance().label(MILLIBAR, "mbar");
        SimpleUnitFormat.getInstance().label(KNOT, KNOT.getSymbol());
        SimpleUnitFormat.getInstance().label(DOBSON_UNIT, "DU");
    }

    protected SmartHomeUnits() {
    }

    public String getName() {
        return SmartHomeUnits.class.getSimpleName();
    }

    private static <U extends Unit<?>> U addUnit(U unit) {
        SmartHomeUnits.INSTANCE.units.add(unit);
        return unit;
    }
}

