/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.types;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import org.eclipse.smarthome.core.types.Command;
import org.eclipse.smarthome.core.types.State;
import org.eclipse.smarthome.core.types.Type;

public final class TypeParser {
    private static final String CORE_LIBRARY_PACKAGE = "org.eclipse.smarthome.core.library.types.";

    private TypeParser() {
    }

    public static Type parseType(String typeName, String input) {
        try {
            Class<?> stateClass = Class.forName(CORE_LIBRARY_PACKAGE + typeName);
            Method valueOfMethod = stateClass.getMethod("valueOf", String.class);
            return (Type)valueOfMethod.invoke(stateClass, input);
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InvocationTargetException invocationTargetException) {}
        return null;
    }

    public static State parseState(List<Class<? extends State>> types, String s) {
        for (Class<? extends State> type : types) {
            try {
                Method valueOf = type.getMethod("valueOf", String.class);
                State state = (State)valueOf.invoke(type, s);
                if (state == null) continue;
                return state;
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InvocationTargetException invocationTargetException) {}
        }
        return null;
    }

    public static Command parseCommand(List<Class<? extends Command>> types, String s) {
        for (Class<? extends Command> type : types) {
            try {
                Method valueOf = type.getMethod("valueOf", String.class);
                Command value = (Command)valueOf.invoke(type, s);
                if (value == null) continue;
                return value;
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InvocationTargetException invocationTargetException) {}
        }
        return null;
    }
}

