/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.types.util;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collection;
import java.util.Set;
import java.util.stream.Collectors;
import javax.measure.Quantity;
import javax.measure.Unit;
import javax.measure.UnitConverter;
import javax.measure.spi.SystemOfUnits;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.smarthome.core.internal.library.unit.UnitInitializer;
import org.eclipse.smarthome.core.library.unit.ImperialUnits;
import org.eclipse.smarthome.core.library.unit.SIUnits;
import org.eclipse.smarthome.core.library.unit.SmartHomeUnits;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tec.uom.se.ComparableQuantity;
import tec.uom.se.quantity.Quantities;
import tec.uom.se.unit.MetricPrefix;
import tec.uom.se.unit.TransformedUnit;
import tec.uom.se.unit.Units;

@NonNullByDefault
public class UnitUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(UnitUtils.class);
    public static final String UNIT_PLACEHOLDER = "%unit%";
    public static final String UNIT_PERCENT_FORMAT_STRING = "%%";
    private static final String JAVAX_MEASURE_QUANTITY_PREFIX = "javax.measure.quantity.";
    private static final String FRAMEWORK_DIMENSION_PREFIX = "org.eclipse.smarthome.core.library.dimension.";
    private static final Collection<Class<? extends SystemOfUnits>> ALL_SYSTEM_OF_UNITS = Arrays.asList(SIUnits.class, ImperialUnits.class, SmartHomeUnits.class, Units.class);

    static {
        UnitInitializer.init();
    }

    public static @Nullable Class<? extends Quantity<?>> parseDimension(String dimension) {
        if (StringUtils.isBlank((String)dimension)) {
            return null;
        }
        try {
            return UnitUtils.dimensionClass(FRAMEWORK_DIMENSION_PREFIX, dimension);
        }
        catch (ClassNotFoundException classNotFoundException) {
            try {
                return UnitUtils.dimensionClass(JAVAX_MEASURE_QUANTITY_PREFIX, dimension);
            }
            catch (ClassNotFoundException classNotFoundException2) {
                throw new IllegalArgumentException("Error creating a dimension Class instance for name '" + dimension + "'.");
            }
        }
    }

    public static @Nullable String getDimensionName(Unit<?> unit) {
        for (Class<? extends SystemOfUnits> system : ALL_SYSTEM_OF_UNITS) {
            Field[] fieldArray = system.getDeclaredFields();
            int n = fieldArray.length;
            int n2 = 0;
            while (n2 < n) {
                Field field = fieldArray[n2];
                if (field.getType().isAssignableFrom(Unit.class) && Modifier.isStatic(field.getModifiers())) {
                    Type genericType = field.getGenericType();
                    if (genericType instanceof ParameterizedType) {
                        String dimension = ((Class)((ParameterizedType)genericType).getActualTypeArguments()[0]).getSimpleName();
                        try {
                            Unit systemUnit = (Unit)field.get(null);
                            if (systemUnit == null) {
                                LOGGER.warn("Unit field points to a null value: {}", (Object)field);
                            } else if (systemUnit.isCompatible(unit)) {
                                return dimension;
                            }
                        }
                        catch (IllegalAccessException | IllegalArgumentException e) {
                            LOGGER.error("The unit field '{}' seems to be not accessible", (Object)field, (Object)e);
                        }
                    } else {
                        LOGGER.warn("There is a unit field defined which has no generic type parametrization: {}", (Object)field);
                    }
                }
                ++n2;
            }
        }
        return null;
    }

    public static @Nullable Unit<?> parseUnit(String pattern) {
        if (StringUtils.isBlank((String)pattern)) {
            return null;
        }
        String unitSymbol = pattern;
        int lastBlankIndex = pattern.lastIndexOf(" ");
        if (lastBlankIndex >= 0) {
            unitSymbol = pattern.substring(lastBlankIndex).trim();
        }
        if (StringUtils.isNotBlank((String)unitSymbol) && !unitSymbol.equals(UNIT_PLACEHOLDER)) {
            if (UNIT_PERCENT_FORMAT_STRING.equals(unitSymbol)) {
                return SmartHomeUnits.PERCENT;
            }
            try {
                ComparableQuantity quantity = Quantities.getQuantity((CharSequence)("1 " + unitSymbol));
                return quantity.getUnit();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                LOGGER.debug("Unknown unit from pattern: {}", (Object)unitSymbol);
            }
        }
        return null;
    }

    public static boolean isDifferentMeasurementSystem(Unit<? extends Quantity<?>> thisUnit, Unit<?> thatUnit) {
        boolean differentSystems;
        Set siUnits = SIUnits.getInstance().getUnits();
        Set usUnits = ImperialUnits.getInstance().getUnits();
        boolean bl = differentSystems = siUnits.contains(thisUnit) && usUnits.contains(thatUnit) || siUnits.contains(thatUnit) && usUnits.contains(thisUnit);
        if (!differentSystems) {
            if (thisUnit instanceof TransformedUnit && UnitUtils.isMetricConversion(((TransformedUnit)thisUnit).getConverter())) {
                return UnitUtils.isDifferentMeasurementSystem(((TransformedUnit)thisUnit).getParentUnit(), thatUnit);
            }
            if (thatUnit instanceof TransformedUnit && UnitUtils.isMetricConversion(((TransformedUnit)thatUnit).getConverter())) {
                return UnitUtils.isDifferentMeasurementSystem(thisUnit, ((TransformedUnit)thatUnit).getParentUnit());
            }
        }
        if (!differentSystems) {
            Set siSymbols = siUnits.stream().map(Unit::getSymbol).collect(Collectors.toSet());
            Set usSymbols = usUnits.stream().map(Unit::getSymbol).collect(Collectors.toSet());
            differentSystems = siSymbols.contains(thisUnit.getSymbol()) && usSymbols.contains(thatUnit.getSymbol()) || siSymbols.contains(thatUnit.getSymbol()) && usSymbols.contains(thisUnit.getSymbol());
        }
        return differentSystems;
    }

    private static boolean isMetricConversion(UnitConverter converter) {
        MetricPrefix[] metricPrefixArray = MetricPrefix.values();
        int n = metricPrefixArray.length;
        int n2 = 0;
        while (n2 < n) {
            MetricPrefix mp = metricPrefixArray[n2];
            if (mp.getConverter().equals(converter)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private static Class<? extends Quantity<?>> dimensionClass(String prefix, String name) throws ClassNotFoundException {
        return Class.forName(String.valueOf(prefix) + name);
    }
}

