/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.astro.internal;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.smarthome.binding.astro.AstroBindingConstants;
import org.eclipse.smarthome.binding.astro.handler.AstroThingHandler;
import org.eclipse.smarthome.binding.astro.handler.MoonHandler;
import org.eclipse.smarthome.binding.astro.handler.SunHandler;
import org.eclipse.smarthome.binding.astro.internal.util.PropertyUtils;
import org.eclipse.smarthome.core.i18n.TimeZoneProvider;
import org.eclipse.smarthome.core.thing.Thing;
import org.eclipse.smarthome.core.thing.ThingTypeUID;
import org.eclipse.smarthome.core.thing.binding.BaseThingHandlerFactory;
import org.eclipse.smarthome.core.thing.binding.ThingHandler;
import org.eclipse.smarthome.core.thing.binding.ThingHandlerFactory;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(configurationPid="binding.astro", service={ThingHandlerFactory.class})
public class AstroHandlerFactory
extends BaseThingHandlerFactory {
    private static final Set<ThingTypeUID> SUPPORTED_THING_TYPES = Stream.concat(SunHandler.SUPPORTED_THING_TYPES.stream(), MoonHandler.SUPPORTED_THING_TYPES.stream()).collect(Collectors.toSet());
    private static final Map<String, AstroThingHandler> ASTRO_THING_HANDLERS = new HashMap<String, AstroThingHandler>();

    public boolean supportsThingType(ThingTypeUID thingTypeUID) {
        return SUPPORTED_THING_TYPES.contains(thingTypeUID);
    }

    protected ThingHandler createHandler(Thing thing) {
        ThingTypeUID thingTypeUID = thing.getThingTypeUID();
        AstroThingHandler thingHandler = null;
        if (thingTypeUID.equals((Object)AstroBindingConstants.THING_TYPE_SUN)) {
            thingHandler = new SunHandler(thing);
        } else if (thingTypeUID.equals((Object)AstroBindingConstants.THING_TYPE_MOON)) {
            thingHandler = new MoonHandler(thing);
        }
        if (thingHandler != null) {
            ASTRO_THING_HANDLERS.put(thing.getUID().toString(), thingHandler);
        }
        return thingHandler;
    }

    public void unregisterHandler(Thing thing) {
        super.unregisterHandler(thing);
        ASTRO_THING_HANDLERS.remove(thing.getUID().toString());
    }

    @Reference
    protected void setTimeZoneProvider(TimeZoneProvider timeZone) {
        PropertyUtils.setTimeZone(timeZone);
    }

    protected void unsetTimeZoneProvider(TimeZoneProvider timeZone) {
        PropertyUtils.unsetTimeZone();
    }

    public static AstroThingHandler getHandler(String thingUid) {
        return ASTRO_THING_HANDLERS.get(thingUid);
    }
}

