/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.io.console.internal.extension;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.smarthome.core.common.registry.Identifiable;
import org.eclipse.smarthome.core.items.ItemRegistry;
import org.eclipse.smarthome.core.items.Metadata;
import org.eclipse.smarthome.core.items.MetadataKey;
import org.eclipse.smarthome.core.items.MetadataPredicates;
import org.eclipse.smarthome.core.items.MetadataRegistry;
import org.eclipse.smarthome.io.console.Console;
import org.eclipse.smarthome.io.console.extensions.AbstractConsoleCommandExtension;
import org.eclipse.smarthome.io.console.extensions.ConsoleCommandExtension;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@NonNullByDefault
@Component(service={ConsoleCommandExtension.class})
public class MetadataConsoleCommandExtension
extends AbstractConsoleCommandExtension {
    private static final String SUBCMD_LIST = "list";
    private static final String SUBCMD_LIST_INTERNAL = "listinternal";
    private static final String SUBCMD_ADD = "add";
    private static final String SUBCMD_REMOVE = "remove";
    @NonNullByDefault(value={})
    private MetadataRegistry metadataRegistry;
    @NonNullByDefault(value={})
    private ItemRegistry itemRegistry;

    public MetadataConsoleCommandExtension() {
        super("metadata", "Access the metadata registry.");
    }

    @Override
    public List<String> getUsages() {
        return Arrays.asList(this.buildCommandUsage("list [<itemName> [<namespace>]]", "lists all available metadata, can be filtered for a specifc item and namespace"), this.buildCommandUsage("listinternal [<itemName> [<namespace>]]", "lists all available INTERNAL metadata, can be filtered for a specifc item and namespace"), this.buildCommandUsage("remove <itemName> [<namespace>]", "removes metadata for the specific item (for all namespaces or for the given namespace only)"), this.buildCommandUsage("add <itemName> <namespace> <value> [\"{key1=value1, key2=value2, ...}\"]", "adds or updates metadata value (and optional config values) for the specific item in the given namespace"));
    }

    @Override
    public void execute(String[] args, Console console) {
        block19: {
            block17: {
                String subCommand;
                if (args.length <= 0) break block17;
                switch (subCommand = args[0]) {
                    case "list": {
                        this.listMetadata(console, args.length > 1 ? args[1] : null, args.length > 2 ? args[2] : null, false);
                        break;
                    }
                    case "listinternal": {
                        this.listMetadata(console, args.length > 1 ? args[1] : null, args.length > 2 ? args[2] : null, true);
                        break;
                    }
                    case "add": {
                        if (args.length < 4) {
                            this.printUsage(console);
                            break;
                        }
                        this.addMetadata(console, args[1], args[2], args[3], args.length > 4 ? args[4] : null);
                        break;
                    }
                    case "remove": {
                        this.removeMetadata(console, args[1], args.length > 2 ? args[2] : null);
                        break;
                    }
                    default: {
                        console.println("Unknown command '" + subCommand + "'");
                        this.printUsage(console);
                        break;
                    }
                }
                break block19;
            }
            this.printUsage(console);
        }
    }

    private void listMetadata(Console console, @Nullable String itemName, @Nullable String namespace, boolean internal) {
        if (itemName == null) {
            this.metadataRegistry.stream().filter(m -> this.isInternal((Metadata)m, internal)).map(Metadata::toString).forEach(console::println);
        } else if (namespace == null) {
            this.metadataRegistry.stream().filter(MetadataPredicates.ofItem((String)itemName)).filter(m -> this.isInternal((Metadata)m, internal)).map(Metadata::toString).forEach(console::println);
        } else {
            Metadata metadata;
            MetadataKey key = new MetadataKey(namespace, itemName);
            if (this.metadataRegistry.isInternalNamespace(namespace) == internal && (metadata = (Metadata)this.metadataRegistry.get((Object)key)) != null) {
                console.println(metadata.toString());
            }
        }
    }

    private boolean isInternal(Metadata metadata, boolean internal) {
        return this.metadataRegistry.isInternalNamespace(metadata.getUID().getNamespace()) == internal;
    }

    private void addMetadata(Console console, String itemName, String namespace, String value, @Nullable String config) {
        if (this.itemRegistry.get((Object)itemName) == null) {
            console.println("Item " + itemName + " does not exist.");
        } else {
            MetadataKey key = new MetadataKey(namespace, itemName);
            Map<String, Object> configMap = this.getConfigMap(config);
            Metadata metadata = new Metadata(key, value, configMap);
            if (this.metadataRegistry.get((Object)key) != null) {
                this.metadataRegistry.update((Identifiable)metadata);
                console.println("Updated: " + metadata.toString());
            } else {
                this.metadataRegistry.add((Identifiable)metadata);
                console.println("Added: " + metadata.toString());
            }
        }
    }

    private @Nullable Map<String, Object> getConfigMap(@Nullable String config) {
        if (config == null) {
            return null;
        }
        String configStr = config;
        if (configStr.startsWith("{") && configStr.endsWith("}")) {
            configStr = configStr.substring(1, configStr.length() - 1);
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        String[] stringArray = configStr.split("\\s*,\\s*");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String part = stringArray[n2];
            String[] subparts = part.split("=", 2);
            if (subparts.length == 2 && subparts[0] != null && subparts[1] != null) {
                map.put(subparts[0].trim(), subparts[1].trim());
            }
            ++n2;
        }
        return map;
    }

    private void removeMetadata(Console console, String itemName, @Nullable String namespace) {
        if (this.itemRegistry.get((Object)itemName) == null) {
            console.println("Warning: Item " + itemName + " does not exist, removing metadata anyway.");
        }
        if (namespace == null) {
            this.metadataRegistry.stream().filter(MetadataPredicates.ofItem((String)itemName)).map(Metadata::getUID).forEach(key -> this.removeMetadata(console, (MetadataKey)key));
        } else {
            MetadataKey key2 = new MetadataKey(namespace, itemName);
            this.removeMetadata(console, key2);
        }
    }

    private void removeMetadata(Console console, MetadataKey key) {
        Metadata metadata = (Metadata)this.metadataRegistry.remove((Object)key);
        if (metadata != null) {
            console.println("Removed: " + metadata.toString());
        } else {
            console.println("Metadata element for " + key + " could not be found.");
        }
    }

    @Reference
    protected void setMetadataRegistry(MetadataRegistry metadataRegistry) {
        this.metadataRegistry = metadataRegistry;
    }

    protected void unsetMetadataRegistry(MetadataRegistry metadataRegistry) {
        this.metadataRegistry = null;
    }

    @Reference
    protected void setItemRegistry(ItemRegistry itemRegistry) {
        this.itemRegistry = itemRegistry;
    }

    protected void unsetItemRegistry(ItemRegistry itemRegistry) {
        this.itemRegistry = null;
    }
}

