/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.meteoblue.internal;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.smarthome.binding.meteoblue.MeteoBlueBindingConstants;
import org.eclipse.smarthome.binding.meteoblue.handler.MeteoBlueBridgeHandler;
import org.eclipse.smarthome.binding.meteoblue.handler.MeteoBlueHandler;
import org.eclipse.smarthome.core.thing.Bridge;
import org.eclipse.smarthome.core.thing.Thing;
import org.eclipse.smarthome.core.thing.ThingTypeUID;
import org.eclipse.smarthome.core.thing.binding.BaseThingHandlerFactory;
import org.eclipse.smarthome.core.thing.binding.ThingHandler;
import org.eclipse.smarthome.core.thing.binding.ThingHandlerFactory;
import org.osgi.service.component.annotations.Component;

@Component(service={ThingHandlerFactory.class}, immediate=true)
public class MeteoBlueHandlerFactory
extends BaseThingHandlerFactory {
    private static final Set<ThingTypeUID> SUPPORTED_THING_TYPES_UIDS = Stream.concat(MeteoBlueBindingConstants.BRIDGE_THING_TYPES_UIDS.stream(), MeteoBlueBindingConstants.SUPPORTED_THING_TYPES_UIDS.stream()).collect(Collectors.toSet());

    public boolean supportsThingType(ThingTypeUID thingTypeUID) {
        return SUPPORTED_THING_TYPES_UIDS.contains(thingTypeUID);
    }

    protected ThingHandler createHandler(Thing thing) {
        ThingTypeUID thingTypeUID = thing.getThingTypeUID();
        if (thingTypeUID.equals((Object)MeteoBlueBindingConstants.THING_TYPE_WEATHER)) {
            return new MeteoBlueHandler(thing);
        }
        if (thingTypeUID.equals((Object)MeteoBlueBindingConstants.THING_TYPE_BRIDGE)) {
            return new MeteoBlueBridgeHandler((Bridge)thing);
        }
        return null;
    }
}

