/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.weatherunderground.handler;

import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.measure.Quantity;
import javax.measure.Unit;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.smarthome.binding.weatherunderground.handler.WeatherUndergroundBridgeHandler;
import org.eclipse.smarthome.binding.weatherunderground.internal.config.WeatherUndergroundConfiguration;
import org.eclipse.smarthome.binding.weatherunderground.internal.json.WeatherUndergroundJsonCurrent;
import org.eclipse.smarthome.binding.weatherunderground.internal.json.WeatherUndergroundJsonData;
import org.eclipse.smarthome.binding.weatherunderground.internal.json.WeatherUndergroundJsonForecast;
import org.eclipse.smarthome.binding.weatherunderground.internal.json.WeatherUndergroundJsonForecastDay;
import org.eclipse.smarthome.core.i18n.LocaleProvider;
import org.eclipse.smarthome.core.i18n.UnitProvider;
import org.eclipse.smarthome.core.library.types.DateTimeType;
import org.eclipse.smarthome.core.library.types.DecimalType;
import org.eclipse.smarthome.core.library.types.QuantityType;
import org.eclipse.smarthome.core.library.types.RawType;
import org.eclipse.smarthome.core.library.types.StringType;
import org.eclipse.smarthome.core.library.unit.ImperialUnits;
import org.eclipse.smarthome.core.library.unit.MetricPrefix;
import org.eclipse.smarthome.core.library.unit.SIUnits;
import org.eclipse.smarthome.core.library.unit.SmartHomeUnits;
import org.eclipse.smarthome.core.thing.Bridge;
import org.eclipse.smarthome.core.thing.Channel;
import org.eclipse.smarthome.core.thing.ChannelUID;
import org.eclipse.smarthome.core.thing.Thing;
import org.eclipse.smarthome.core.thing.ThingStatus;
import org.eclipse.smarthome.core.thing.ThingStatusDetail;
import org.eclipse.smarthome.core.thing.ThingStatusInfo;
import org.eclipse.smarthome.core.thing.binding.BaseThingHandler;
import org.eclipse.smarthome.core.thing.binding.ThingHandler;
import org.eclipse.smarthome.core.types.Command;
import org.eclipse.smarthome.core.types.RefreshType;
import org.eclipse.smarthome.core.types.State;
import org.eclipse.smarthome.core.types.UnDefType;
import org.eclipse.smarthome.io.net.http.HttpUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
public class WeatherUndergroundHandler
extends BaseThingHandler {
    private final Logger logger = LoggerFactory.getLogger(WeatherUndergroundHandler.class);
    private static final int DEFAULT_REFRESH_PERIOD = 30;
    private static final String URL_QUERY = "http://api.wunderground.com/api/%APIKEY%/%FEATURES%/%SETTINGS%/q/%QUERY%.json";
    private static final String FEATURE_CONDITIONS = "conditions";
    private static final String FEATURE_FORECAST10DAY = "forecast10day";
    private static final String FEATURE_GEOLOOKUP = "geolookup";
    private static final Set<String> USUAL_FEATURES = Stream.of("conditions", "forecast10day").collect(Collectors.toSet());
    private static final Map<String, String> LANG_ISO_TO_WU_CODES = new HashMap<String, String>();
    private static final Map<String, String> LANG_COUNTRY_TO_WU_CODES;
    private final LocaleProvider localeProvider;
    private final UnitProvider unitProvider;
    private final Gson gson;
    private final Map<String, Integer> forecastMap;
    private @Nullable ScheduledFuture<?> refreshJob;
    private @Nullable WeatherUndergroundJsonData weatherData;
    private @Nullable WeatherUndergroundBridgeHandler bridgeHandler;

    static {
        LANG_ISO_TO_WU_CODES.put("AF", "AF");
        LANG_ISO_TO_WU_CODES.put("SQ", "AL");
        LANG_ISO_TO_WU_CODES.put("AR", "AR");
        LANG_ISO_TO_WU_CODES.put("HY", "HY");
        LANG_ISO_TO_WU_CODES.put("AZ", "AZ");
        LANG_ISO_TO_WU_CODES.put("EU", "EU");
        LANG_ISO_TO_WU_CODES.put("BE", "BY");
        LANG_ISO_TO_WU_CODES.put("BG", "BU");
        LANG_ISO_TO_WU_CODES.put("MY", "MY");
        LANG_ISO_TO_WU_CODES.put("CA", "CA");
        LANG_ISO_TO_WU_CODES.put("ZH", "TW");
        LANG_ISO_TO_WU_CODES.put("HR", "CR");
        LANG_ISO_TO_WU_CODES.put("CS", "CZ");
        LANG_ISO_TO_WU_CODES.put("DA", "DK");
        LANG_ISO_TO_WU_CODES.put("DV", "DV");
        LANG_ISO_TO_WU_CODES.put("NL", "NL");
        LANG_ISO_TO_WU_CODES.put("EN", "EN");
        LANG_ISO_TO_WU_CODES.put("EO", "EO");
        LANG_ISO_TO_WU_CODES.put("ET", "ET");
        LANG_ISO_TO_WU_CODES.put("FA", "FA");
        LANG_ISO_TO_WU_CODES.put("FI", "FI");
        LANG_ISO_TO_WU_CODES.put("FR", "FR");
        LANG_ISO_TO_WU_CODES.put("GL", "GZ");
        LANG_ISO_TO_WU_CODES.put("DE", "DL");
        LANG_ISO_TO_WU_CODES.put("KA", "KA");
        LANG_ISO_TO_WU_CODES.put("EL", "GR");
        LANG_ISO_TO_WU_CODES.put("GU", "GU");
        LANG_ISO_TO_WU_CODES.put("HT", "HT");
        LANG_ISO_TO_WU_CODES.put("HE", "IL");
        LANG_ISO_TO_WU_CODES.put("HI", "HI");
        LANG_ISO_TO_WU_CODES.put("HU", "HU");
        LANG_ISO_TO_WU_CODES.put("IS", "IS");
        LANG_ISO_TO_WU_CODES.put("IO", "IO");
        LANG_ISO_TO_WU_CODES.put("ID", "ID");
        LANG_ISO_TO_WU_CODES.put("GA", "IR");
        LANG_ISO_TO_WU_CODES.put("IT", "IT");
        LANG_ISO_TO_WU_CODES.put("JA", "JP");
        LANG_ISO_TO_WU_CODES.put("JV", "JW");
        LANG_ISO_TO_WU_CODES.put("KM", "KM");
        LANG_ISO_TO_WU_CODES.put("KO", "KR");
        LANG_ISO_TO_WU_CODES.put("KU", "KU");
        LANG_ISO_TO_WU_CODES.put("LA", "LA");
        LANG_ISO_TO_WU_CODES.put("LV", "LV");
        LANG_ISO_TO_WU_CODES.put("LT", "LT");
        LANG_ISO_TO_WU_CODES.put("MK", "MK");
        LANG_ISO_TO_WU_CODES.put("MT", "MT");
        LANG_ISO_TO_WU_CODES.put("MI", "MI");
        LANG_ISO_TO_WU_CODES.put("MR", "MR");
        LANG_ISO_TO_WU_CODES.put("MN", "MN");
        LANG_ISO_TO_WU_CODES.put("NO", "NO");
        LANG_ISO_TO_WU_CODES.put("OC", "OC");
        LANG_ISO_TO_WU_CODES.put("PS", "PS");
        LANG_ISO_TO_WU_CODES.put("PL", "PL");
        LANG_ISO_TO_WU_CODES.put("PT", "BR");
        LANG_ISO_TO_WU_CODES.put("PA", "PA");
        LANG_ISO_TO_WU_CODES.put("RO", "RO");
        LANG_ISO_TO_WU_CODES.put("RU", "RU");
        LANG_ISO_TO_WU_CODES.put("SR", "SR");
        LANG_ISO_TO_WU_CODES.put("SK", "SK");
        LANG_ISO_TO_WU_CODES.put("SL", "SL");
        LANG_ISO_TO_WU_CODES.put("ES", "SP");
        LANG_ISO_TO_WU_CODES.put("SW", "SI");
        LANG_ISO_TO_WU_CODES.put("SV", "SW");
        LANG_ISO_TO_WU_CODES.put("TL", "TL");
        LANG_ISO_TO_WU_CODES.put("TT", "TT");
        LANG_ISO_TO_WU_CODES.put("TH", "TH");
        LANG_ISO_TO_WU_CODES.put("TR", "TR");
        LANG_ISO_TO_WU_CODES.put("TK", "TK");
        LANG_ISO_TO_WU_CODES.put("UK", "UA");
        LANG_ISO_TO_WU_CODES.put("UZ", "UZ");
        LANG_ISO_TO_WU_CODES.put("VI", "VU");
        LANG_ISO_TO_WU_CODES.put("CY", "CY");
        LANG_ISO_TO_WU_CODES.put("WO", "SN");
        LANG_ISO_TO_WU_CODES.put("YI", "YI");
        LANG_COUNTRY_TO_WU_CODES = new HashMap<String, String>();
        LANG_COUNTRY_TO_WU_CODES.put("en-GB", "LI");
        LANG_COUNTRY_TO_WU_CODES.put("fr-CA", "FC");
    }

    public WeatherUndergroundHandler(Thing thing, LocaleProvider localeProvider, UnitProvider unitProvider) {
        super(thing);
        this.localeProvider = localeProvider;
        this.unitProvider = unitProvider;
        this.gson = new Gson();
        this.forecastMap = this.initForecastDayMap();
    }

    public void initialize() {
        this.logger.debug("Initializing WeatherUnderground handler for thing {}", (Object)this.getThing().getUID());
        Bridge bridge = this.getBridge();
        if (bridge == null) {
            this.initializeThingHandler(null, null);
        } else {
            this.initializeThingHandler((ThingHandler)bridge.getHandler(), bridge.getStatus());
        }
    }

    public void bridgeStatusChanged(ThingStatusInfo bridgeStatusInfo) {
        this.logger.debug("bridgeStatusChanged {}", (Object)bridgeStatusInfo);
        Bridge bridge = this.getBridge();
        if (bridge == null) {
            this.initializeThingHandler(null, bridgeStatusInfo.getStatus());
        } else {
            this.initializeThingHandler((ThingHandler)bridge.getHandler(), bridgeStatusInfo.getStatus());
        }
    }

    private void initializeThingHandler(@Nullable ThingHandler bridgeHandler, @Nullable ThingStatus bridgeStatus) {
        this.logger.debug("initializeThingHandler {}", (Object)this.getThing().getUID());
        if (bridgeHandler != null && bridgeStatus != null) {
            if (bridgeStatus == ThingStatus.ONLINE) {
                String lang;
                this.bridgeHandler = (WeatherUndergroundBridgeHandler)bridgeHandler;
                WeatherUndergroundConfiguration config = (WeatherUndergroundConfiguration)this.getConfigAs(WeatherUndergroundConfiguration.class);
                this.logger.debug("config location = {}", (Object)config.location);
                this.logger.debug("config language = {}", (Object)config.language);
                this.logger.debug("config refresh = {}", (Object)config.refresh);
                boolean validConfig = true;
                String errors = "";
                String statusDescr = null;
                if (StringUtils.trimToNull((String)config.location) == null) {
                    errors = String.valueOf(errors) + " Parameter 'location' must be configured.";
                    statusDescr = "@text/offline.conf-error-missing-location";
                    validConfig = false;
                }
                if (config.language != null && (lang = StringUtils.trimToEmpty((String)config.language)).length() != 2) {
                    errors = String.valueOf(errors) + " Parameter 'language' must be 2 letters.";
                    statusDescr = "@text/offline.conf-error-syntax-language";
                    validConfig = false;
                }
                if (config.refresh != null && config.refresh < 5) {
                    errors = String.valueOf(errors) + " Parameter 'refresh' must be at least 5 minutes.";
                    statusDescr = "@text/offline.conf-error-min-refresh";
                    validConfig = false;
                }
                errors = errors.trim();
                if (validConfig) {
                    this.updateStatus(ThingStatus.ONLINE);
                    this.startAutomaticRefresh();
                } else {
                    this.logger.debug("Setting thing '{}' to OFFLINE: {}", (Object)this.getThing().getUID(), (Object)errors);
                    this.updateStatus(ThingStatus.OFFLINE, ThingStatusDetail.CONFIGURATION_ERROR, statusDescr);
                }
            } else {
                this.updateStatus(ThingStatus.OFFLINE, ThingStatusDetail.BRIDGE_OFFLINE);
            }
        } else {
            this.updateStatus(ThingStatus.OFFLINE);
        }
    }

    private void startAutomaticRefresh() {
        if (this.refreshJob == null || this.refreshJob.isCancelled()) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    try {
                        WeatherUndergroundHandler.this.updateWeatherData(USUAL_FEATURES);
                        for (Channel channel : WeatherUndergroundHandler.this.getThing().getChannels()) {
                            WeatherUndergroundHandler.this.updateChannel(channel.getUID().getId());
                        }
                    }
                    catch (Exception e) {
                        WeatherUndergroundHandler.this.logger.debug("Exception occurred during execution: {}", (Object)e.getMessage(), (Object)e);
                    }
                }
            };
            WeatherUndergroundConfiguration config = (WeatherUndergroundConfiguration)this.getConfigAs(WeatherUndergroundConfiguration.class);
            int period = config.refresh != null ? config.refresh : 30;
            this.refreshJob = this.scheduler.scheduleWithFixedDelay(runnable, 0L, period, TimeUnit.MINUTES);
        }
    }

    public void dispose() {
        this.logger.debug("Disposing WeatherUnderground handler.");
        if (this.refreshJob != null && !this.refreshJob.isCancelled()) {
            this.refreshJob.cancel(true);
            this.refreshJob = null;
        }
    }

    public void handleCommand(ChannelUID channelUID, Command command) {
        if (command instanceof RefreshType) {
            this.updateChannel(channelUID.getId());
        } else {
            this.logger.debug("The Weather Underground binding is a read-only binding and cannot handle command {}", (Object)command);
        }
    }

    private void updateChannel(String channelId) {
        if (this.isLinked(channelId)) {
            Object state = null;
            if (this.weatherData != null) {
                if (channelId.startsWith("current")) {
                    state = this.updateCurrentObservationChannel(channelId, this.weatherData.getCurrent());
                } else if (channelId.startsWith("forecast")) {
                    state = this.updateForecastChannel(channelId, this.weatherData.getForecast());
                }
            }
            this.logger.debug("Update channel {} with state {}", (Object)channelId, (Object)(state == null ? "null" : state.toString()));
            if (state != null) {
                this.updateState(channelId, (State)state);
            } else {
                this.updateState(channelId, (State)UnDefType.NULL);
            }
        }
    }

    private @Nullable State updateCurrentObservationChannel(String channelId, WeatherUndergroundJsonCurrent current) {
        String channelTypeId;
        switch (channelTypeId = this.getChannelTypeId(channelId)) {
            case "location": {
                return this.undefOrState(current.getLocation(), (State)new StringType(current.getLocation()));
            }
            case "stationId": {
                return this.undefOrState(current.getStationId(), (State)new StringType(current.getStationId()));
            }
            case "observationTime": {
                return this.undefOrState(current.getObservationTime(), (State)new DateTimeType(current.getObservationTime()));
            }
            case "conditions": {
                return this.undefOrState(current.getConditions(), (State)new StringType(current.getConditions()));
            }
            case "temperature": {
                WUQuantity quantity = this.getTemperature(current.getTemperatureC(), current.getTemperatureF());
                return this.undefOrQuantity(quantity);
            }
            case "relativeHumidity": {
                return this.undefOrState(current.getRelativeHumidity(), (State)new QuantityType((Number)current.getRelativeHumidity(), SmartHomeUnits.PERCENT));
            }
            case "windDirection": {
                return this.undefOrState(current.getWindDirection(), (State)new StringType(current.getWindDirection()));
            }
            case "windDirectionDegrees": {
                return this.undefOrState(current.getWindDirectionDegrees(), (State)new QuantityType((Number)current.getWindDirectionDegrees(), SmartHomeUnits.DEGREE_ANGLE));
            }
            case "windSpeed": {
                WUQuantity quantity = this.getSpeed(current.getWindSpeedKmh(), current.getWindSpeedMph());
                return this.undefOrQuantity(quantity);
            }
            case "windGust": {
                WUQuantity quantity = this.getSpeed(current.getWindGustKmh(), current.getWindGustMph());
                return this.undefOrQuantity(quantity);
            }
            case "pressure": {
                WUQuantity quantity = this.getPressure(current.getPressureHPa(), current.getPressureInHg());
                return this.undefOrQuantity(quantity);
            }
            case "pressureTrend": {
                return this.undefOrState(current.getPressureTrend(), (State)new StringType(current.getPressureTrend()));
            }
            case "dewPoint": {
                WUQuantity quantity = this.getTemperature(current.getDewPointC(), current.getDewPointF());
                return this.undefOrQuantity(quantity);
            }
            case "heatIndex": {
                WUQuantity quantity = this.getTemperature(current.getHeatIndexC(), current.getHeatIndexF());
                return this.undefOrQuantity(quantity);
            }
            case "windChill": {
                WUQuantity quantity = this.getTemperature(current.getWindChillC(), current.getWindChillF());
                return this.undefOrQuantity(quantity);
            }
            case "feelingTemperature": {
                WUQuantity quantity = this.getTemperature(current.getFeelingTemperatureC(), current.getFeelingTemperatureF());
                return this.undefOrQuantity(quantity);
            }
            case "visibility": {
                WUQuantity quantity = this.getWUQuantity(MetricPrefix.KILO((Unit)SIUnits.METRE), ImperialUnits.MILE, current.getVisibilityKm(), current.getVisibilityMi());
                return this.undefOrQuantity(quantity);
            }
            case "solarRadiation": {
                return this.undefOrQuantity(new WUQuantity(current.getSolarRadiation(), SmartHomeUnits.IRRADIANCE));
            }
            case "UVIndex": {
                return this.undefOrDecimal(current.getUVIndex());
            }
            case "precipitationDay": {
                WUQuantity quantity = this.getPrecipitation(current.getPrecipitationDayMm(), current.getPrecipitationDayIn());
                return this.undefOrQuantity(quantity);
            }
            case "precipitationHour": {
                WUQuantity quantity = this.getPrecipitation(current.getPrecipitationHourMm(), current.getPrecipitationHourIn());
                return this.undefOrQuantity(quantity);
            }
            case "iconKey": {
                return this.undefOrState(current.getIconKey(), (State)new StringType(current.getIconKey()));
            }
            case "icon": {
                RawType icon = HttpUtil.downloadImage((String)current.getIcon().toExternalForm());
                if (icon == null) {
                    this.logger.debug("Failed to download the content of URL {}", (Object)current.getIcon().toExternalForm());
                    return null;
                }
                return icon;
            }
        }
        return null;
    }

    private @Nullable State updateForecastChannel(String channelId, WeatherUndergroundJsonForecast forecast) {
        String channelTypeId;
        int day = this.getDay(channelId);
        WeatherUndergroundJsonForecastDay dayForecast = forecast.getSimpleForecast(day);
        switch (channelTypeId = this.getChannelTypeId(channelId)) {
            case "forecastTime": {
                return this.undefOrState(dayForecast.getForecastTime(), (State)new DateTimeType(dayForecast.getForecastTime()));
            }
            case "conditions": {
                return this.undefOrState(dayForecast.getConditions(), (State)new StringType(dayForecast.getConditions()));
            }
            case "minTemperature": {
                WUQuantity quantity = this.getTemperature(dayForecast.getMinTemperatureC(), dayForecast.getMinTemperatureF());
                return this.undefOrQuantity(quantity);
            }
            case "maxTemperature": {
                WUQuantity quantity = this.getTemperature(dayForecast.getMaxTemperatureC(), dayForecast.getMaxTemperatureF());
                return this.undefOrQuantity(quantity);
            }
            case "relativeHumidity": {
                return this.undefOrState(dayForecast.getRelativeHumidity(), (State)new QuantityType((Number)dayForecast.getRelativeHumidity(), SmartHomeUnits.PERCENT));
            }
            case "probaPrecipitation": {
                return this.undefOrState(dayForecast.getProbaPrecipitation(), (State)new QuantityType((Number)dayForecast.getProbaPrecipitation(), SmartHomeUnits.PERCENT));
            }
            case "precipitationDay": {
                WUQuantity quantity = this.getPrecipitation(dayForecast.getPrecipitationDayMm(), dayForecast.getPrecipitationDayIn());
                return this.undefOrQuantity(quantity);
            }
            case "snow": {
                WUQuantity quantity = this.getWUQuantity(MetricPrefix.CENTI((Unit)SIUnits.METRE), ImperialUnits.INCH, dayForecast.getSnowCm(), dayForecast.getSnowIn());
                return this.undefOrQuantity(quantity);
            }
            case "maxWindDirection": {
                return this.undefOrState(dayForecast.getMaxWindDirection(), (State)new StringType(dayForecast.getMaxWindDirection()));
            }
            case "maxWindDirectionDegrees": {
                return this.undefOrState(dayForecast.getMaxWindDirectionDegrees(), (State)new QuantityType((Number)dayForecast.getMaxWindDirectionDegrees(), SmartHomeUnits.DEGREE_ANGLE));
            }
            case "maxWindSpeed": {
                WUQuantity quantity = this.getSpeed(dayForecast.getMaxWindSpeedKmh(), dayForecast.getMaxWindSpeedMph());
                return this.undefOrQuantity(quantity);
            }
            case "averageWindDirection": {
                return this.undefOrState(dayForecast.getAverageWindDirection(), (State)new StringType(dayForecast.getAverageWindDirection()));
            }
            case "averageWindDirectionDegrees": {
                return this.undefOrState(dayForecast.getAverageWindDirectionDegrees(), (State)new QuantityType((Number)dayForecast.getAverageWindDirectionDegrees(), SmartHomeUnits.DEGREE_ANGLE));
            }
            case "averageWindSpeed": {
                WUQuantity quantity = this.getSpeed(dayForecast.getAverageWindSpeedKmh(), dayForecast.getAverageWindSpeedMph());
                return this.undefOrQuantity(quantity);
            }
            case "iconKey": {
                return this.undefOrState(dayForecast.getIconKey(), (State)new StringType(dayForecast.getIconKey()));
            }
            case "icon": {
                RawType icon = HttpUtil.downloadImage((String)dayForecast.getIcon().toExternalForm());
                if (icon == null) {
                    this.logger.debug("Failed to download the content of URL {}", (Object)dayForecast.getIcon().toExternalForm());
                    return null;
                }
                return icon;
            }
        }
        return null;
    }

    private @Nullable State undefOrState(@Nullable Object value, State state) {
        return value == null ? null : state;
    }

    private <T extends Quantity<T>> @Nullable State undefOrQuantity(WUQuantity quantity) {
        return quantity.value == null ? null : new QuantityType((Number)quantity.value, quantity.unit);
    }

    private @Nullable State undefOrDecimal(@Nullable Number value) {
        return value == null ? null : new DecimalType(value.doubleValue());
    }

    private int getDay(String channelId) {
        String channel = channelId.split("#")[0];
        return this.forecastMap.get(channel);
    }

    private String getChannelTypeId(String channelId) {
        return channelId.substring(channelId.indexOf("#") + 1);
    }

    private Map<String, Integer> initForecastDayMap() {
        HashMap<String, Integer> forecastMap = new HashMap<String, Integer>();
        forecastMap.put("forecastToday", 1);
        forecastMap.put("forecastTomorrow", 2);
        forecastMap.put("forecastDay2", 3);
        forecastMap.put("forecastDay3", 4);
        forecastMap.put("forecastDay4", 5);
        forecastMap.put("forecastDay5", 6);
        forecastMap.put("forecastDay6", 7);
        forecastMap.put("forecastDay7", 8);
        forecastMap.put("forecastDay8", 9);
        forecastMap.put("forecastDay9", 10);
        return forecastMap;
    }

    private boolean updateWeatherData(Set<String> features) {
        WeatherUndergroundJsonData result = null;
        boolean resultOk = false;
        String error = null;
        String errorDetail = null;
        String statusDescr = null;
        try {
            WeatherUndergroundConfiguration config = (WeatherUndergroundConfiguration)this.getConfigAs(WeatherUndergroundConfiguration.class);
            String urlStr = URL_QUERY.replace("%APIKEY%", StringUtils.trimToEmpty((String)this.bridgeHandler.getApikey()));
            urlStr = urlStr.replace("%FEATURES%", String.join((CharSequence)"/", features));
            String lang = StringUtils.trimToEmpty((String)config.language);
            if (lang.isEmpty()) {
                lang = WeatherUndergroundHandler.getCodeFromLanguage(this.localeProvider.getLocale());
                this.logger.debug("Use language deduced from system locale {}: {}", (Object)this.localeProvider.getLocale().getLanguage(), (Object)lang);
            }
            urlStr = lang.isEmpty() ? urlStr.replace("%SETTINGS%", "") : urlStr.replace("%SETTINGS%", "lang:" + lang.toUpperCase());
            urlStr = urlStr.replace("%QUERY%", StringUtils.trimToEmpty((String)config.location));
            this.logger.debug("URL = {}", (Object)urlStr);
            String response = null;
            try {
                response = HttpUtil.executeUrl((String)"GET", (String)urlStr, (int)30000);
                this.logger.debug("weatherData = {}", (Object)response);
            }
            catch (IllegalArgumentException e) {
                error = "Error creating URI with location parameter: '" + StringUtils.trimToEmpty((String)config.location) + "'";
                errorDetail = e.getMessage();
                statusDescr = "@text/offline.uri-error";
            }
            result = (WeatherUndergroundJsonData)this.gson.fromJson(response, WeatherUndergroundJsonData.class);
            if (result.getResponse() == null) {
                errorDetail = "missing response sub-object";
            } else if (result.getResponse().getErrorDescription() != null) {
                if ("keynotfound".equals(result.getResponse().getErrorType())) {
                    error = "API key has to be fixed";
                    statusDescr = "@text/offline.comm-error-invalid-api-key";
                }
                errorDetail = result.getResponse().getErrorDescription();
            } else {
                resultOk = true;
                for (String feature : features) {
                    if (feature.equals(FEATURE_CONDITIONS) && result.getCurrent() == null) {
                        resultOk = false;
                        errorDetail = "missing current_observation sub-object";
                        continue;
                    }
                    if (feature.equals(FEATURE_FORECAST10DAY) && result.getForecast() == null) {
                        resultOk = false;
                        errorDetail = "missing forecast sub-object";
                        continue;
                    }
                    if (!feature.equals(FEATURE_GEOLOOKUP) || result.getLocation() != null) continue;
                    resultOk = false;
                    errorDetail = "missing location sub-object";
                }
            }
            if (!resultOk && error == null) {
                error = "Error in Weather Underground response";
                statusDescr = "@text/offline.comm-error-response";
            }
        }
        catch (IOException e) {
            error = "Error running Weather Underground request";
            errorDetail = e.getMessage();
            statusDescr = "@text/offline.comm-error-running-request";
        }
        catch (JsonSyntaxException e) {
            error = "Error parsing Weather Underground response";
            errorDetail = e.getMessage();
            statusDescr = "@text/offline.comm-error-parsing-response";
        }
        if (resultOk) {
            this.updateStatus(ThingStatus.ONLINE);
            this.weatherData = result;
        } else {
            this.logger.debug("Setting thing '{}' to OFFLINE: Error '{}': {}", new Object[]{this.getThing().getUID(), error, errorDetail});
            this.updateStatus(ThingStatus.OFFLINE, ThingStatusDetail.OFFLINE.COMMUNICATION_ERROR, statusDescr);
            this.weatherData = null;
        }
        return resultOk;
    }

    public static String getCodeFromLanguage(Locale locale) {
        String key = String.valueOf(locale.getLanguage()) + "-" + locale.getCountry();
        String language = StringUtils.trimToEmpty((String)LANG_COUNTRY_TO_WU_CODES.get(key));
        if (language.isEmpty()) {
            language = StringUtils.trimToEmpty((String)LANG_ISO_TO_WU_CODES.get(locale.getLanguage().toUpperCase()));
        }
        return language;
    }

    private WUQuantity getTemperature(BigDecimal siValue, BigDecimal imperialValue) {
        return this.getWUQuantity(SIUnits.CELSIUS, ImperialUnits.FAHRENHEIT, siValue, imperialValue);
    }

    private WUQuantity getSpeed(BigDecimal siValue, BigDecimal imperialValue) {
        return this.getWUQuantity(SIUnits.KILOMETRE_PER_HOUR, ImperialUnits.MILES_PER_HOUR, siValue, imperialValue);
    }

    private WUQuantity getPressure(BigDecimal siValue, BigDecimal imperialValue) {
        return this.getWUQuantity(MetricPrefix.HECTO((Unit)SIUnits.PASCAL), ImperialUnits.INCH_OF_MERCURY, siValue, imperialValue);
    }

    private WUQuantity getPrecipitation(BigDecimal siValue, BigDecimal imperialValue) {
        return this.getWUQuantity(MetricPrefix.MILLI((Unit)SIUnits.METRE), ImperialUnits.INCH, siValue, imperialValue);
    }

    private <T extends Quantity<T>> WUQuantity getWUQuantity(Unit<T> siUnit, Unit<T> imperialUnit, BigDecimal siValue, BigDecimal imperialValue) {
        boolean isSI = this.unitProvider.getMeasurementSystem().equals(SIUnits.getInstance());
        return new WUQuantity(isSI ? siValue : imperialValue, isSI ? siUnit : imperialUnit);
    }

    private class WUQuantity {
        private final Unit<?> unit;
        private final BigDecimal value;

        private WUQuantity(BigDecimal value, Unit<?> unit) {
            this.value = value;
            this.unit = unit;
        }
    }
}

