/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.voice.text;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.ResourceBundle;
import org.eclipse.smarthome.core.voice.text.ASTNode;
import org.eclipse.smarthome.core.voice.text.Expression;
import org.eclipse.smarthome.core.voice.text.TokenList;

public final class ExpressionCardinality
extends Expression {
    private Expression subExpression;
    private boolean atLeastOne = false;
    private boolean atMostOne = true;

    public ExpressionCardinality(Expression subExpression, boolean atLeastOne, boolean atMostOne) {
        this.subExpression = subExpression;
        this.atLeastOne = atLeastOne;
        this.atMostOne = atMostOne;
    }

    @Override
    ASTNode parse(ResourceBundle language, TokenList tokenList) {
        ASTNode cr;
        TokenList list = tokenList;
        ASTNode node = new ASTNode();
        ArrayList<ASTNode> nodes = new ArrayList<ASTNode>();
        ArrayList<Object> values = new ArrayList<Object>();
        while ((cr = this.subExpression.parse(language, list)).isSuccess()) {
            nodes.add(cr);
            values.add(cr.getValue());
            list = cr.getRemainingTokens();
            if (this.atMostOne) break;
        }
        if (!this.atLeastOne || nodes.size() != 0) {
            node.setChildren(nodes.toArray(new ASTNode[0]));
            node.setRemainingTokens(list);
            node.setSuccess(true);
            node.setValue(this.atMostOne ? (values.size() > 0 ? values.get(0) : null) : values.toArray());
            this.generateValue(node);
        }
        return node;
    }

    @Override
    List<Expression> getChildExpressions() {
        return Collections.unmodifiableList(Arrays.asList(this.subExpression));
    }

    @Override
    boolean collectFirsts(ResourceBundle language, HashSet<String> firsts) {
        return this.subExpression.collectFirsts(language, firsts) || this.atLeastOne;
    }

    public String toString() {
        return "cardinal(" + this.atLeastOne + ", " + this.atMostOne + "' " + this.subExpression.toString() + ")";
    }

    public Expression getSubExpression() {
        return this.subExpression;
    }

    public boolean isAtLeastOne() {
        return this.atLeastOne;
    }

    public boolean isAtMostOne() {
        return this.atMostOne;
    }
}

