/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.automation.module.core.handler;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.smarthome.automation.Action;
import org.eclipse.smarthome.automation.Module;
import org.eclipse.smarthome.automation.annotation.ActionInput;
import org.eclipse.smarthome.automation.handler.ActionHandler;
import org.eclipse.smarthome.automation.handler.BaseModuleHandler;
import org.eclipse.smarthome.automation.type.ActionType;
import org.eclipse.smarthome.automation.type.Input;
import org.eclipse.smarthome.automation.type.Output;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnnotationActionHandler
extends BaseModuleHandler<Action>
implements ActionHandler {
    private static final String MODULE_RESULT = "result";
    private final Logger logger = LoggerFactory.getLogger(AnnotationActionHandler.class);
    private final Method method;
    private final ActionType moduleType;
    private final Object actionProvider;

    public AnnotationActionHandler(Action module, ActionType mt, Method method, Object actionProvider) {
        super((Module)module);
        this.method = method;
        this.moduleType = mt;
        this.actionProvider = actionProvider;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Map<String, Object> execute(Map<String, Object> context) {
        HashMap<String, Object> output = new HashMap<String, Object>();
        Annotation[][] annotations = this.method.getParameterAnnotations();
        ArrayList<Object> args = new ArrayList<Object>();
        int i = 0;
        while (i < annotations.length) {
            Annotation[] annotationsOnParam = annotations[i];
            if (annotationsOnParam != null && annotationsOnParam.length == 1) {
                if (annotationsOnParam[0] instanceof ActionInput) {
                    ActionInput inputAnnotation = (ActionInput)annotationsOnParam[0];
                    if (!this.hasInput(this.moduleType, inputAnnotation.name())) {
                        this.logger.error("Annotated method defines input '{}' but the module type '{}' does not specify an input with this name.", (Object)inputAnnotation.name(), (Object)this.moduleType);
                        return output;
                    }
                    args.add(i, context.get(inputAnnotation.name()));
                }
            } else {
                args.add(i, context.get("p" + i));
            }
            ++i;
        }
        Object result = null;
        try {
            result = this.method.invoke(this.actionProvider, args.toArray());
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            this.logger.error("Could not call method '{}' from module type '{}'.", new Object[]{this.method, this.moduleType.getUID(), e});
        }
        if (result == null) return output;
        if (result instanceof Map) {
            try {
                Map resultMap = (Map)result;
                Iterator iterator = resultMap.entrySet().iterator();
                while (true) {
                    if (!iterator.hasNext()) {
                        return output;
                    }
                    Map.Entry entry = iterator.next();
                    if (!this.hasOutput(this.moduleType, (String)entry.getKey())) continue;
                    output.put((String)entry.getKey(), entry.getValue());
                }
            }
            catch (ClassCastException ex) {
                this.logger.error("The return type of action method '{}' from module type '{}' should be Map<String, Object>, because {}", new Object[]{this.method, this.moduleType.getUID(), ex.getMessage()});
                return output;
            }
        }
        if (result instanceof Boolean) {
            output.put(MODULE_RESULT, (boolean)((Boolean)result));
            return output;
        }
        if (result instanceof String) {
            output.put(MODULE_RESULT, result);
            return output;
        }
        if (result instanceof Integer) {
            output.put(MODULE_RESULT, result);
            return output;
        }
        if (result instanceof Double) {
            output.put(MODULE_RESULT, (double)((Double)result));
            return output;
        }
        if (result instanceof Float) {
            output.put(MODULE_RESULT, Float.valueOf(((Float)result).floatValue()));
            return output;
        }
        this.logger.warn("Non compatible return type '{}' on action method.", result.getClass());
        return output;
    }

    private boolean hasInput(ActionType moduleType, String in) {
        for (Input i : moduleType.getInputs()) {
            if (!i.getName().equals(in)) continue;
            return true;
        }
        return false;
    }

    private boolean hasOutput(ActionType moduleType, String out) {
        for (Output o : moduleType.getOutputs()) {
            if (!o.getName().equals(out)) continue;
            return true;
        }
        return false;
    }
}

