/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.lifx.internal;

import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.smarthome.binding.lifx.LifxBindingConstants;
import org.eclipse.smarthome.binding.lifx.handler.LifxLightHandler;
import org.eclipse.smarthome.binding.lifx.internal.LifxChannelFactory;
import org.eclipse.smarthome.core.thing.Thing;
import org.eclipse.smarthome.core.thing.ThingTypeUID;
import org.eclipse.smarthome.core.thing.binding.BaseThingHandlerFactory;
import org.eclipse.smarthome.core.thing.binding.ThingHandler;
import org.eclipse.smarthome.core.thing.binding.ThingHandlerFactory;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@NonNullByDefault
@Component(service={ThingHandlerFactory.class}, configurationPid="binding.lifx")
public class LifxHandlerFactory
extends BaseThingHandlerFactory {
    @NonNullByDefault(value={})
    private LifxChannelFactory channelFactory;

    public boolean supportsThingType(ThingTypeUID thingTypeUID) {
        return LifxBindingConstants.SUPPORTED_THING_TYPES.contains(thingTypeUID);
    }

    protected void activate(ComponentContext componentContext) {
        super.activate(componentContext);
    }

    protected @Nullable ThingHandler createHandler(Thing thing) {
        if (this.supportsThingType(thing.getThingTypeUID())) {
            return new LifxLightHandler(thing, this.channelFactory);
        }
        return null;
    }

    protected void deactivate(ComponentContext componentContext) {
        super.deactivate(componentContext);
    }

    @Reference
    protected void setChannelFactory(LifxChannelFactory channelFactory) {
        this.channelFactory = channelFactory;
    }

    protected void unsetChannelFactory(LifxChannelFactory channelFactory) {
        this.channelFactory = null;
    }
}

