/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.lifx.internal.protocol;

import java.nio.ByteBuffer;
import org.eclipse.smarthome.binding.lifx.internal.fields.Field;
import org.eclipse.smarthome.binding.lifx.internal.fields.UInt16Field;
import org.eclipse.smarthome.binding.lifx.internal.protocol.Packet;
import org.eclipse.smarthome.binding.lifx.internal.protocol.PowerState;

public class SetPowerRequest
extends Packet {
    public static final int TYPE = 21;
    public static final Field<Integer> FIELD_STATE = new UInt16Field();
    private PowerState state;

    public PowerState getState() {
        return this.state;
    }

    public SetPowerRequest() {
        this.state = PowerState.OFF;
        this.setTagged(false);
        this.setAddressable(true);
        this.setResponseRequired(true);
    }

    public SetPowerRequest(PowerState state) {
        this.state = state;
        this.setTagged(false);
        this.setAddressable(true);
        this.setResponseRequired(true);
    }

    @Override
    public int packetType() {
        return 21;
    }

    @Override
    protected int packetLength() {
        return 2;
    }

    @Override
    protected void parsePacket(ByteBuffer bytes) {
        this.state = PowerState.fromValue(FIELD_STATE.value(bytes));
    }

    @Override
    protected ByteBuffer packetBytes() {
        return ByteBuffer.allocate(2).put(FIELD_STATE.bytes(this.state.getValue()));
    }

    @Override
    public int[] expectedResponses() {
        return new int[]{22};
    }
}

