/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.lifx.internal.util;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketOption;
import java.net.StandardProtocolFamily;
import java.net.StandardSocketOptions;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;
import java.nio.channels.NetworkChannel;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.nio.channels.spi.AbstractSelectableChannel;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.function.BiConsumer;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.smarthome.binding.lifx.internal.LifxSelectorContext;
import org.eclipse.smarthome.binding.lifx.internal.fields.MACAddress;
import org.eclipse.smarthome.binding.lifx.internal.protocol.Packet;
import org.eclipse.smarthome.binding.lifx.internal.protocol.PacketFactory;
import org.eclipse.smarthome.binding.lifx.internal.protocol.PacketHandler;
import org.eclipse.smarthome.binding.lifx.internal.util.LifxNetworkUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
public class LifxSelectorUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(LifxSelectorUtil.class);
    private static final int MAX_SEND_SELECT_RETRIES = 10;
    private static final int SEND_SELECT_TIMEOUT = 200;

    public static @Nullable SelectionKey openBroadcastChannel(@Nullable Selector selector, String logId, int broadcastPort) throws IOException {
        if (selector == null) {
            return null;
        }
        NetworkChannel broadcastChannel = ((DatagramChannel)DatagramChannel.open(StandardProtocolFamily.INET).setOption((SocketOption)StandardSocketOptions.SO_REUSEADDR, (Object)true)).setOption((SocketOption)StandardSocketOptions.SO_BROADCAST, (Object)true);
        ((AbstractSelectableChannel)((Object)broadcastChannel)).configureBlocking(false);
        LOGGER.debug("{} : Binding the broadcast channel on port {}", (Object)logId, (Object)broadcastPort);
        ((DatagramChannel)broadcastChannel).bind(new InetSocketAddress(broadcastPort));
        return ((SelectableChannel)((Object)broadcastChannel)).register(selector, 5);
    }

    public static @Nullable SelectionKey openUnicastChannel(@Nullable Selector selector, String logId, @Nullable InetSocketAddress address) throws IOException {
        if (selector == null || address == null) {
            return null;
        }
        NetworkChannel unicastChannel = DatagramChannel.open(StandardProtocolFamily.INET).setOption((SocketOption)StandardSocketOptions.SO_REUSEADDR, (Object)true);
        ((AbstractSelectableChannel)((Object)unicastChannel)).configureBlocking(false);
        ((DatagramChannel)unicastChannel).connect(address);
        LOGGER.trace("{} : Connected to light via {}", (Object)logId, (Object)((DatagramChannel)unicastChannel).getLocalAddress().toString());
        return ((SelectableChannel)((Object)unicastChannel)).register(selector, 5);
    }

    public static void closeSelector(@Nullable Selector selector, String logId) {
        if (selector == null) {
            return;
        }
        try {
            selector.wakeup();
            boolean done = false;
            while (!done) {
                try {
                    selector.keys().stream().forEach(key -> LifxSelectorUtil.cancelKey(key, logId));
                    done = true;
                }
                catch (ConcurrentModificationException e) {
                    LOGGER.debug("{} while closing selection keys of the light ({}): {}", new Object[]{e.getClass().getSimpleName(), logId, e.getMessage()});
                }
            }
            selector.close();
        }
        catch (IOException e) {
            LOGGER.warn("{} while closing the selector of the light ({}): {}", new Object[]{e.getClass().getSimpleName(), logId, e.getMessage()});
        }
    }

    public static void cancelKey(@Nullable SelectionKey key, String logId) {
        if (key == null) {
            return;
        }
        try {
            key.channel().close();
        }
        catch (IOException e) {
            LOGGER.error("{} while closing a channel of the light ({}): {}", new Object[]{e.getClass().getSimpleName(), logId, e.getMessage()});
        }
        key.cancel();
    }

    public static void receiveAndHandlePackets(Selector selector, String logId, BiConsumer<Packet, InetSocketAddress> packetConsumer) {
        try {
            selector.selectNow();
        }
        catch (IOException e) {
            LOGGER.error("{} while selecting keys for the light ({}) : {}", new Object[]{e.getClass().getSimpleName(), logId, e.getMessage()});
        }
        Iterator<SelectionKey> keyIterator = selector.selectedKeys().iterator();
        while (keyIterator.hasNext()) {
            SelectionKey key;
            try {
                key = keyIterator.next();
            }
            catch (ConcurrentModificationException concurrentModificationException) {
                LOGGER.debug("{} : Restarting iteration after ConcurrentModificationException", (Object)logId);
                keyIterator = selector.selectedKeys().iterator();
                continue;
            }
            if (!key.isValid() || !key.isReadable()) continue;
            LOGGER.trace("{} : Channel is ready for reading", (Object)logId);
            SelectableChannel channel = key.channel();
            ByteBuffer readBuffer = ByteBuffer.allocate(LifxNetworkUtil.getBufferSize());
            try {
                InetSocketAddress address;
                if (channel instanceof DatagramChannel) {
                    address = (InetSocketAddress)((DatagramChannel)channel).receive(readBuffer);
                    if (!LifxNetworkUtil.isRemoteAddress(address.getAddress())) continue;
                    LifxSelectorUtil.supplyParsedPacketToConsumer(readBuffer, address, packetConsumer, logId);
                    continue;
                }
                if (!(channel instanceof SocketChannel)) continue;
                address = (InetSocketAddress)((SocketChannel)channel).getRemoteAddress();
                ((SocketChannel)channel).read(readBuffer);
                if (!LifxNetworkUtil.isRemoteAddress(address.getAddress())) continue;
                LifxSelectorUtil.supplyParsedPacketToConsumer(readBuffer, address, packetConsumer, logId);
            }
            catch (Exception e) {
                LOGGER.debug("{} while reading data for the light ({}) : {}", new Object[]{e.getClass().getSimpleName(), logId, e.getMessage()});
            }
        }
    }

    private static void supplyParsedPacketToConsumer(ByteBuffer readBuffer, InetSocketAddress address, BiConsumer<Packet, InetSocketAddress> packetConsumer, String logId) {
        int messageLength = readBuffer.position();
        readBuffer.rewind();
        ByteBuffer packetSize = readBuffer.slice();
        packetSize.position(0);
        packetSize.limit(2);
        int size = Packet.FIELD_SIZE.value(packetSize);
        if (messageLength == size) {
            ByteBuffer packetType = readBuffer.slice();
            packetType.position(32);
            packetType.limit(34);
            int type = Packet.FIELD_PACKET_TYPE.value(packetType);
            PacketHandler<?> handler = PacketFactory.createHandler(type);
            if (handler == null) {
                LOGGER.trace("{} : Unknown packet type: {} (source: {})", new Object[]{logId, String.format("0x%02X", type), address.toString()});
            } else {
                Object packet = handler.handle(readBuffer);
                packetConsumer.accept((Packet)packet, address);
            }
        }
    }

    public static boolean broadcastPacket(@Nullable LifxSelectorContext context, Packet packet) {
        if (context == null) {
            return false;
        }
        packet.setSource(context.getSourceId());
        packet.setSequence(context.getSequenceNumberSupplier().get());
        boolean success = true;
        for (InetSocketAddress address : LifxNetworkUtil.getBroadcastAddresses()) {
            boolean bl = success = success && LifxSelectorUtil.sendPacket(context, packet, address, CastType.BROADCAST);
        }
        return success;
    }

    public static String getLogId(@Nullable MACAddress macAddress, @Nullable InetSocketAddress host) {
        return macAddress != null ? macAddress.getHex() : (host != null ? host.getHostString() : "Unknown");
    }

    public static boolean sendPacket(@Nullable LifxSelectorContext context, Packet packet) {
        if (context == null) {
            return false;
        }
        InetSocketAddress host = context.getHost();
        if (host == null) {
            return false;
        }
        packet.setSource(context.getSourceId());
        packet.setTarget(context.getMACAddress());
        packet.setSequence(context.getSequenceNumberSupplier().get());
        return LifxSelectorUtil.sendPacket(context, packet, host, CastType.UNICAST);
    }

    public static boolean resendPacket(@Nullable LifxSelectorContext context, Packet packet) {
        if (context == null) {
            return false;
        }
        InetSocketAddress host = context.getHost();
        if (host == null) {
            return false;
        }
        packet.setSource(context.getSourceId());
        packet.setTarget(context.getMACAddress());
        return LifxSelectorUtil.sendPacket(context, packet, host, CastType.UNICAST);
    }

    /*
     * Exception decompiling
     */
    private static boolean sendPacket(@Nullable LifxSelectorContext context, Packet packet, InetSocketAddress address, CastType castType) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [8[DOLOOP]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    static enum CastType {
        BROADCAST,
        UNICAST;

    }
}

