/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.mqtt.generic.internal.convention.homeassistant;

import java.lang.ref.WeakReference;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.smarthome.binding.mqtt.generic.internal.convention.homeassistant.AbstractComponent;
import org.eclipse.smarthome.binding.mqtt.generic.internal.convention.homeassistant.CFactory;
import org.eclipse.smarthome.binding.mqtt.generic.internal.convention.homeassistant.HaID;
import org.eclipse.smarthome.binding.mqtt.generic.internal.generic.ChannelStateUpdateListener;
import org.eclipse.smarthome.core.thing.ThingUID;
import org.eclipse.smarthome.io.transport.mqtt.MqttBrokerConnection;
import org.eclipse.smarthome.io.transport.mqtt.MqttMessageSubscriber;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
public class DiscoverComponents
implements MqttMessageSubscriber {
    private final Logger logger = LoggerFactory.getLogger(DiscoverComponents.class);
    private final ThingUID thingUID;
    protected @Nullable HaID topicDescription;
    private final ScheduledExecutorService scheduler;
    private @Nullable ScheduledFuture<?> scheduledFuture;
    private WeakReference<@Nullable MqttBrokerConnection> connectionRef = new WeakReference<Object>(null);
    protected final CompletableFuture<@Nullable Void> discoverFinishedFuture = new CompletableFuture();
    protected ComponentDiscovered componentsDiscoveredListener = (t, c) -> {};
    private final @Nullable ChannelStateUpdateListener channelStateUpdateListener;
    private int discoverTime;
    private String topicWithNode = "";
    private String topic = "";

    public DiscoverComponents(ThingUID thingUID, ScheduledExecutorService scheduler, @Nullable ChannelStateUpdateListener channelStateUpdateListener) {
        this.thingUID = thingUID;
        this.scheduler = scheduler;
        this.channelStateUpdateListener = channelStateUpdateListener;
    }

    public void processMessage(String topic, byte[] payload) {
        if (!topic.endsWith("/config")) {
            return;
        }
        HaID haID = new HaID(topic);
        String config = new String(payload);
        AbstractComponent component = CFactory.createComponent(this.thingUID, haID, config, this.channelStateUpdateListener);
        if (component != null) {
            this.logger.trace("Found HomeAssistant thing {} component {}", (Object)haID.objectID, (Object)haID.component);
            this.componentsDiscoveredListener.componentDiscovered(haID, component);
        } else {
            this.logger.debug("Configuration of HomeAssistant thing {} invalid: {}", (Object)haID.objectID, (Object)config);
        }
    }

    public CompletableFuture<@Nullable Void> startDiscovery(MqttBrokerConnection connection, int discoverTime, HaID topicDescription, ComponentDiscovered componentsDiscoveredListener) {
        this.topicWithNode = String.valueOf(topicDescription.baseTopic) + "/+/+/" + topicDescription.objectID + "/config";
        this.topic = String.valueOf(topicDescription.baseTopic) + "/+/" + topicDescription.objectID + "/config";
        this.discoverTime = discoverTime;
        this.componentsDiscoveredListener = componentsDiscoveredListener;
        this.connectionRef = new WeakReference<MqttBrokerConnection>(connection);
        ((CompletableFuture)CompletableFuture.allOf(connection.subscribe(this.topic, (MqttMessageSubscriber)this), connection.subscribe(this.topicWithNode, (MqttMessageSubscriber)this)).thenRun(this::subscribeSuccess)).exceptionally(this::subscribeFail);
        return this.discoverFinishedFuture;
    }

    private void subscribeSuccess() {
        MqttBrokerConnection connection = (MqttBrokerConnection)this.connectionRef.get();
        if (connection != null && this.discoverTime > 0) {
            this.scheduledFuture = this.scheduler.schedule(() -> {
                this.scheduledFuture = null;
                connection.unsubscribe(this.topicWithNode, (MqttMessageSubscriber)this);
                connection.unsubscribe(this.topic, (MqttMessageSubscriber)this);
                this.componentsDiscoveredListener = (t, c) -> {};
                this.discoverFinishedFuture.complete(null);
            }, (long)this.discoverTime, TimeUnit.MILLISECONDS);
        } else {
            this.discoverFinishedFuture.complete(null);
        }
    }

    private @Nullable Void subscribeFail(Throwable e) {
        ScheduledFuture<?> scheduledFuture = this.scheduledFuture;
        if (scheduledFuture != null) {
            scheduledFuture.cancel(false);
            this.scheduledFuture = null;
        }
        this.componentsDiscoveredListener = (t, c) -> {};
        MqttBrokerConnection connection = (MqttBrokerConnection)this.connectionRef.get();
        if (connection != null) {
            connection.unsubscribe(this.topicWithNode, (MqttMessageSubscriber)this);
            connection.unsubscribe(this.topic, (MqttMessageSubscriber)this);
            this.connectionRef.clear();
        }
        this.discoverFinishedFuture.completeExceptionally(e);
        return null;
    }

    public void stopDiscovery() {
        this.subscribeFail(new Throwable("Stopped"));
    }

    public static interface ComponentDiscovered {
        public void componentDiscovered(HaID var1, AbstractComponent var2);
    }
}

