/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.mqtt.generic.internal.generic;

import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.smarthome.binding.mqtt.generic.internal.generic.ChannelConfig;

@NonNullByDefault
public class ChannelConfigBuilder {
    private final ChannelConfig config = new ChannelConfig();

    private ChannelConfigBuilder() {
    }

    public static ChannelConfigBuilder create() {
        return new ChannelConfigBuilder();
    }

    public static ChannelConfigBuilder create(@Nullable String stateTopic, @Nullable String commandTopic) {
        return new ChannelConfigBuilder().withStateTopic(stateTopic).withCommandTopic(commandTopic);
    }

    public ChannelConfig build() {
        return this.config;
    }

    public ChannelConfigBuilder withStateTopic(@Nullable String topic) {
        if (topic != null) {
            this.config.stateTopic = topic;
        }
        return this;
    }

    public ChannelConfigBuilder withCommandTopic(@Nullable String topic) {
        if (topic != null) {
            this.config.commandTopic = topic;
        }
        return this;
    }

    public ChannelConfigBuilder withRetain(boolean retain) {
        this.config.retained = retain;
        return this;
    }

    public ChannelConfigBuilder makeTrigger(boolean trigger) {
        this.config.trigger = trigger;
        return this;
    }
}

