/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.mqtt.generic.internal.generic;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.IllegalFormatException;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.smarthome.binding.mqtt.generic.internal.generic.ChannelConfig;
import org.eclipse.smarthome.binding.mqtt.generic.internal.generic.ChannelStateTransformation;
import org.eclipse.smarthome.binding.mqtt.generic.internal.generic.ChannelStateUpdateListener;
import org.eclipse.smarthome.binding.mqtt.generic.internal.values.Value;
import org.eclipse.smarthome.core.thing.ChannelUID;
import org.eclipse.smarthome.core.types.Command;
import org.eclipse.smarthome.core.types.State;
import org.eclipse.smarthome.io.transport.mqtt.MqttBrokerConnection;
import org.eclipse.smarthome.io.transport.mqtt.MqttMessageSubscriber;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
public class ChannelState
implements MqttMessageSubscriber {
    private final Logger logger = LoggerFactory.getLogger(ChannelState.class);
    protected final boolean readOnly;
    protected final ChannelUID channelUID;
    protected final ChannelConfig config;
    protected final Value value;
    protected @Nullable MqttBrokerConnection connection;
    protected final List<ChannelStateTransformation> transformations = new ArrayList<ChannelStateTransformation>();
    private @Nullable ChannelStateUpdateListener channelStateUpdateListener;
    protected boolean hasSubscribed = false;
    private @Nullable ScheduledFuture<?> scheduledFuture;
    private CompletableFuture<@Nullable Void> future = new CompletableFuture();

    public ChannelState(ChannelConfig config, ChannelUID channelUID, Value value, @Nullable ChannelStateUpdateListener channelStateUpdateListener) {
        this.config = config;
        this.channelStateUpdateListener = channelStateUpdateListener;
        this.channelUID = channelUID;
        this.value = value;
        this.readOnly = StringUtils.isBlank((String)config.commandTopic);
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void addTransformation(ChannelStateTransformation transformation) {
        this.transformations.add(transformation);
    }

    public void clearTransformations() {
        this.transformations.clear();
    }

    public Value getValue() {
        return this.value;
    }

    public ChannelUID channelUID() {
        return this.channelUID;
    }

    public void processMessage(String topic, byte[] payload) {
        ChannelStateUpdateListener channelStateUpdateListener = this.channelStateUpdateListener;
        if (channelStateUpdateListener == null) {
            this.logger.warn("MQTT message received, but MessageSubscriber object hasn't been started!", (Object)topic);
            return;
        }
        String strvalue = new String(payload, StandardCharsets.UTF_8);
        for (ChannelStateTransformation t : this.transformations) {
            strvalue = t.processValue(strvalue);
        }
        if (this.config.trigger) {
            channelStateUpdateListener.triggerChannel(this.channelUID, strvalue);
        } else {
            try {
                State updatedState = this.value.update(strvalue);
                if (this.config.postCommand) {
                    channelStateUpdateListener.postChannelState(this.channelUID, (Command)updatedState);
                } else {
                    channelStateUpdateListener.updateChannelState(this.channelUID, updatedState);
                }
            }
            catch (IllegalArgumentException e) {
                this.logger.warn("Incoming payload '{}' not supported by type '{}': {}", new Object[]{strvalue, this.value.getClass().getSimpleName(), e.getMessage()});
            }
        }
        this.receivedOrTimeout();
    }

    public String getStateTopic() {
        return this.config.stateTopic;
    }

    public String getCommandTopic() {
        return this.config.commandTopic;
    }

    public String getItemType() {
        return this.value.getItemType();
    }

    public boolean isStateful() {
        return this.config.retained;
    }

    public CompletableFuture<@Nullable Void> stop() {
        MqttBrokerConnection connection = this.connection;
        if (connection != null && StringUtils.isNotBlank((String)this.config.stateTopic)) {
            return connection.unsubscribe(this.config.stateTopic, (MqttMessageSubscriber)this).thenRun(this::internalStop);
        }
        this.internalStop();
        return CompletableFuture.completedFuture(null);
    }

    private void internalStop() {
        this.connection = null;
        this.channelStateUpdateListener = null;
        this.hasSubscribed = false;
        this.value.resetState();
    }

    private void receivedOrTimeout() {
        ScheduledFuture<?> scheduledFuture = this.scheduledFuture;
        if (scheduledFuture != null) {
            scheduledFuture.cancel(false);
            this.scheduledFuture = null;
        }
        this.future.complete(null);
    }

    private @Nullable Void subscribeFail(Throwable e) {
        ScheduledFuture<?> scheduledFuture = this.scheduledFuture;
        if (scheduledFuture != null) {
            scheduledFuture.cancel(false);
            this.scheduledFuture = null;
        }
        this.future.completeExceptionally(e);
        return null;
    }

    public CompletableFuture<@Nullable Void> start(MqttBrokerConnection connection, ScheduledExecutorService scheduler, int timeout) {
        if (this.hasSubscribed) {
            return CompletableFuture.completedFuture(null);
        }
        this.connection = connection;
        if (StringUtils.isBlank((String)this.config.stateTopic)) {
            return CompletableFuture.completedFuture(null);
        }
        this.future = new CompletableFuture();
        ((CompletableFuture)connection.subscribe(this.config.stateTopic, (MqttMessageSubscriber)this).thenRun(() -> {
            this.hasSubscribed = true;
            if (timeout > 0 && !this.future.isDone()) {
                this.scheduledFuture = scheduler.schedule(this::receivedOrTimeout, (long)timeout, TimeUnit.MILLISECONDS);
            } else {
                this.receivedOrTimeout();
            }
        })).exceptionally(this::subscribeFail);
        return this.future;
    }

    public boolean hasSubscribed() {
        return this.hasSubscribed;
    }

    public CompletableFuture<@Nullable Void> setValue(Command command) {
        String mqttCommandValue = this.getValue().update(command);
        MqttBrokerConnection connection = this.connection;
        if (!this.readOnly && connection != null) {
            if (this.config.formatBeforePublish.length() > 0) {
                try {
                    Throwable throwable = null;
                    Object var5_8 = null;
                    try (Formatter formatter = new Formatter();){
                        Formatter format = formatter.format(this.config.formatBeforePublish, mqttCommandValue);
                        mqttCommandValue = format.toString();
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (IllegalFormatException e) {
                    this.logger.debug("Format pattern incorrect for {}", (Object)this.channelUID, (Object)e);
                }
            }
            return connection.publish(this.config.commandTopic, mqttCommandValue.getBytes(), 1, this.config.retained).thenRun(() -> {});
        }
        CompletableFuture<@Nullable Void> f = new CompletableFuture<Void>();
        f.completeExceptionally(new IllegalStateException("No connection or readOnly channel!"));
        return f;
    }

    public @Nullable ChannelStateUpdateListener getChannelStateUpdateListener() {
        return this.channelStateUpdateListener;
    }

    public void setChannelStateUpdateListener(ChannelStateUpdateListener channelStateUpdateListener) {
        this.channelStateUpdateListener = channelStateUpdateListener;
    }
}

