/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.mqtt.generic.internal.handler;

import java.util.List;
import java.util.TreeMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.smarthome.binding.mqtt.generic.internal.convention.homie300.Device;
import org.eclipse.smarthome.binding.mqtt.generic.internal.convention.homie300.DeviceAttributes;
import org.eclipse.smarthome.binding.mqtt.generic.internal.convention.homie300.DeviceCallback;
import org.eclipse.smarthome.binding.mqtt.generic.internal.convention.homie300.DeviceStatsAttributes;
import org.eclipse.smarthome.binding.mqtt.generic.internal.convention.homie300.HandlerConfiguration;
import org.eclipse.smarthome.binding.mqtt.generic.internal.convention.homie300.Node;
import org.eclipse.smarthome.binding.mqtt.generic.internal.convention.homie300.Property;
import org.eclipse.smarthome.binding.mqtt.generic.internal.generic.ChannelState;
import org.eclipse.smarthome.binding.mqtt.generic.internal.generic.MqttChannelTypeProvider;
import org.eclipse.smarthome.binding.mqtt.generic.internal.handler.AbstractMQTTThingHandler;
import org.eclipse.smarthome.binding.mqtt.generic.internal.tools.DelayedBatchProcessing;
import org.eclipse.smarthome.core.thing.ChannelUID;
import org.eclipse.smarthome.core.thing.Thing;
import org.eclipse.smarthome.core.thing.ThingStatus;
import org.eclipse.smarthome.core.thing.ThingStatusDetail;
import org.eclipse.smarthome.io.transport.mqtt.MqttBrokerConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
public class HomieThingHandler
extends AbstractMQTTThingHandler
implements DeviceCallback,
Consumer<List<Object>> {
    private final Logger logger = LoggerFactory.getLogger(HomieThingHandler.class);
    protected Device device;
    protected final MqttChannelTypeProvider channelTypeProvider;
    protected final int attributeReceiveTimeout;
    protected final int subscribeTimeout;
    protected HandlerConfiguration config = new HandlerConfiguration();
    protected DelayedBatchProcessing<Object> delayedProcessing;
    private @Nullable ScheduledFuture<?> heartBeatTimer;

    public HomieThingHandler(Thing thing, MqttChannelTypeProvider channelTypeProvider, int subscribeTimeout, int attributeReceiveTimeout) {
        super(thing, subscribeTimeout);
        this.channelTypeProvider = channelTypeProvider;
        this.subscribeTimeout = subscribeTimeout;
        this.attributeReceiveTimeout = attributeReceiveTimeout;
        this.delayedProcessing = new DelayedBatchProcessing<Object>(subscribeTimeout, this, this.scheduler);
        this.device = new Device(this.thing.getUID(), this, new DeviceAttributes(), new DeviceStatsAttributes());
    }

    protected void setInternalObjects(Device device, DelayedBatchProcessing<Object> delayedProcessing) {
        this.device = device;
        this.delayedProcessing = delayedProcessing;
    }

    @Override
    public void initialize() {
        this.config = (HandlerConfiguration)this.getConfigAs(HandlerConfiguration.class);
        if (this.config.deviceid.isEmpty()) {
            this.updateStatus(ThingStatus.OFFLINE, ThingStatusDetail.CONFIGURATION_ERROR, "Object ID unknown");
            return;
        }
        this.device.initialize(this.config.basetopic, this.config.deviceid, this.thing.getChannels());
        super.initialize();
    }

    @Override
    protected CompletableFuture<@Nullable Void> start(MqttBrokerConnection connection) {
        connection.setRetain(true);
        connection.setQos(1);
        return this.device.subscribe(connection, this.scheduler, this.attributeReceiveTimeout);
    }

    @Override
    protected void stop() {
        ScheduledFuture<?> heartBeatTimer = this.heartBeatTimer;
        if (heartBeatTimer != null) {
            heartBeatTimer.cancel(false);
            this.heartBeatTimer = null;
        }
        this.delayedProcessing.join();
        this.device.stop();
    }

    @Override
    public @Nullable ChannelState getChannelState(ChannelUID channelUID) {
        Property property = this.device.getProperty(channelUID);
        return property != null ? property.getChannelState() : null;
    }

    @Override
    public void readyStateChanged(DeviceAttributes.ReadyState state) {
        switch (state) {
            case alert: {
                this.updateStatus(ThingStatus.ONLINE, ThingStatusDetail.CONFIGURATION_ERROR);
                break;
            }
            case disconnected: {
                this.updateStatus(ThingStatus.OFFLINE);
                break;
            }
            case init: {
                this.updateStatus(ThingStatus.ONLINE, ThingStatusDetail.CONFIGURATION_PENDING);
                break;
            }
            case lost: {
                this.updateStatus(ThingStatus.OFFLINE, ThingStatusDetail.GONE, "Device did not send heartbeat in time");
                break;
            }
            case ready: {
                this.updateStatus(ThingStatus.ONLINE);
                break;
            }
            case sleeping: {
                this.updateStatus(ThingStatus.ONLINE, ThingStatusDetail.DUTY_CYCLE);
                break;
            }
            case unknown: {
                this.updateStatus(ThingStatus.OFFLINE, ThingStatusDetail.GONE, "Device did not publish a ready state");
                break;
            }
        }
    }

    @Override
    public void statisticAttributesChanged(DeviceStatsAttributes stats) {
        TreeMap<String, String> properties = new TreeMap<String, String>();
        properties.put("interval", String.valueOf(stats.interval));
        this.updateProperties(properties);
    }

    @Override
    public void nodeRemoved(Node node) {
        this.channelTypeProvider.removeChannelGroupType(node.channelGroupTypeUID);
        this.delayedProcessing.accept(node);
    }

    @Override
    public void propertyRemoved(Property property) {
        this.channelTypeProvider.removeChannelType(property.channelTypeUID);
        this.delayedProcessing.accept(property);
    }

    @Override
    public void nodeAddedOrChanged(Node node) {
        this.channelTypeProvider.setChannelGroupType(node.channelGroupTypeUID, node.type());
        this.delayedProcessing.accept(node);
    }

    @Override
    public void propertyAddedOrChanged(Property property) {
        this.channelTypeProvider.setChannelType(property.channelTypeUID, property.getType());
        this.delayedProcessing.accept(property);
    }

    @Override
    public void accept(@Nullable List<Object> t) {
        if (!this.device.isInitialized()) {
            return;
        }
        List channels = this.device.nodes().stream().flatMap(n -> n.properties.stream()).map(prop -> prop.getChannel()).collect(Collectors.toList());
        this.updateThing(this.editThing().withChannels(channels).build());
        this.updateProperty("homieversion", this.device.attributes.homie);
        MqttBrokerConnection connection = this.connection;
        if (connection != null) {
            this.device.startChannels(connection, this.scheduler, this.attributeReceiveTimeout, this).thenRun(() -> this.logger.trace("Homie device {} fully attached", (Object)this.device.attributes.name));
        }
    }

    protected void heartbeatFailed() {
        this.readyStateChanged(DeviceAttributes.ReadyState.lost);
    }

    @Override
    public void heartbeatIntervalChanged(int intervalInSec) {
        ScheduledFuture<?> scheduledFuture = this.heartBeatTimer;
        if (scheduledFuture != null) {
            scheduledFuture.cancel(false);
            this.heartBeatTimer = null;
        }
        if (intervalInSec > 0) {
            this.heartBeatTimer = this.scheduler.schedule(this::heartbeatFailed, (long)intervalInSec, TimeUnit.SECONDS);
        }
        this.updateProperty("heartbeat_interval", String.valueOf(this.device.stats.interval));
        if (this.thing.getStatus() == ThingStatus.OFFLINE) {
            this.readyStateChanged(this.device.attributes.state);
        }
    }
}

