/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.mqtt.generic.internal.tools;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;

@NonNullByDefault
public class DelayedBatchProcessing<TYPE>
implements Consumer<TYPE> {
    private final int delay;
    private final Consumer<List<TYPE>> consumer;
    private final List<TYPE> queue = Collections.synchronizedList(new ArrayList());
    private final ScheduledExecutorService executor;
    protected @Nullable ScheduledFuture<?> future;

    public DelayedBatchProcessing(int delay, Consumer<List<TYPE>> consumer, ScheduledExecutorService executor) {
        this.delay = delay;
        this.consumer = consumer;
        this.executor = executor;
        if (delay <= 0) {
            throw new IllegalArgumentException("Delay need to be greater than 0!");
        }
    }

    @Override
    public void accept(TYPE t) {
        this.queue.add(t);
        ScheduledFuture<?> scheduledFuture = this.future;
        if (scheduledFuture == null || scheduledFuture.isDone()) {
            this.future = this.executor.schedule(this::run, (long)this.delay, TimeUnit.MILLISECONDS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<TYPE> join() {
        ScheduledFuture<?> scheduledFuture = this.future;
        if (scheduledFuture != null && !scheduledFuture.isDone()) {
            scheduledFuture.cancel(false);
        }
        ArrayList<TYPE> lqueue = new ArrayList<TYPE>();
        List<TYPE> list = this.queue;
        synchronized (list) {
            lqueue.addAll(this.queue);
            this.queue.clear();
        }
        return lqueue;
    }

    public boolean isArmed() {
        ScheduledFuture<?> scheduledFuture = this.future;
        return scheduledFuture != null && !scheduledFuture.isDone();
    }

    public void forceProcessNow() {
        ScheduledFuture<?> scheduledFuture = this.future;
        if (scheduledFuture != null && !scheduledFuture.isDone()) {
            scheduledFuture.cancel(false);
        }
        this.run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void run() {
        ArrayList<TYPE> lqueue = new ArrayList<TYPE>();
        List<TYPE> list = this.queue;
        synchronized (list) {
            lqueue.addAll(this.queue);
            this.queue.clear();
        }
        if (!lqueue.isEmpty()) {
            this.consumer.accept(lqueue);
        }
    }
}

